// license:BSD-3-Clause
// copyright-holders:Luca Elia, Vas Crabb
#include "emu.h"
#include "mahjong.h"


INPUT_PORTS_START( igs_mahjong_matrix )
	//                                                      // Traditional  Simplified  English

	PORT_START("KEY0")
	PORT_BIT(0x01, IP_ACTIVE_LOW, IPT_MAHJONG_A)
	PORT_BIT(0x02, IP_ACTIVE_LOW, IPT_MAHJONG_E)
	PORT_BIT(0x04, IP_ACTIVE_LOW, IPT_MAHJONG_I)
	PORT_BIT(0x08, IP_ACTIVE_LOW, IPT_MAHJONG_M)
	PORT_BIT(0x10, IP_ACTIVE_LOW, IPT_MAHJONG_KAN)          // 槓           杠          GUN
	PORT_BIT(0x20, IP_ACTIVE_LOW, IPT_START1)               // 開始         开始        START
	PORT_BIT(0xc0, IP_ACTIVE_LOW, IPT_UNKNOWN)

	PORT_START("KEY1")
	PORT_BIT(0x01, IP_ACTIVE_LOW, IPT_MAHJONG_B)
	PORT_BIT(0x02, IP_ACTIVE_LOW, IPT_MAHJONG_F)
	PORT_BIT(0x04, IP_ACTIVE_LOW, IPT_MAHJONG_J)
	PORT_BIT(0x08, IP_ACTIVE_LOW, IPT_MAHJONG_N)
	PORT_BIT(0x10, IP_ACTIVE_LOW, IPT_MAHJONG_REACH)        // 聽           听          LISTEN
	PORT_BIT(0x20, IP_ACTIVE_LOW, IPT_MAHJONG_BET)          // 押注/押      押注/押     BET
	PORT_BIT(0xc0, IP_ACTIVE_LOW, IPT_UNKNOWN)

	PORT_START("KEY2")
	PORT_BIT(0x01, IP_ACTIVE_LOW, IPT_MAHJONG_C)
	PORT_BIT(0x02, IP_ACTIVE_LOW, IPT_MAHJONG_G)
	PORT_BIT(0x04, IP_ACTIVE_LOW, IPT_MAHJONG_K)
	PORT_BIT(0x08, IP_ACTIVE_LOW, IPT_MAHJONG_CHI)          // 吃           吃          EAT
	PORT_BIT(0x10, IP_ACTIVE_LOW, IPT_MAHJONG_RON)          // 胡           胡          WHO
	PORT_BIT(0xe0, IP_ACTIVE_LOW, IPT_UNKNOWN)

	PORT_START("KEY3")
	PORT_BIT(0x01, IP_ACTIVE_LOW, IPT_MAHJONG_D)
	PORT_BIT(0x02, IP_ACTIVE_LOW, IPT_MAHJONG_H)
	PORT_BIT(0x04, IP_ACTIVE_LOW, IPT_MAHJONG_L)
	PORT_BIT(0x08, IP_ACTIVE_LOW, IPT_MAHJONG_PON)          // 碰           碰          PON
	PORT_BIT(0xf0, IP_ACTIVE_LOW, IPT_UNKNOWN)

	PORT_START("KEY4")
	PORT_BIT(0x01, IP_ACTIVE_LOW, IPT_MAHJONG_LAST_CHANCE)  // 海底         海底
	PORT_BIT(0x02, IP_ACTIVE_LOW, IPT_MAHJONG_SCORE)        // 得分         續玩        TAKE
	PORT_BIT(0x04, IP_ACTIVE_LOW, IPT_MAHJONG_DOUBLE_UP)    // 比倍/續玩    比倍/续玩   DUP
	PORT_BIT(0x08, IP_ACTIVE_LOW, IPT_UNKNOWN)
	PORT_BIT(0x10, IP_ACTIVE_LOW, IPT_MAHJONG_BIG)          // 大/左        大/左       BIG
	PORT_BIT(0x20, IP_ACTIVE_LOW, IPT_MAHJONG_SMALL)        // 小/右        小/右       SMALL
	PORT_BIT(0xc0, IP_ACTIVE_LOW, IPT_UNKNOWN)
INPUT_PORTS_END
