// license:BSD-3-Clause
// copyright-holders:David Haywood
/* MPU4 games by 'Empire' */

#include "emu.h"
#include "includes/mpu4.h"

INPUT_PORTS_EXTERN( mpu4 );

#include "m4apachg.lh"

void mpu4_state::init_m4apachg()
{
	init_m4default();
	//Derived from Apache_Gold_(Empire)_[C02_800_25jp].gam
	init_m4_hopper_duart_a();
	init_m4_large_extender_b();
	init_m4default_reels();
	//PCKEY =b
	//STKEY =4
	//JPKEY =a
	//JPSET =5
	//DIP1_0=false
	//DIP1_1=true
	//DIP1_2=false
	//DIP1_3=true
	//DIP1_4=false
	//DIP1_5=false
	//DIP1_6=false
	//DIP1_7=false
	//DIP2_0=false
	//DIP2_1=false
	//DIP2_2=false
	//DIP2_3=true
	//DIP2_4=true
	//DIP2_5=false
	//DIP2_6=false
	//DIP2_7=false
	//Sound empire
	//Standard
	//Volume 0 Stereo= 1
	//Sample rate 16000
	//Front door code 0 Cash door code 0
}

ROM_START( m4apachg )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "ag0_3x.bin", 0x0000, 0x020000, CRC(b521b3fd) SHA1(ffdfd4a67f0eb1665f14274f2abc7f59d0050fe5) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "agsnd1.bin", 0x000000, 0x080000, CRC(4fcc8cf1) SHA1(339684ad1bf9f58782bb1ec0d1767fc98bb86b0f) )
	ROM_LOAD( "agsnd2.bin", 0x080000, 0x080000, CRC(d2824ef6) SHA1(32bf329c87a8ea7416cfc217519cd963d4d2430d) )
	ROM_LOAD( "agsnd3.bin", 0x100000, 0x080000, CRC(316549d6) SHA1(72fc19cbee363ba7c71801c480cb87ebf9e64e86) )
ROM_END

ROM_START( m4apachga )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "ag0_4.bin", 0x0000, 0x020000, CRC(99415578) SHA1(73f9947ecee575a4f284a2e3837ec6b87ac2c007) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "agsnd1.bin", 0x000000, 0x080000, CRC(4fcc8cf1) SHA1(339684ad1bf9f58782bb1ec0d1767fc98bb86b0f) )
	ROM_LOAD( "agsnd2.bin", 0x080000, 0x080000, CRC(d2824ef6) SHA1(32bf329c87a8ea7416cfc217519cd963d4d2430d) )
	ROM_LOAD( "agsnd3.bin", 0x100000, 0x080000, CRC(316549d6) SHA1(72fc19cbee363ba7c71801c480cb87ebf9e64e86) )
ROM_END

ROM_START( m4apachgb )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "ag0_4i.bin", 0x0000, 0x020000, CRC(4671a784) SHA1(ea95e82192ad6b53d19cc3c4166b872cd94396d1) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "agsnd1.bin", 0x000000, 0x080000, CRC(4fcc8cf1) SHA1(339684ad1bf9f58782bb1ec0d1767fc98bb86b0f) )
	ROM_LOAD( "agsnd2.bin", 0x080000, 0x080000, CRC(d2824ef6) SHA1(32bf329c87a8ea7416cfc217519cd963d4d2430d) )
	ROM_LOAD( "agsnd3.bin", 0x100000, 0x080000, CRC(316549d6) SHA1(72fc19cbee363ba7c71801c480cb87ebf9e64e86) )
ROM_END

ROM_START( m4apachgc )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "ag1_1x.bin", 0x0000, 0x020000, CRC(d478cd5f) SHA1(8e0adee7cc88ff072154a0db8ceee94d40046c01) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "agsnd1.bin", 0x000000, 0x080000, CRC(4fcc8cf1) SHA1(339684ad1bf9f58782bb1ec0d1767fc98bb86b0f) )
	ROM_LOAD( "agsnd2.bin", 0x080000, 0x080000, CRC(d2824ef6) SHA1(32bf329c87a8ea7416cfc217519cd963d4d2430d) )
	ROM_LOAD( "agsnd3.bin", 0x100000, 0x080000, CRC(316549d6) SHA1(72fc19cbee363ba7c71801c480cb87ebf9e64e86) )
ROM_END

ROM_START( m4apachgd )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "ag1_2.bin", 0x0000, 0x020000, CRC(aa857c28) SHA1(5fe95e59f97b2b6a9fa1996d6501c3230f955081) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "agsnd1.bin", 0x000000, 0x080000, CRC(4fcc8cf1) SHA1(339684ad1bf9f58782bb1ec0d1767fc98bb86b0f) )
	ROM_LOAD( "agsnd2.bin", 0x080000, 0x080000, CRC(d2824ef6) SHA1(32bf329c87a8ea7416cfc217519cd963d4d2430d) )
	ROM_LOAD( "agsnd3.bin", 0x100000, 0x080000, CRC(316549d6) SHA1(72fc19cbee363ba7c71801c480cb87ebf9e64e86) )
ROM_END

ROM_START( m4apachge )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "ag1_2i.bin", 0x0000, 0x020000, CRC(71c3fc7f) SHA1(48000f6068d967504d2bde4d5f9974dd102f7368) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "agsnd1.bin", 0x000000, 0x080000, CRC(4fcc8cf1) SHA1(339684ad1bf9f58782bb1ec0d1767fc98bb86b0f) )
	ROM_LOAD( "agsnd2.bin", 0x080000, 0x080000, CRC(d2824ef6) SHA1(32bf329c87a8ea7416cfc217519cd963d4d2430d) )
	ROM_LOAD( "agsnd3.bin", 0x100000, 0x080000, CRC(316549d6) SHA1(72fc19cbee363ba7c71801c480cb87ebf9e64e86) )
ROM_END

ROM_START( m4apachgf )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "ag2_0x.bin", 0x0000, 0x020000, CRC(083f9f62) SHA1(67beac70ec79c240bd231279abdc97b6eb1872a5) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "agsnd1.bin", 0x000000, 0x080000, CRC(4fcc8cf1) SHA1(339684ad1bf9f58782bb1ec0d1767fc98bb86b0f) )
	ROM_LOAD( "agsnd2.bin", 0x080000, 0x080000, CRC(d2824ef6) SHA1(32bf329c87a8ea7416cfc217519cd963d4d2430d) )
	ROM_LOAD( "agsnd3.bin", 0x100000, 0x080000, CRC(316549d6) SHA1(72fc19cbee363ba7c71801c480cb87ebf9e64e86) )
ROM_END



ROM_START( m4bangrs )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "bnc3_0.bin", 0x0000, 0x010000, CRC(c30f947a) SHA1(c734bd966142023e2b7b498ba939972ed32c9fd6) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "bncsnd1.bin", 0x000000, 0x080000, CRC(593f29c7) SHA1(b743fa6a029b19570ccc31e5108dccec3a752849) )
	ROM_LOAD( "bncsnd2.bin", 0x080000, 0x080000, CRC(589170a9) SHA1(62ec8bfc4d834c07308d5105979b86452340e98b) )
ROM_END

ROM_START( m4bangrsa )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "bnc3_0i.bin", 0x0000, 0x010000, CRC(44afb119) SHA1(5145530fee853c7f63a65566bd1b58b62921dcac) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "bncsnd1.bin", 0x000000, 0x080000, CRC(593f29c7) SHA1(b743fa6a029b19570ccc31e5108dccec3a752849) )
	ROM_LOAD( "bncsnd2.bin", 0x080000, 0x080000, CRC(589170a9) SHA1(62ec8bfc4d834c07308d5105979b86452340e98b) )
ROM_END

ROM_START( m4bangrsb )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "bnc3_0x.bin", 0x0000, 0x010000, CRC(ff267a9b) SHA1(0b07ef99233df32fdc9621b3f1dbca0549ad99a7) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "bncsnd1.bin", 0x000000, 0x080000, CRC(593f29c7) SHA1(b743fa6a029b19570ccc31e5108dccec3a752849) )
	ROM_LOAD( "bncsnd2.bin", 0x080000, 0x080000, CRC(589170a9) SHA1(62ec8bfc4d834c07308d5105979b86452340e98b) )
ROM_END


ROM_START( m4bankrd )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "br3_1x.bin", 0x0000, 0x010000, CRC(a7bc60b3) SHA1(73fc3c0f775b88ce4f8ccf7d60399371656c2144) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "raidsnd1.bin", 0x000000, 0x080000, CRC(97427f72) SHA1(ca68bbf9b701a78d69690cddb10bcdcc4214c161) )
	ROM_LOAD( "raidsnd2.bin", 0x080000, 0x080000, CRC(6bc06e6f) SHA1(8f821feeece6fa9b253d3b35c0bc05f0491c359c) )
ROM_END

ROM_START( m4bankrda )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "br0_2.bin", 0x0000, 0x010000, CRC(3368f610) SHA1(6af4f91675228d0bebca0b7fcfd4661c561d1e0b) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "raidsnd1.bin", 0x000000, 0x080000, CRC(97427f72) SHA1(ca68bbf9b701a78d69690cddb10bcdcc4214c161) )
	ROM_LOAD( "raidsnd2.bin", 0x080000, 0x080000, CRC(6bc06e6f) SHA1(8f821feeece6fa9b253d3b35c0bc05f0491c359c) )
ROM_END

ROM_START( m4bankrdb )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "br1_0i.bin", 0x0000, 0x010000, CRC(545aea13) SHA1(ed8b334ccde1581e4e0b3de15c5d42126cb5a752) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "raidsnd1.bin", 0x000000, 0x080000, CRC(97427f72) SHA1(ca68bbf9b701a78d69690cddb10bcdcc4214c161) )
	ROM_LOAD( "raidsnd2.bin", 0x080000, 0x080000, CRC(6bc06e6f) SHA1(8f821feeece6fa9b253d3b35c0bc05f0491c359c) )
ROM_END

ROM_START( m4bankrdc )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "br3_0.bin", 0x0000, 0x010000, CRC(3e6e2ede) SHA1(eb2b00e3eb62acef89d55dff0fa814c75b3df701) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "raidsnd1.bin", 0x000000, 0x080000, CRC(97427f72) SHA1(ca68bbf9b701a78d69690cddb10bcdcc4214c161) )
	ROM_LOAD( "raidsnd2.bin", 0x080000, 0x080000, CRC(6bc06e6f) SHA1(8f821feeece6fa9b253d3b35c0bc05f0491c359c) )
ROM_END

ROM_START( m4bankrdd )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "br3_0i.bin", 0x0000, 0x010000, CRC(b9ce0bbd) SHA1(92144925e0e389db4e0b1dcf88e6fb8d21ada8db) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "raidsnd1.bin", 0x000000, 0x080000, CRC(97427f72) SHA1(ca68bbf9b701a78d69690cddb10bcdcc4214c161) )
	ROM_LOAD( "raidsnd2.bin", 0x080000, 0x080000, CRC(6bc06e6f) SHA1(8f821feeece6fa9b253d3b35c0bc05f0491c359c) )
ROM_END



ROM_START( m4bigchs )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "bc1_2.bin", 0x0000, 0x020000, CRC(9d68a5f7) SHA1(3b7d7af95b9aaca2cbc249402cf1e3b074dc0817) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "bcsnd1.bin", 0x000000, 0x080000, CRC(7a0a5144) SHA1(84b8a5c58566cf769826023cc221741dd4d6dd0e) )
	ROM_LOAD( "bcsnd2.bin", 0x080000, 0x080000, CRC(9faf37ab) SHA1(03eb4918d7de6e472351a563f2beb652094b98f4) )
	ROM_LOAD( "bcsnd3.bin", 0x100000, 0x080000, CRC(cd6e26de) SHA1(d84274b3b4bc7126e19bf6c6e1aac561a7aaab77) )
ROM_END

ROM_START( m4bigchsa )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "bc1_2i.bin", 0x0000, 0x020000, CRC(462e25a0) SHA1(52e0b6f89a8c933eca0600e776419234c73e4bdc) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "bcsnd1.bin", 0x000000, 0x080000, CRC(7a0a5144) SHA1(84b8a5c58566cf769826023cc221741dd4d6dd0e) )
	ROM_LOAD( "bcsnd2.bin", 0x080000, 0x080000, CRC(9faf37ab) SHA1(03eb4918d7de6e472351a563f2beb652094b98f4) )
	ROM_LOAD( "bcsnd3.bin", 0x100000, 0x080000, CRC(cd6e26de) SHA1(d84274b3b4bc7126e19bf6c6e1aac561a7aaab77) )
ROM_END

ROM_START( m4bigchsb )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "bc1_2x.bin", 0x0000, 0x020000, CRC(2e418b81) SHA1(489c5a70d289176ad0f66fa630621e24b2c18ce1) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "bcsnd1.bin", 0x000000, 0x080000, CRC(7a0a5144) SHA1(84b8a5c58566cf769826023cc221741dd4d6dd0e) )
	ROM_LOAD( "bcsnd2.bin", 0x080000, 0x080000, CRC(9faf37ab) SHA1(03eb4918d7de6e472351a563f2beb652094b98f4) )
	ROM_LOAD( "bcsnd3.bin", 0x100000, 0x080000, CRC(cd6e26de) SHA1(d84274b3b4bc7126e19bf6c6e1aac561a7aaab77) )
ROM_END



ROM_START( m4cstrik )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cs3_1.bin", 0x0000, 0x020000, CRC(10b68449) SHA1(8e5688b8d240f4ed4429ddfd97366ca4c998b6ab) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "cssnd1.bin", 0x000000, 0x080000, CRC(a6fedbe0) SHA1(a687151734d378d5c9605be82a22ba50f256885f) )
	ROM_LOAD( "cssnd2.bin", 0x080000, 0x080000, CRC(6160f67c) SHA1(c781d47fe3c6f230442e19ca26523b34808b44a1) )
	ROM_LOAD( "cssnd3.bin", 0x100000, 0x080000, CRC(3911d57a) SHA1(2f0a3a15237876d04b5c9cb72648b27966cd7fb6) )
ROM_END

ROM_START( m4cstrika )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cs3_1i.bin", 0x0000, 0x020000, CRC(cbf0041e) SHA1(9baf9f209f1c4bf59f31437d07051a6cb71e877c) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "cssnd1.bin", 0x000000, 0x080000, CRC(a6fedbe0) SHA1(a687151734d378d5c9605be82a22ba50f256885f) )
	ROM_LOAD( "cssnd2.bin", 0x080000, 0x080000, CRC(6160f67c) SHA1(c781d47fe3c6f230442e19ca26523b34808b44a1) )
	ROM_LOAD( "cssnd3.bin", 0x100000, 0x080000, CRC(3911d57a) SHA1(2f0a3a15237876d04b5c9cb72648b27966cd7fb6) )
ROM_END

ROM_START( m4cstrikb )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cs3_1x.bin", 0x0000, 0x020000, CRC(d01bda0b) SHA1(528df320593656040b7491a0f3f24cc489b45722) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "cssnd1.bin", 0x000000, 0x080000, CRC(a6fedbe0) SHA1(a687151734d378d5c9605be82a22ba50f256885f) )
	ROM_LOAD( "cssnd2.bin", 0x080000, 0x080000, CRC(6160f67c) SHA1(c781d47fe3c6f230442e19ca26523b34808b44a1) )
	ROM_LOAD( "cssnd3.bin", 0x100000, 0x080000, CRC(3911d57a) SHA1(2f0a3a15237876d04b5c9cb72648b27966cd7fb6) )
ROM_END

ROM_START( m4cstrikc )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "c_strike", 0x0000, 0x020000, CRC(d1eac7c6) SHA1(e04a0865e2c55c9351d6bc44616c179a8f5ca059) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "cssnd1.bin", 0x000000, 0x080000, CRC(a6fedbe0) SHA1(a687151734d378d5c9605be82a22ba50f256885f) )
	ROM_LOAD( "cssnd2.bin", 0x080000, 0x080000, CRC(6160f67c) SHA1(c781d47fe3c6f230442e19ca26523b34808b44a1) )
	ROM_LOAD( "cssnd3.bin", 0x100000, 0x080000, CRC(3911d57a) SHA1(2f0a3a15237876d04b5c9cb72648b27966cd7fb6) )
ROM_END



ROM_START( m4chacec )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "ca1_0.bin", 0x0000, 0x020000, CRC(0c9a73b7) SHA1(2ee089ce89f29e804371fcfca82bf22a2ac3197b) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "casnd1.bin", 0x000000, 0x080000, CRC(9bbe8fe4) SHA1(2e5406d72ca731a5960be3a621bbd72064745677) )
	ROM_LOAD( "casnd2.bin", 0x080000, 0x080000, CRC(aa9a45d3) SHA1(47289537451aac1049f7a524b079f2912d97b7cf) )
	ROM_LOAD( "casnd3.bin", 0x100000, 0x080000, CRC(5764e36d) SHA1(6601946bda40886e3a606accd7c11b31efcdab28) )
ROM_END

ROM_START( m4chaceca )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "ca1_0x.bin", 0x0000, 0x020000, CRC(a2476d24) SHA1(12f86733c8fa34d84ff6a1840a24eb96bf547c3d) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "casnd1.bin", 0x000000, 0x080000, CRC(9bbe8fe4) SHA1(2e5406d72ca731a5960be3a621bbd72064745677) )
	ROM_LOAD( "casnd2.bin", 0x080000, 0x080000, CRC(aa9a45d3) SHA1(47289537451aac1049f7a524b079f2912d97b7cf) )
	ROM_LOAD( "casnd3.bin", 0x100000, 0x080000, CRC(5764e36d) SHA1(6601946bda40886e3a606accd7c11b31efcdab28) )
ROM_END


ROM_START( m4chacef )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "ca2-1_0.bin", 0x0000, 0x020000, CRC(c45e650d) SHA1(121e5d178c05d9d38dad167083cb0612f70cbd61) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "casnd1.bin", 0x000000, 0x080000, CRC(9bbe8fe4) SHA1(2e5406d72ca731a5960be3a621bbd72064745677) )
	ROM_LOAD( "casnd2.bin", 0x080000, 0x080000, CRC(aa9a45d3) SHA1(47289537451aac1049f7a524b079f2912d97b7cf) )
	ROM_LOAD( "casnd3.bin", 0x100000, 0x080000, CRC(5764e36d) SHA1(6601946bda40886e3a606accd7c11b31efcdab28) )
ROM_END

ROM_START( m4chacefa )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "ca2_1.bin", 0x0000, 0x020000, CRC(be069065) SHA1(63c108df781345fdb64dc5177bc28b121b097d3a) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "casnd1.bin", 0x000000, 0x080000, CRC(9bbe8fe4) SHA1(2e5406d72ca731a5960be3a621bbd72064745677) )
	ROM_LOAD( "casnd2.bin", 0x080000, 0x080000, CRC(aa9a45d3) SHA1(47289537451aac1049f7a524b079f2912d97b7cf) )
	ROM_LOAD( "casnd3.bin", 0x100000, 0x080000, CRC(5764e36d) SHA1(6601946bda40886e3a606accd7c11b31efcdab28) )
ROM_END

ROM_START( m4chacefb )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "ca2_1i.bin", 0x0000, 0x020000, CRC(fceba4d3) SHA1(9e3ba760dc28122f60e610470ce1f7708eefcbfd) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "casnd1.bin", 0x000000, 0x080000, CRC(9bbe8fe4) SHA1(2e5406d72ca731a5960be3a621bbd72064745677) )
	ROM_LOAD( "casnd2.bin", 0x080000, 0x080000, CRC(aa9a45d3) SHA1(47289537451aac1049f7a524b079f2912d97b7cf) )
	ROM_LOAD( "casnd3.bin", 0x100000, 0x080000, CRC(5764e36d) SHA1(6601946bda40886e3a606accd7c11b31efcdab28) )
ROM_END

ROM_START( m4chacefc )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "ca2_1x.bin", 0x0000, 0x020000, CRC(e1d69187) SHA1(623202d8aaa701709bbcf1fabf0ce6db4fcc18ef) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "casnd1.bin", 0x000000, 0x080000, CRC(9bbe8fe4) SHA1(2e5406d72ca731a5960be3a621bbd72064745677) )
	ROM_LOAD( "casnd2.bin", 0x080000, 0x080000, CRC(aa9a45d3) SHA1(47289537451aac1049f7a524b079f2912d97b7cf) )
	ROM_LOAD( "casnd3.bin", 0x100000, 0x080000, CRC(5764e36d) SHA1(6601946bda40886e3a606accd7c11b31efcdab28) )
ROM_END



ROM_START( m4crzcap )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cc1_0.bin", 0x0000, 0x020000, CRC(e227690c) SHA1(df236e03d2a22a712cd740ed90b55d48d29aaf65) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "ccsnd1.bin", 0x000000, 0x080000, CRC(0961a254) SHA1(a6392f00ff6199a1a31395a12695255b9bd67136) )
	ROM_LOAD( "ccsnd2.bin", 0x080000, 0x080000, CRC(555a4a7a) SHA1(552275fcf0bb5476f97ecb37aa2d4431eb3256fa) )
ROM_END

ROM_START( m4crzcapa )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cc1_0i.bin", 0x0000, 0x020000, CRC(3961e95b) SHA1(09deee5c3d016da1f1f1b81ed9e4edd7e1633a64) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "ccsnd1.bin", 0x000000, 0x080000, CRC(0961a254) SHA1(a6392f00ff6199a1a31395a12695255b9bd67136) )
	ROM_LOAD( "ccsnd2.bin", 0x080000, 0x080000, CRC(555a4a7a) SHA1(552275fcf0bb5476f97ecb37aa2d4431eb3256fa) )
ROM_END

ROM_START( m4crzcapb )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cc1_0x.bin", 0x0000, 0x020000, CRC(88a55a48) SHA1(9567a7d08322de21911bad9b7267c7e5041aa1d1) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "ccsnd1.bin", 0x000000, 0x080000, CRC(0961a254) SHA1(a6392f00ff6199a1a31395a12695255b9bd67136) )
	ROM_LOAD( "ccsnd2.bin", 0x080000, 0x080000, CRC(555a4a7a) SHA1(552275fcf0bb5476f97ecb37aa2d4431eb3256fa) )
ROM_END

ROM_START( m4crzcapc )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cc2_0x.bin", 0x0000, 0x020000, CRC(ac987339) SHA1(b56f77120a544893a92689060eb46b6faf9c91dc) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "ccsnd1.bin", 0x000000, 0x080000, CRC(0961a254) SHA1(a6392f00ff6199a1a31395a12695255b9bd67136) )
	ROM_LOAD( "ccsnd2.bin", 0x080000, 0x080000, CRC(555a4a7a) SHA1(552275fcf0bb5476f97ecb37aa2d4431eb3256fa) )
ROM_END



ROM_START( m4crfire )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cf1_1x.bin", 0x0000, 0x020000, CRC(4267b0f8) SHA1(f0160952af1bfcc08970bb31ba872c8c7e6da996) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "cfsnd1.bin", 0x000000, 0x080000, CRC(cf7d98b3) SHA1(56448d620ab0c9af5ea0f56c29457b80407aa715) )
	ROM_LOAD( "cfsnd2.bin", 0x080000, 0x080000, CRC(e413643d) SHA1(b3b1862a79efd8c777c472c9b07668343deb51b6) )
	ROM_LOAD( "cfsnd3.bin", 0x100000, 0x080000, CRC(21b51239) SHA1(f8fb9cfc23467d2789474d160038324d366c58f4) )
ROM_END



ROM_START( m4crfirea )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "cf2_1x.bin", 0x0000, 0x020000, CRC(b872d707) SHA1(1565fd8e15d823fc943da7c35347f5c24cde0858) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "cfsnd1.bin", 0x000000, 0x080000, CRC(cf7d98b3) SHA1(56448d620ab0c9af5ea0f56c29457b80407aa715) )
	ROM_LOAD( "cfsnd2.bin", 0x080000, 0x080000, CRC(e413643d) SHA1(b3b1862a79efd8c777c472c9b07668343deb51b6) )
	ROM_LOAD( "cfsnd3.bin", 0x100000, 0x080000, CRC(21b51239) SHA1(f8fb9cfc23467d2789474d160038324d366c58f4) )
ROM_END



ROM_START( m4eureka )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "eu1_4i.bin", 0x0000, 0x020000, CRC(2280f25a) SHA1(1898aa5eb73f27b33a902c1696679f6dce115640) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "eusnd1.bin", 0x000000, 0x080000, CRC(fa35fcf4) SHA1(9869fb16383b7aa93d044cfc6fd864a442f225e7) )
	ROM_LOAD( "eusnd2.bin", 0x080000, 0x080000, CRC(f0218dc1) SHA1(28c149c0f94fe724734b6095b34e54a1e7449f28) )
	ROM_LOAD( "eusnd3.bin", 0x100000, 0x080000, CRC(31e63a47) SHA1(985cedec8945c4bb5dec0ed7d888fb4e291bda8b) )
ROM_END

ROM_START( m4eurekaa )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "eu1_4.bin", 0x0000, 0x020000, CRC(f9c6720d) SHA1(cd477099821a36c9731fdaaea900fe3614614798) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "eusnd1.bin", 0x000000, 0x080000, CRC(fa35fcf4) SHA1(9869fb16383b7aa93d044cfc6fd864a442f225e7) )
	ROM_LOAD( "eusnd2.bin", 0x080000, 0x080000, CRC(f0218dc1) SHA1(28c149c0f94fe724734b6095b34e54a1e7449f28) )
	ROM_LOAD( "eusnd3.bin", 0x100000, 0x080000, CRC(31e63a47) SHA1(985cedec8945c4bb5dec0ed7d888fb4e291bda8b) )
ROM_END

ROM_START( m4eurekab )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "eu1_4x.bin", 0x0000, 0x020000, CRC(eb2262e4) SHA1(e807f2a5dccb3ceda4edd2a295fcfd7f154bf54d) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "eusnd1.bin", 0x000000, 0x080000, CRC(fa35fcf4) SHA1(9869fb16383b7aa93d044cfc6fd864a442f225e7) )
	ROM_LOAD( "eusnd2.bin", 0x080000, 0x080000, CRC(f0218dc1) SHA1(28c149c0f94fe724734b6095b34e54a1e7449f28) )
	ROM_LOAD( "eusnd3.bin", 0x100000, 0x080000, CRC(31e63a47) SHA1(985cedec8945c4bb5dec0ed7d888fb4e291bda8b) )
ROM_END



ROM_START( m4fright )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "fn4_1x.bin", 0x0000, 0x020000, CRC(f7bb8da6) SHA1(753edb1123d3ea364ded86b566a2c62a039c3d65) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "fnsnd1.bin", 0x000000, 0x080000, CRC(0f7a6d97) SHA1(f812631af8eb46e188d457d567f42aecceb9e5d2) )
	ROM_LOAD( "fnsnd2.bin", 0x080000, 0x080000, CRC(f2d0c27c) SHA1(4d18049a926898f7fbca54dd30519199fe39f8ea) )
	ROM_LOAD( "fnsnd3.bin", 0x100000, 0x080000, CRC(7ad8aecc) SHA1(8d10a27efbde41af8e04ebe7e8b4b921443bd560) )
ROM_END


ROM_START( m4frighta )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "fn4_1.bin", 0x0000, 0x020000, CRC(801c3db2) SHA1(6c3e9b5ac47807196fb7c9e59112fcbd71edb65d) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "fnsnd1.bin", 0x000000, 0x080000, CRC(0f7a6d97) SHA1(f812631af8eb46e188d457d567f42aecceb9e5d2) )
	ROM_LOAD( "fnsnd2.bin", 0x080000, 0x080000, CRC(f2d0c27c) SHA1(4d18049a926898f7fbca54dd30519199fe39f8ea) )
	ROM_LOAD( "fnsnd3.bin", 0x100000, 0x080000, CRC(7ad8aecc) SHA1(8d10a27efbde41af8e04ebe7e8b4b921443bd560) )
ROM_END

ROM_START( m4frightb )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "fn4_1i.bin", 0x0000, 0x020000, CRC(5b5abde5) SHA1(0583c65755954cc228d32672ea55b7f2afc052c4) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "fnsnd1.bin", 0x000000, 0x080000, CRC(0f7a6d97) SHA1(f812631af8eb46e188d457d567f42aecceb9e5d2) )
	ROM_LOAD( "fnsnd2.bin", 0x080000, 0x080000, CRC(f2d0c27c) SHA1(4d18049a926898f7fbca54dd30519199fe39f8ea) )
	ROM_LOAD( "fnsnd3.bin", 0x100000, 0x080000, CRC(7ad8aecc) SHA1(8d10a27efbde41af8e04ebe7e8b4b921443bd560) )
ROM_END

ROM_START( m4frightc )
	ROM_REGION( 0x020000, "maincpu", 0 ) // fixed bits, probably the same as one of the others sets anyway, remove?
	ROM_LOAD( "frnt8ac", 0x0000, 0x020000, BAD_DUMP CRC(db081875) SHA1(1e994dd411c81eb9d152b9fa2c3e53258d680dfa) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "fnsnd1.bin", 0x000000, 0x080000, CRC(0f7a6d97) SHA1(f812631af8eb46e188d457d567f42aecceb9e5d2) )
	ROM_LOAD( "fnsnd2.bin", 0x080000, 0x080000, CRC(f2d0c27c) SHA1(4d18049a926898f7fbca54dd30519199fe39f8ea) )
	ROM_LOAD( "fnsnd3.bin", 0x100000, 0x080000, CRC(7ad8aecc) SHA1(8d10a27efbde41af8e04ebe7e8b4b921443bd560) )
ROM_END

ROM_START( m4frightd )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "frite.nig",  0x000000, 0x020000, CRC(57febdc0) SHA1(001b134be59367c332df4df14930045d9437111a) )
	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "fnsnd1.bin", 0x000000, 0x080000, CRC(0f7a6d97) SHA1(f812631af8eb46e188d457d567f42aecceb9e5d2) )
	ROM_LOAD( "fnsnd2.bin", 0x080000, 0x080000, CRC(f2d0c27c) SHA1(4d18049a926898f7fbca54dd30519199fe39f8ea) )
	ROM_LOAD( "fnsnd3.bin", 0x100000, 0x080000, CRC(7ad8aecc) SHA1(8d10a27efbde41af8e04ebe7e8b4b921443bd560) )
ROM_END

ROM_START( m4frighte )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "fr_ngt._pound5", 0x0000, 0x020000, CRC(3f2570c2) SHA1(98cc2438eb3fbf07481e2f68cac744e9e0a63e0b) )
	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "fnsnd1.bin", 0x000000, 0x080000, CRC(0f7a6d97) SHA1(f812631af8eb46e188d457d567f42aecceb9e5d2) )
	ROM_LOAD( "fnsnd2.bin", 0x080000, 0x080000, CRC(f2d0c27c) SHA1(4d18049a926898f7fbca54dd30519199fe39f8ea) )
	ROM_LOAD( "fnsnd3.bin", 0x100000, 0x080000, CRC(7ad8aecc) SHA1(8d10a27efbde41af8e04ebe7e8b4b921443bd560) )
ROM_END

ROM_START( m4frightf )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "fr.nig", 0x0000, 0x020000, BAD_DUMP CRC(908926eb) SHA1(30e778c18f8e3b72ab88dcce198e4fa39f138bf7) )// Fright Night (Empire) check code is valid (looks bad)

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "fnsnd1.bin", 0x000000, 0x080000, CRC(0f7a6d97) SHA1(f812631af8eb46e188d457d567f42aecceb9e5d2) )
	ROM_LOAD( "fnsnd2.bin", 0x080000, 0x080000, CRC(f2d0c27c) SHA1(4d18049a926898f7fbca54dd30519199fe39f8ea) )
	ROM_LOAD( "fnsnd3.bin", 0x100000, 0x080000, CRC(7ad8aecc) SHA1(8d10a27efbde41af8e04ebe7e8b4b921443bd560) )
ROM_END


ROM_START( m4gamblr )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "tg4_0k.bin", 0x0000, 0x010000, CRC(d579bd7e) SHA1(b3db3c8a7f30d773a63aab0efe753deacd3db96c) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "gambsnd1.bin", 0x000000, 0x080000, CRC(a3114336) SHA1(539c896ae512a01340471e2e0df542e582b11258) )
	ROM_LOAD( "gambsnd2.bin", 0x080000, 0x080000, CRC(bc8b78bc) SHA1(6a27804483eaed7912fb6a6e673d1ce9f36371cd) )
	ROM_REGION( 0x100000, "altmsm6376", 0 )
	// different SFX, does this belong to a specific revision?
	ROM_LOAD( "gambsnd1f.bin", 0x000000, 0x080000, CRC(249ae0fd) SHA1(024ae694f6d09b7f2bf5b94e3a07e9267707f794) )
	ROM_LOAD( "gambsnd2f.bin", 0x080000, 0x080000, CRC(bc8b78bc) SHA1(6a27804483eaed7912fb6a6e673d1ce9f36371cd) )
ROM_END

ROM_START( m4gamblra )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "tg4_0ki.bin", 0x0000, 0x010000, CRC(52d9981d) SHA1(3e30120491d0546b3e19b4b84079cecadd6cdb94) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "gambsnd1.bin", 0x000000, 0x080000, CRC(a3114336) SHA1(539c896ae512a01340471e2e0df542e582b11258) )
	ROM_LOAD( "gambsnd2.bin", 0x080000, 0x080000, CRC(bc8b78bc) SHA1(6a27804483eaed7912fb6a6e673d1ce9f36371cd) )
ROM_END

ROM_START( m4gamblrb )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "tg4_1x.bin", 0x0000, 0x010000, CRC(e238c6c2) SHA1(6b148221d8c9468efca8eddc0520f4abf5a38200) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "gambsnd1.bin", 0x000000, 0x080000, CRC(a3114336) SHA1(539c896ae512a01340471e2e0df542e582b11258) )
	ROM_LOAD( "gambsnd2.bin", 0x080000, 0x080000, CRC(bc8b78bc) SHA1(6a27804483eaed7912fb6a6e673d1ce9f36371cd) )
ROM_END


ROM_START( m4gtrain )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "ghosttrainvers3-0.bin", 0x0000, 0x010000, CRC(17f3dd0f) SHA1(0364b4fe3fc273a658feeaecee1ebc0b55a12d98) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "gtsnd1.bin", 0x000000, 0x080000, CRC(7fd83279) SHA1(65b52330e8d6ccf5c0575924a1791e7d2001c3d8) )
	ROM_LOAD( "gtsnd2.bin", 0x080000, 0x080000, CRC(5bfd0ea2) SHA1(af9adcf517801c775eb316c36538b1bf2262ebb2) )
ROM_END

ROM_START( m4gtraina )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "gt3_0kx.bin", 0x0000, 0x010000, CRC(a6a5461f) SHA1(89652a760a6419064f5c9a52c1bfd066e79e345e) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "gtsnd1.bin", 0x000000, 0x080000, CRC(7fd83279) SHA1(65b52330e8d6ccf5c0575924a1791e7d2001c3d8) )
	ROM_LOAD( "gtsnd2.bin", 0x080000, 0x080000, CRC(5bfd0ea2) SHA1(af9adcf517801c775eb316c36538b1bf2262ebb2) )
ROM_END

ROM_START( m4gtrainb )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "gt3_1k.bin", 0x0000, 0x010000, CRC(13934116) SHA1(a7e7420e62df0e34a77800e61a9df4ba1e3772c6) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "gtsnd1.bin", 0x000000, 0x080000, CRC(7fd83279) SHA1(65b52330e8d6ccf5c0575924a1791e7d2001c3d8) )
	ROM_LOAD( "gtsnd2.bin", 0x080000, 0x080000, CRC(5bfd0ea2) SHA1(af9adcf517801c775eb316c36538b1bf2262ebb2) )
ROM_END

ROM_START( m4gtrainc )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "gt3_1ki.bin", 0x0000, 0x010000, CRC(94336475) SHA1(4655631bc65faa82270da606bba8ffcb2d335f26) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "gtsnd1.bin", 0x000000, 0x080000, CRC(7fd83279) SHA1(65b52330e8d6ccf5c0575924a1791e7d2001c3d8) )
	ROM_LOAD( "gtsnd2.bin", 0x080000, 0x080000, CRC(5bfd0ea2) SHA1(af9adcf517801c775eb316c36538b1bf2262ebb2) )
ROM_END


ROM_START( m4goldfv )
	ROM_REGION( 0x020000, "maincpu", 0 )
	ROM_LOAD( "gf1_4.bin", 0x0000, 0x020000, CRC(9eb00e69) SHA1(3d04b8c6776bead54d21c0a40d51ed044716897e) )

	ROM_REGION( 0x080000, "msm6376", 0 )
	ROM_LOAD( "gfsnd.bin", 0x0000, 0x080000, CRC(1bb14a13) SHA1(44e888e625cce27bc550a93fce3747885802f5c2) )
ROM_END



ROM_START( m4haunt )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hh0.3", 0x0000, 0x010000, CRC(95370728) SHA1(63c7f2fa890c385556a570f3e8941f083a3917bc) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hhsnd1.bin", 0x000000, 0x080000, CRC(a2eff4c6) SHA1(86441371b8efbffb93c6c7d02d45cd5dae73ca45) )
	ROM_LOAD( "hhsnd2.bin", 0x080000, 0x080000, CRC(6eb3f52c) SHA1(7b6f7a5bdc5e9937e0b74ce317c951d9ad82425c) )
ROM_END

ROM_START( m4haunta )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hh0_2x.bin", 0x0000, 0x010000, CRC(3a32332f) SHA1(837b75eb37367ea204c758918ec8eb6370196aa8) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hhsnd1.bin", 0x000000, 0x080000, CRC(a2eff4c6) SHA1(86441371b8efbffb93c6c7d02d45cd5dae73ca45) )
	ROM_LOAD( "hhsnd2.bin", 0x080000, 0x080000, CRC(6eb3f52c) SHA1(7b6f7a5bdc5e9937e0b74ce317c951d9ad82425c) )
ROM_END

ROM_START( m4hauntb )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hh3_0.bin", 0x0000, 0x010000, CRC(f0fc3475) SHA1(24f3ab5990d40b742416f600ffa50e6fc02990ca) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hhsnd1.bin", 0x000000, 0x080000, CRC(a2eff4c6) SHA1(86441371b8efbffb93c6c7d02d45cd5dae73ca45) )
	ROM_LOAD( "hhsnd2.bin", 0x080000, 0x080000, CRC(6eb3f52c) SHA1(7b6f7a5bdc5e9937e0b74ce317c951d9ad82425c) )
ROM_END

ROM_START( m4hauntc )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hh3_0i.bin", 0x0000, 0x010000, CRC(775c1116) SHA1(9fcc9d99b0fc97d98c1a74de7f60e3307ee06448) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hhsnd1.bin", 0x000000, 0x080000, CRC(a2eff4c6) SHA1(86441371b8efbffb93c6c7d02d45cd5dae73ca45) )
	ROM_LOAD( "hhsnd2.bin", 0x080000, 0x080000, CRC(6eb3f52c) SHA1(7b6f7a5bdc5e9937e0b74ce317c951d9ad82425c) )
ROM_END

ROM_START( m4hauntd )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hh3_0x.bin", 0x0000, 0x010000, CRC(42b064db) SHA1(158ec14a34423bea0f9bfb0255ad7b1b2618c9ca) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hhsnd1.bin", 0x000000, 0x080000, CRC(a2eff4c6) SHA1(86441371b8efbffb93c6c7d02d45cd5dae73ca45) )
	ROM_LOAD( "hhsnd2.bin", 0x080000, 0x080000, CRC(6eb3f52c) SHA1(7b6f7a5bdc5e9937e0b74ce317c951d9ad82425c) )
ROM_END



ROM_START( m4hisprt )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hisp1.4", 0x0000, 0x010000, CRC(f80ceefb) SHA1(f8925329f8a1f0f0b61d3de9ebc2d76a7b64be45) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "highsnd1.bin", 0x000000, 0x080000, CRC(b5084d9c) SHA1(0b59ec1735ccc641f3883746027aab6660fac471) )
	ROM_LOAD( "highsnd2.bin", 0x080000, 0x080000, CRC(0d3b50e9) SHA1(fdca97ec314e2efdd9fcd471ee509fd83f980df6) )
ROM_END

ROM_START( m4hisprta )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hs1_0x.bin", 0x0000, 0x010000, CRC(0cd54416) SHA1(54c1959ecd0e40b4fd2bce7cbf435f66ddc34626) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "highsnd1.bin", 0x000000, 0x080000, CRC(b5084d9c) SHA1(0b59ec1735ccc641f3883746027aab6660fac471) )
	ROM_LOAD( "highsnd2.bin", 0x080000, 0x080000, CRC(0d3b50e9) SHA1(fdca97ec314e2efdd9fcd471ee509fd83f980df6) )
ROM_END

ROM_START( m4hisprtb )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hs1_3.bin", 0x0000, 0x010000, CRC(816101e8) SHA1(654812e4a6cf76787d944abdd914aa5727e06437) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "highsnd1.bin", 0x000000, 0x080000, CRC(b5084d9c) SHA1(0b59ec1735ccc641f3883746027aab6660fac471) )
	ROM_LOAD( "highsnd2.bin", 0x080000, 0x080000, CRC(0d3b50e9) SHA1(fdca97ec314e2efdd9fcd471ee509fd83f980df6) )
ROM_END


ROM_START( m4hisprtc )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hs3_0.bin", 0x0000, 0x010000, CRC(43704966) SHA1(78989fa9743efc348f1e81ce040ef9eaf00a47fe) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "highsnd1.bin", 0x000000, 0x080000, CRC(b5084d9c) SHA1(0b59ec1735ccc641f3883746027aab6660fac471) )
	ROM_LOAD( "highsnd2.bin", 0x080000, 0x080000, CRC(0d3b50e9) SHA1(fdca97ec314e2efdd9fcd471ee509fd83f980df6) )
ROM_END

ROM_START( m4hisprtd )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hs3_0i.bin", 0x0000, 0x010000, CRC(c4d06c05) SHA1(e9256e656c698723158f835a32cdf668ed6120c8) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "highsnd1.bin", 0x000000, 0x080000, CRC(b5084d9c) SHA1(0b59ec1735ccc641f3883746027aab6660fac471) )
	ROM_LOAD( "highsnd2.bin", 0x080000, 0x080000, CRC(0d3b50e9) SHA1(fdca97ec314e2efdd9fcd471ee509fd83f980df6) )
ROM_END

ROM_START( m4hisprte )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hs3_0x.bin", 0x0000, 0x010000, CRC(9a7276f1) SHA1(a683dcf0272d868dbc8be83ad2debcd174453559) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "highsnd1.bin", 0x000000, 0x080000, CRC(b5084d9c) SHA1(0b59ec1735ccc641f3883746027aab6660fac471) )
	ROM_LOAD( "highsnd2.bin", 0x080000, 0x080000, CRC(0d3b50e9) SHA1(fdca97ec314e2efdd9fcd471ee509fd83f980df6) )
ROM_END


ROM_START( m4hotcsh )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hc3_0k.bin", 0x0000, 0x010000, CRC(e3cfa94a) SHA1(d21d2dac4edbf3fde9adab399bdd530e034af122) )
	ROM_REGION( 0x48, "fakechr", 0 )
	ROM_LOAD( "db.chr", 0x00, 0x48, CRC(0fc2bb52) SHA1(0d0e47938f6e00166e7352732ddfb7c610f44db2) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hotsnd1.bin", 0x000000, 0x080000, CRC(eef55915) SHA1(b673a05a0313271cc16645f277d37a4a03deced1) )
	ROM_LOAD( "hotsnd2.bin", 0x080000, 0x080000, CRC(92e921ab) SHA1(11e1f3c61a2eddfdcb40f606672d8845000c4ce7) )
ROM_END

ROM_START( m4hotcsha )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hc3_0ki.bin", 0x0000, 0x010000, CRC(646f8c29) SHA1(19d60faf77a7a83efc3ea4b614a4bc1dee53b8d8) )
	ROM_REGION( 0x48, "fakechr", 0 )
	ROM_LOAD( "db.chr", 0x00, 0x48, CRC(0fc2bb52) SHA1(0d0e47938f6e00166e7352732ddfb7c610f44db2) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hotsnd1.bin", 0x000000, 0x080000, CRC(eef55915) SHA1(b673a05a0313271cc16645f277d37a4a03deced1) )
	ROM_LOAD( "hotsnd2.bin", 0x080000, 0x080000, CRC(92e921ab) SHA1(11e1f3c61a2eddfdcb40f606672d8845000c4ce7) )
ROM_END

ROM_START( m4hotcshb )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "hc3_0kx.bin", 0x0000, 0x010000, CRC(3abebe72) SHA1(fec09ca41e8e43628140456bb44ce6e7c66f5270) )

	ROM_REGION( 0x48, "fakechr", 0 )
	ROM_LOAD( "db.chr", 0x00, 0x48, CRC(0fc2bb52) SHA1(0d0e47938f6e00166e7352732ddfb7c610f44db2) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hotsnd1.bin", 0x000000, 0x080000, CRC(eef55915) SHA1(b673a05a0313271cc16645f277d37a4a03deced1) )
	ROM_LOAD( "hotsnd2.bin", 0x080000, 0x080000, CRC(92e921ab) SHA1(11e1f3c61a2eddfdcb40f606672d8845000c4ce7) )
ROM_END

ROM_START( m4hotcshc )
	ROM_REGION( 0x010000, "maincpu", 0 )
	ROM_LOAD( "empire-hotcashv2-0.bin", 0x0000, 0x010000, CRC(b7ec5af3) SHA1(9454feecc7d7c533fed7134118acd2117ebe2591) )

	ROM_REGION( 0x48, "fakechr", 0 )
	ROM_LOAD( "db.chr", 0x00, 0x48, CRC(0fc2bb52) SHA1(0d0e47938f6e00166e7352732ddfb7c610f44db2) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "hotsnd1.bin", 0x000000, 0x080000, CRC(eef55915) SHA1(b673a05a0313271cc16645f277d37a4a03deced1) )
	ROM_LOAD( "hotsnd2.bin", 0x080000, 0x080000, CRC(92e921ab) SHA1(11e1f3c61a2eddfdcb40f606672d8845000c4ce7) )
ROM_END


ROM_START( m4monspn )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "ms2_0.bin", 0x0000, 0x010000, CRC(c20172a8) SHA1(0fb97258dd33fa7ff83b8082149069aaf3577480) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "mssnd1.bin", 0x000000, 0x080000, CRC(e8f0e818) SHA1(a874981fc980a0ed49352f5bf89caf80176b3865) )
	ROM_LOAD( "mssnd2.bin", 0x080000, 0x080000, CRC(636c329d) SHA1(27503035ea57c7e03a9a07dfc58da997c47dda34) )
ROM_END

ROM_START( m4monspna )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "ms2_0i.bin", 0x0000, 0x010000, CRC(45a157cb) SHA1(619e05bc0ee01bdb3254269619f761b513d77ee8) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "mssnd1.bin", 0x000000, 0x080000, CRC(e8f0e818) SHA1(a874981fc980a0ed49352f5bf89caf80176b3865) )
	ROM_LOAD( "mssnd2.bin", 0x080000, 0x080000, CRC(636c329d) SHA1(27503035ea57c7e03a9a07dfc58da997c47dda34) )
ROM_END

ROM_START( m4monspnb )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "ms2_0x.bin", 0x0000, 0x010000, CRC(e9e40e01) SHA1(487c11c03bfa582424b680d204417eb5e85abfb4) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "mssnd1.bin", 0x000000, 0x080000, CRC(e8f0e818) SHA1(a874981fc980a0ed49352f5bf89caf80176b3865) )
	ROM_LOAD( "mssnd2.bin", 0x080000, 0x080000, CRC(636c329d) SHA1(27503035ea57c7e03a9a07dfc58da997c47dda34) )
ROM_END


ROM_START( m4pbnudg )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "pinball nudger v0-1", 0x0000, 0x010000, CRC(8d2e5ded) SHA1(51d4ea44d4e8a7bd53f321fd677b12f6bafbc721) )

	ROM_REGION( 0x080000, "msm6376", 0 )
	ROM_LOAD( "pinsnd.bin", 0x0000, 0x080000, CRC(30f61dcb) SHA1(c844272ffc264d6dabe1958ef57d10d1ba0c2b1e) )
ROM_END

ROM_START( m4pbnudga )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "pn0_2.bin", 0x0000, 0x010000, CRC(d2aab1e0) SHA1(203257c50f79df46561ece5116277a8d56552b04) )

	ROM_REGION( 0x080000, "msm6376", 0 )
	ROM_LOAD( "pinsnd.bin", 0x0000, 0x080000, CRC(30f61dcb) SHA1(c844272ffc264d6dabe1958ef57d10d1ba0c2b1e) )
ROM_END

ROM_START( m4pbnudgb )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "pn1_0.bin", 0x0000, 0x010000, CRC(95dabff1) SHA1(846577f76c6c99cb05f3aab88de80c3373e570c0) )

	ROM_REGION( 0x080000, "msm6376", 0 )
	ROM_LOAD( "pinsnd.bin", 0x0000, 0x080000, CRC(30f61dcb) SHA1(c844272ffc264d6dabe1958ef57d10d1ba0c2b1e) )
ROM_END


ROM_START( m4pitfal )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "pf1_3.bin", 0x0000, 0x020000, CRC(5bdacadf) SHA1(3f48faf92ef25ecbb20f6af90adf5bffdaf8bad8) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "pfsnd1.bin", 0x000000, 0x080000, CRC(50ad158e) SHA1(0efcb9f5683cbe5bdec1e13791d8a01cdfcb5f1a) )
	ROM_LOAD( "pfsnd2.bin", 0x080000, 0x080000, CRC(80ad0d94) SHA1(2c1c60b681cc80624f8bd120034639f1cce06cc5) )
	ROM_LOAD( "pfsnd3.bin", 0x100000, 0x080000, CRC(abc0a0da) SHA1(3048edf44a31d58794a3ee1dad1399559bf14211) )
ROM_END

ROM_START( m4pitfala )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "pf1_4x.bin", 0x0000, 0x020000, CRC(42cd08bc) SHA1(69a5a5158d78c51e188520dbb16a0a89566ea8b3) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "pfsnd1.bin", 0x000000, 0x080000, CRC(50ad158e) SHA1(0efcb9f5683cbe5bdec1e13791d8a01cdfcb5f1a) )
	ROM_LOAD( "pfsnd2.bin", 0x080000, 0x080000, CRC(80ad0d94) SHA1(2c1c60b681cc80624f8bd120034639f1cce06cc5) )
	ROM_LOAD( "pfsnd3.bin", 0x100000, 0x080000, CRC(abc0a0da) SHA1(3048edf44a31d58794a3ee1dad1399559bf14211) )
ROM_END

ROM_START( m4pitfalb )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "pf2_0.bin", 0x0000, 0x020000, CRC(159f1ac6) SHA1(5af44ac650b9408afedc7533c2b3e558a84eb727) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "pfsnd1.bin", 0x000000, 0x080000, CRC(50ad158e) SHA1(0efcb9f5683cbe5bdec1e13791d8a01cdfcb5f1a) )
	ROM_LOAD( "pfsnd2.bin", 0x080000, 0x080000, CRC(80ad0d94) SHA1(2c1c60b681cc80624f8bd120034639f1cce06cc5) )
	ROM_LOAD( "pfsnd3.bin", 0x100000, 0x080000, CRC(abc0a0da) SHA1(3048edf44a31d58794a3ee1dad1399559bf14211) )
ROM_END

ROM_START( m4pitfalc )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "pf2_0x.bin", 0x0000, 0x020000, CRC(ba59a3f9) SHA1(1e2f21c67e8ca41a1cb8e9c412cf911b62511e05) )

	ROM_REGION( 0x180000, "msm6376", 0 )
	ROM_LOAD( "pfsnd1.bin", 0x000000, 0x080000, CRC(50ad158e) SHA1(0efcb9f5683cbe5bdec1e13791d8a01cdfcb5f1a) )
	ROM_LOAD( "pfsnd2.bin", 0x080000, 0x080000, CRC(80ad0d94) SHA1(2c1c60b681cc80624f8bd120034639f1cce06cc5) )
	ROM_LOAD( "pfsnd3.bin", 0x100000, 0x080000, CRC(abc0a0da) SHA1(3048edf44a31d58794a3ee1dad1399559bf14211) )
ROM_END




ROM_START( m4ttrail )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "tt3_0.bin", 0x0000, 0x010000, CRC(62f31f70) SHA1(e1b50b98cc90513c9fa06d0ea8f70aa45bddc0e6) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "ttsnd1.bin", 0x000000, 0x080000, CRC(6af0c76f) SHA1(8587b499b88b609e48553e610a0ee539f98b70ce) )
	ROM_LOAD( "ttsnd2.bin", 0x080000, 0x080000, CRC(9f243ed1) SHA1(c4b83a9b788e4fa2065ff7a270f0dcdecb125e66) )
ROM_END

ROM_START( m4ttraila )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "tt3_0i.bin", 0x0000, 0x010000, CRC(e5533a13) SHA1(0d23503d32c8156112676aaddece1a44614230eb) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "ttsnd1.bin", 0x000000, 0x080000, CRC(6af0c76f) SHA1(8587b499b88b609e48553e610a0ee539f98b70ce) )
	ROM_LOAD( "ttsnd2.bin", 0x080000, 0x080000, CRC(9f243ed1) SHA1(c4b83a9b788e4fa2065ff7a270f0dcdecb125e66) )
ROM_END

ROM_START( m4ttrailb )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "tt3_0x.bin", 0x0000, 0x010000, CRC(7d00e4ae) SHA1(6bb30af001fc73e354c17a99633b6fa4c50b374d) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "ttsnd1.bin", 0x000000, 0x080000, CRC(6af0c76f) SHA1(8587b499b88b609e48553e610a0ee539f98b70ce) )
	ROM_LOAD( "ttsnd2.bin", 0x080000, 0x080000, CRC(9f243ed1) SHA1(c4b83a9b788e4fa2065ff7a270f0dcdecb125e66) )
ROM_END



ROM_START( m4jne )
	ROM_REGION( 0x20000, "maincpu", 0 )
	ROM_LOAD( "jne2_5.bin", 0x0000, 0x020000, CRC(541794df) SHA1(08ce8fa1f9ab715bf8bd55a71fc25deead204026) )

	ROM_REGION( 0x100000, "msm6376", 0 )
	ROM_LOAD( "jnesnd.bin", 0x0000, 0x080000, CRC(47301e22) SHA1(b7ec2ff3b78ceecc0e50142dbbc40929f2526f3f) )
ROM_END


#define GAME_FLAGS (MACHINE_NOT_WORKING|MACHINE_REQUIRES_ARTWORK|MACHINE_MECHANICAL)


/* Empire
   most of these boot (after a single reset to initialize)
   but have broken text, need to check VFD emulation */

GAMEL(199?, m4apachg,  0,        mod4oki, mpu4, mpu4_state, init_m4apachg, ROT0, "Empire","Apache Gold (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND, layout_m4apachg )
GAMEL(199?, m4apachga, m4apachg, mod4oki, mpu4, mpu4_state, init_m4apachg, ROT0, "Empire","Apache Gold (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND, layout_m4apachg )
GAMEL(199?, m4apachgb, m4apachg, mod4oki, mpu4, mpu4_state, init_m4apachg, ROT0, "Empire","Apache Gold (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND, layout_m4apachg )
GAMEL(199?, m4apachgc, m4apachg, mod4oki, mpu4, mpu4_state, init_m4apachg, ROT0, "Empire","Apache Gold (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND, layout_m4apachg )
GAMEL(199?, m4apachgd, m4apachg, mod4oki, mpu4, mpu4_state, init_m4apachg, ROT0, "Empire","Apache Gold (Empire) (MPU4, set 5)",   GAME_FLAGS|MACHINE_NO_SOUND, layout_m4apachg )
GAMEL(199?, m4apachge, m4apachg, mod4oki, mpu4, mpu4_state, init_m4apachg, ROT0, "Empire","Apache Gold (Empire) (MPU4, set 6)",   GAME_FLAGS|MACHINE_NO_SOUND, layout_m4apachg )
GAMEL(199?, m4apachgf, m4apachg, mod4oki, mpu4, mpu4_state, init_m4apachg, ROT0, "Empire","Apache Gold (Empire) (MPU4, set 7)",   GAME_FLAGS|MACHINE_NO_SOUND, layout_m4apachg )

GAME(199?, m4bangrs,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Bangers 'n' Cash (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bangrsa, m4bangrs, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Bangers 'n' Cash (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bangrsb, m4bangrs, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Bangers 'n' Cash (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bankrd,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Bank Raid (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bankrda, m4bankrd, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Bank Raid (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bankrdb, m4bankrd, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Bank Raid (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bankrdc, m4bankrd, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Bank Raid (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bankrdd, m4bankrd, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Bank Raid (Empire) (MPU4, set 5)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bigchs,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Big Cheese (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bigchsa, m4bigchs, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Big Cheese (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4bigchsb, m4bigchs, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Big Cheese (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4cstrik,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Cash Strike (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4cstrika, m4cstrik, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Cash Strike (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4cstrikb, m4cstrik, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Cash Strike (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4cstrikc, m4cstrik, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Cash Strike (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4chacec,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Chase The Ace [Cards] (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4chaceca, m4chacec, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Chase The Ace [Cards] (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4chacef,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Chase The Ace [Fruits] (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4chacefa, m4chacef, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Chase The Ace [Fruits] (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4chacefb, m4chacef, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Chase The Ace [Fruits] (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4chacefc, m4chacef, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Chase The Ace [Fruits] (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4crzcap,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Crazy Capers (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4crzcapa, m4crzcap, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Crazy Capers (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4crzcapb, m4crzcap, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Crazy Capers (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4crzcapc, m4crzcap, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Crazy Capers (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4crfire,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Crossfire (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND ) // doesn't boot, alarm
GAME(199?, m4crfirea, m4crfire, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Crossfire (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND ) // doesn't boot, alarm
GAME(199?, m4eureka,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Eureka (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4eurekaa, m4eureka, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Eureka (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4eurekab, m4eureka, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Eureka (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4fright,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Fright Night (Empire) (MPU4, v4.1X)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4frighta, m4fright, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Fright Night (Empire) (MPU4, v4.1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4frightb, m4fright, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Fright Night (Empire) (MPU4, v4.1i)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4frightc, m4fright, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Fright Night (Empire) (MPU4, v?.?, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND ) // bad dump
GAME(199?, m4frightd, m4fright, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Fright Night (Empire) (MPU4, v3.3)",GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4frighte, m4fright, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Fright Night (Empire) (MPU4, v3.0)",GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4frightf, m4fright, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Fright Night (Empire) (MPU4, v?.?, set 2)",GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4gamblr,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","The Gambler (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4gamblra, m4gamblr, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","The Gambler (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4gamblrb, m4gamblr, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","The Gambler (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4gtrain,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Ghost Train (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4gtraina, m4gtrain, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Ghost Train (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4gtrainb, m4gtrain, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Ghost Train (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4gtrainc, m4gtrain, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Ghost Train (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4goldfv,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Gold Fever (Empire) (MPU4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4haunt,   0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Haunted House (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4haunta,  m4haunt,  mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Haunted House (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hauntb,  m4haunt,  mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Haunted House (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hauntc,  m4haunt,  mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Haunted House (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hauntd,  m4haunt,  mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Haunted House (Empire) (MPU4, set 5)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hisprt,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","High Spirits (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hisprta, m4hisprt, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","High Spirits (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hisprtb, m4hisprt, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","High Spirits (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hisprtc, m4hisprt, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","High Spirits (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hisprtd, m4hisprt, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","High Spirits (Empire) (MPU4, set 5)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4hisprte, m4hisprt, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","High Spirits (Empire) (MPU4, set 6)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(1996, m4hotcsh,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Hot Cash (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(1996, m4hotcsha, m4hotcsh, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Hot Cash (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(1996, m4hotcshb, m4hotcsh, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Hot Cash (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(1996, m4hotcshc, m4hotcsh, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Hot Cash (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4monspn,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Money Spinner (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4monspna, m4monspn, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Money Spinner (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4monspnb, m4monspn, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Money Spinner (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4pbnudg,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Pinball Nudger (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4pbnudga, m4pbnudg, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Pinball Nudger (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4pbnudgb, m4pbnudg, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Pinball Nudger (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4pitfal,  0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Pitfall (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND ) // doesn't boot, alarm
GAME(199?, m4pitfala, m4pitfal, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Pitfall (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND ) // doesn't boot, alarm
GAME(199?, m4pitfalb, m4pitfal, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Pitfall (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND ) // doesn't boot, alarm
GAME(199?, m4pitfalc, m4pitfal, mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Pitfall (Empire) (MPU4, set 4)",   GAME_FLAGS|MACHINE_NO_SOUND ) // doesn't boot, alarm
GAME(199?, m4ttrail, 0,         mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Treasure Trail (Empire) (MPU4, set 1)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4ttraila,m4ttrail,  mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Treasure Trail (Empire) (MPU4, set 2)",   GAME_FLAGS|MACHINE_NO_SOUND )
GAME(199?, m4ttrailb,m4ttrail,  mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","Treasure Trail (Empire) (MPU4, set 3)",   GAME_FLAGS|MACHINE_NO_SOUND )
// doesn't seem like the other Empire games (starts with RESETTING JNE, licensed, mislabeled?)
//Looks like the only one to have a proper protection routine, too so I'm guessing it's just a game they distributed, rather than made themselves
GAME(199?, m4jne,     0,        mod4oki, mpu4, mpu4_state, init_m4default, ROT0, "Empire","The Jackpot's Not Enough (Empire) (MPU4)",   GAME_FLAGS|MACHINE_NO_SOUND )
