/* * This file is part of Maliit framework *
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 *
 * Contact: maliit-discuss@lists.maliit.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation
 * and appearing in the file LICENSE.LGPL included in the packaging
 * of this file.
 */

#include "ut_minputcontextplugin.h"

#include "core-utils.h"
#include "gui-utils.h"
#include "minputcontextplugin.h"
#include "mimsettings.h"

#include <QInputContext>
#include <QApplication>

namespace {
    const QString EnabledPluginsKey = MALIIT_CONFIG_ROOT"onscreen/enabled";
    const QStringList DefaultEnabledPlugins = QStringList() << "libdummyimplugin.so" ":" "dummyimsv1";
    const QString MImPluginPaths = MALIIT_CONFIG_ROOT"paths";
}

void Ut_MInputContextPlugin::initTestCase()
{
    MImSettings::setPreferredSettingsType(MImSettings::TemporarySettings);
}

void Ut_MInputContextPlugin::cleanupTestCase()
{
}

void Ut_MInputContextPlugin::init()
{
    subject = new MInputContextPlugin(0);
    QVERIFY(subject);

    // Make sure that for the direct IC case (maliit server embedded in application)
    // We don't try to use any plugins outside of our control
    MImSettings pathConf(MImPluginPaths);
    pathConf.set(MaliitTestUtils::getTestPluginPath());
    MImSettings enabledPluginsSettings(EnabledPluginsKey);
    enabledPluginsSettings.set(DefaultEnabledPlugins);
}

void Ut_MInputContextPlugin::cleanup()
{
    delete subject;
}

void Ut_MInputContextPlugin::testCreate()
{
    QStringList keys = subject->keys();
    QInputContext *ctx = NULL;

    Q_FOREACH(QString key, keys) {
        ctx = subject->create(key);
        QVERIFY(ctx);
        QCOMPARE(ctx->identifierName(), key);
        delete ctx;
        ctx = NULL;
    }

    // Null key should fail
    ctx = subject->create(QString());
    QVERIFY(!ctx);
}

void Ut_MInputContextPlugin::testOther()
{
    // This is a dont-crash test for simple API functions.

    QString key = subject->keys().first();

    QString description(subject->description(key));
    QString displayName(subject->displayName(key));
    QStringList languages(subject->languages(key));

    qDebug() << "description: " << description;
    qDebug() << "display name: " << displayName;
    Q_FOREACH(QString lang, languages) {
        qDebug() << "language: " << lang;
    }
}

void disableImLoading()
{
    // This is a hack to prevent Qt from loading the plugin from
    // /usr/lib/qt4/plugins/inputmethods/ when we are testing in a
    // sandbox.
    if (MaliitTestUtils::isTestingInSandbox())
        QCoreApplication::setLibraryPaths(QStringList("/tmp"));
}

MALIIT_TESTUTILS_GUI_MAIN_WITH_SETUP(Ut_MInputContextPlugin, disableImLoading)
