/* This file is part of the KDE project
   Copyright (C) 2006 KovoKs <info@kovoks.nl>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Qt includes.

#include <qtabwidget.h>
#include <qapplication.h>
#include <qframe.h>

// KDE includes.

#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>

// Local includes.

#include "global.h"
#include "setupaccount.h"
#include "setupidentities.h"
#include "setup.h"

namespace Mailody {

class SetupPriv
{
public:
    SetupAccount     *accountPage;
    SetupIdentities  *identitiesPage;
};

Setup::Setup(QWidget* parent, const char* name)
     : KDialogBase(IconList, i18n("Configure"), Help|Ok|Cancel, Ok, parent,
                   name, true, true )
{
    d = new SetupPriv;

    QFrame *page_account = addPage(i18n("IMAP"), i18n("Imap Settings"),
                        BarIcon("configure", KIcon::SizeMedium));
    d->accountPage = new SetupAccount(page_account);

    QFrame *page_identities = addPage(i18n("Identities"),
                                      i18n("Identities Settings"),
                        BarIcon("configure", KIcon::SizeMedium));
    d->identitiesPage = new SetupIdentities(page_identities);

    connect(this, SIGNAL(okClicked()),
            this, SLOT(slotOkClicked()) );

    showPage(0);

    setMinimumSize(QSize(555,280));
    resize( configDialogSize("Settings") );
    show();

    if(!Global::cryptoConnectionSupported())
    {
        KMessageBox::information(0,i18n("Your system does not seem to be "
                                        "setup for TLS or SSL, these settings "
                                        "are disabled. Install QCA and "
                                        "recompile Mailody or contact your "
                                        "distribution"),
                                 QString::null, "TLS_SSL_DISABLED");
    }

}

Setup::~Setup()
{
    saveDialogSize("Settings");
    delete d;
    Global::myEmail(QString::null, true);
}

void Setup::slotOkClicked()
{
    d->accountPage->applySettings();
    d->identitiesPage->applySettings();
    close();
}

}

#include "setup.moc"
