/* This file is part of the KDE project

   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef MAILODYBASELISTVIEW_H
#define MAILODYBASELISTVIEW_H

#include "klistview.h"
#include <qdatetime.h>

namespace Mailody {

/**
 * @class MailodyBaseListView
 *
 * This is a drop in replacement for a KListView. It extends the
 * KListviewItem with a signal leftWidget()
 */

class MailodyBaseListView : public KListView
{
    Q_OBJECT

    public:
        explicit MailodyBaseListView(QWidget* parent);

    protected:
        void leaveEvent ( QEvent * );

    signals:
        /** emitted when the mouse leaves the widget*/
        void leftWidget();
};

/**
 * @class MailodyBaseListViewItem
 *
 * This is a drop in replacement for a KListViewItem. It extends the
 * KListviewItem with two features: levels and fancy dates.
 *
 * If you give an
 * item a level it will always appear above all items with a lower level.
 *
 * If you call setFancyDate(), that column will hold a fancy date.
 *
 * @author Tom Albers <tomalbers@kde.nl>
 */
class MailodyBaseListViewItem : public KListViewItem
{
    public:
        /** Constructor, the new item will have level 1 by default */
        explicit MailodyBaseListViewItem( KListView* parent);

        /** Constructor, the new item will have the level of @p parent
         * by default */
        explicit MailodyBaseListViewItem( MailodyBaseListViewItem* parent);

        /**
         * returns the current level
         */
        int level() const { return m_level;  }

        /**
         * sets @p level to this item. By default all new items are
         * created with level 1.
         */
        void setLevel( int level ) { m_level = level;  }

        /**
         * sets @p column to hold fancy date @p datetime. There can only be one.
         * Dont use a listview with items with fancy dates in different columns.
         */
        void setFancyDate( int column, const QDateTime& datetime);

        /**
         * get the original date of the fancy column
         */
        QDateTime getOriginalDate() { return m_dateTime; }

        /**
         * reimplemented to sort first on the level, if two items
         * are on the same level, it sorts on the key as usual.
         */
        virtual int compare( QListViewItem *i, int col,
                     bool ascending ) const;

    private:
        int         m_level;
        int         m_fancyColumn;
        QDateTime   m_dateTime;
};

}

#endif
