/* This file is part of the KDE project

   Copyright (C) 2006 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef COMPOSERTEXTEDIT_H
#define COMPOSERTEXTEDIT_H

#include "ktextedit.h"

namespace Mailody {

/**
 * @class ComposerTextEdit
 * This class is a KTextEdit, which emits a signal when a file is dropped
 * on it.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class ComposerTextEdit : public KTextEdit
{
    Q_OBJECT

    public:
        /**
         * Constructor
         * @param parent the parent widget
         */
        explicit ComposerTextEdit(QWidget* parent);

    protected:
        /**
         * Reimplemented to signal the addition of an attachment.
         */
        void contentsDropEvent(QDropEvent *e);

    signals:
        void addAttachment(const KURL&);
};

}

#endif // COMPOSERTEXTEDIT
