/* This file is part of the KDE project

   Copyright (C) 2008 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef TABWIDGET_H
#define TABWIDGET_H

#include <KTabWidget>
#include <QHash>

class QToolButton;
class KAction;

namespace Mailody
{
class TotalView;

/**
 *  This class is a KTabWidget which can hold tabs for Messages and a browser screen.
 *  You can request the type with currentWidgetType().
 *
 *  Be carefull only to create the tabs with addMessageTab() or with addBrowserTab.
 *  Also only delete the tabs with the slotDeleteCurrentTab() or slotDeleteWidget() calls.
 *  Doing it on your own will mess up the results when querying for the Type.
 */
class TabWidget : public KTabWidget
{
    Q_OBJECT

public:
    enum Type {
        Browser = 0,
        Message
    };

    /** Constructor **/
    explicit TabWidget( QWidget  *parent = 0 );
    void addMessageTab( TotalView *widget, const QString &text );
    void addBrowserTab( TotalView *widget, const QString &text );
    TotalView *tabWidget( int i );
    TotalView *currentTabWidget();
    bool currentTabType( Type );
    void setCurrentTabType( Type );

public slots:
    void slotDeleteCurrentWidget();
    void slotDeleteWidget( QWidget* );

private:
    void addTab( QWidget*, const QString&, Type );
    QToolButton *m_closeButton;
    KAction *m_closeAction;
    QHash<int, Type> m_tabTypes;

signals:
    void clicked();
};

}

#endif
