/* This file is part of the KDE project
   Copyright (C) 2006-2008 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2006 Frode M. Døving <frode@lnix.net>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "setupservers.h"

// Qt
#include <QGridLayout>

// KDEPIMLIBS
#include <mailtransport/servertest.h>
#include <mailtransport/transport.h>

// KDE
#include <KCModuleLoader>
#include <KTabWidget>
#include <KDebug>

using namespace Mailody;

SetupServers::SetupServers( QWidget *parent )
        : QWidget( parent )
{
    QGridLayout *mainGrid = new QGridLayout( this );

    KTabWidget *tabWidget = new KTabWidget( this );
    mainGrid->addWidget( tabWidget, 0, 0 );
    mainGrid->setRowStretch( 0, 0 );

    QStringList list;
    list << "message/news" << "message/rfc822";
    tabWidget->addTab( KCModuleLoader::loadModule( "kcm_akonadi_resources",
                       KCModuleLoader::Inline, this, list ),
                       i18n( "IMAP Servers" ) );

    tabWidget->addTab( KCModuleLoader::loadModule( "kcm_mailtransport",
                       KCModuleLoader::Inline, this ),
                       i18n( "SMTP Servers" ) );
}

SetupServers::~SetupServers()
{
}
