/* This file is part of the KDE project

   Copyright (C) 2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef SEARCHLINE_H
#define SEARCHLINE_H

#include <QWidget>

class KLineEdit;

namespace Mailody
{

class HeaderProxy;

/**
 * @class SearchLine
 * Responsible for the quick search, we can not use the kdelibs version
 * as that works only on a qtreewidget. This class operates on the QTreeView.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class SearchLine : public QWidget
{
    Q_OBJECT

public:
    /**
     * Contructor
     */
    SearchLine( QWidget* );

    /**
     * Destructor
     */
    ~SearchLine();

    /**
     * Call this to re-execute the search.
     */
    void update();

    /**
     * Set the Proxy to operate with
     */
    void setProxy( HeaderProxy* proxy ) {
        m_proxy = proxy;
    };

private slots:
    void slotSearchLineChange( const QString& newText );
    void slotSearchLineActivate();
    void slotSearchLineUpdateClear();

private:
    KLineEdit*                          m_searchLine;
    HeaderProxy*                        m_proxy;
};

}

#endif
