/* This file is part of the KDE project

   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2006-2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "headerwidget.h"
#include <kxmlguiwindow.h>
#include <akonadi/item.h>
#include <akonadi/collection.h>
#include <akonadi/agentmanager.h>

class KHBox;
class KSqueezedTextLabel;
class KToggleAction;
class KTabWidget;
class KAction;
class KActionMenu;
class QToolButton;
class QSplitter;

namespace Akonadi
{
class CollectionStatisticsModel;
}

using Akonadi::AgentManager;

namespace Mailody
{

class Database;
class QuickReplyWidget;
class MessageData;
class ToolTip;
class SearchLine;
class SystemTray;
class TabWidget;

/**
 * @class MainWindow
 * This is one of the two main interfaces of Mailody. The class is pretty
 * crowded with methods, but mostly internal ones.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class MainWindow : public KXmlGuiWindow
{
    Q_OBJECT
    Q_CLASSINFO( "D-Bus Interface", "net.mailody.mainwindow" )

public:
    /**
    * Contructor
    */
    MainWindow();

    /**
    */
    ~MainWindow();

    /**
     * Available through D-Bus
     */
public Q_SLOTS:
    void slotNewMessage( const QString &to=QString() );
    void slotOpenComposer(
        const QString &address=QString(),
        const QString &files=QString(),
        const QString &subject=QString(),
        const QString &body=QString()
    );
    void slotOpenComposer(
        const Akonadi::Collection &mb,
        const QString &address=QString(),
        const QString &files=QString(),
        const QString &subject=QString(),
        const QString &body=QString()
    );
    void slotCheckMail();

    void slotSetup();
    void slotSortOnYoungestChild();
    void slotQuit();

    void slotHideDeleted();
    void slotToggleDelete();
    void slotToggleHTML();
    void slotQuickReply();
    void slotToggleSource();
    void slotToggleFixedFont();
    void slotToggleExternalImage();

    void slotUser0();
    void slotUser1();
    void slotUser2();
    void slotUser3();
    void slotUser4();
    void slotUser5();

    void slotSave();
    void slotPrint();
    void slotZoomIn();
    void slotZoomOut();
    void slotScrollBottom();

protected:
    void closeEvent( QCloseEvent *event );

private:
    //they can go to headerwidget?, maybe that's a better place?
    void setTag( Akonadi::Item item, const QString& tag );
    void setUserTag( int tag );
    void setTag( const QString& tag );
    void removeSingleTag( Akonadi::Item item, const QString& flag );
    void removeTag( const QString& tag );

    void startupSetup();
    void showMessage( const Akonadi::Item&, const Akonadi::Collection& );
    void setActionStates();
    void setStatusBarStates();
    void messageMenu( KActionMenu *am );

    QSplitter                           *m_headerAndViewer;
    KHBox                               *m_right;
    Database                            *m_db;
    TabWidget                           *m_tabWidget;
    QuickReplyWidget                    *m_quickReplyWidget;

    HeaderWidget                        *m_headerWidget;

    ToolTip                             *m_tooltip;

    // Tab Actions
    KAction                             *m_closeAction;
    KToggleAction                       *m_plainTextAction;
    KToggleAction                       *m_sourceAction;
    KToggleAction                       *m_fixedfontAction;
    KToggleAction                       *m_externalImageAction;

    // Mailody actions
    KAction                             *m_checkNowAction;
    KAction                             *m_syncResource;

    // Collection actions
    KAction                             *m_prevUnreadAction;
    KAction                             *m_nextUnreadAction;
    KAction                             *m_purgeAction;
    KAction                             *m_selectAllAction;
    //KToggleAction                       *m_childSortAction;
    KToggleAction                       *m_hideDeletedAction;

    // Message actions
    KAction                             *m_msgNewAction;
    KActionMenu                         *m_msgNewActionMenu;
    KAction                             *m_msgZoomInAction;
    KAction                             *m_msgZoomOutAction;
    KAction                             *m_msgSaveAction;
    KAction                             *m_msgPrintAction;
    KAction                             *m_msgReplyAction;
    KAction                             *m_msgForwardAction;
    KActionMenu                         *m_msgForwardActionMenu;
    KAction                             *m_msgReEditAction;
    KToggleAction                       *m_msgDelAction;
    KAction                             *m_msgUser0Action;
    KAction                             *m_msgUser1Action;
    KAction                             *m_msgUser2Action;
    KAction                             *m_msgUser3Action;
    KAction                             *m_msgUser4Action;
    KAction                             *m_msgUser5Action;
    KToggleAction                       *m_relatedAction;
    SystemTray                          *m_systemTray;

    QString                             m_lastMessage;
    QTimer                              *m_statusTimer;

    QList<MessageData*>                 m_addheaderlist_val;

    bool                                m_idlePossible;
    bool                                m_online;
    KSqueezedTextLabel                  *m_statusText;

    // akonadi stuff
    Akonadi::CollectionView                *m_collectionView;
    Akonadi::CollectionStatisticsModel     *m_collectionModel;
    Akonadi::CollectionFilterProxyModel    *m_collectionProxyModel;
    Akonadi::Collection                     m_currentCollection;

private slots:

    void slotContextMenuHeaders( const Akonadi::Item& );
    void slotContextMenuTab( QWidget*, const QPoint &point );

    void slotNotifications();
    void slotNewMessageMenu();
    void slotNewMessageMenuSelected( QAction* );
    void slotForwardMessage( const QString &to=QString() );
    void slotForwardMessageMenu();
    void slotForwardMessageMenuSelected( QAction* );
    void slotReEditMessage( const QString &to=QString() );
    void slotReplyMessage();
    void slotSelectMessage();
    void slotPurge();
    void slotSyncAllFolderLists();
    void slotSyncFolderList();

    void slotShowMessage( Akonadi::Item );
    void slotMiddleClickInHeaders( Akonadi::Item );

    void slotNewTab();
    void slotDeleteTab( QWidget* );
    void slotDeleteTab();
    void slotCurrentTabChanged( int );
    void slotUpdateTabTitle( const QString& );
    void slotTabScrollUp();
    void slotTabScrollDown();
    void slotTabScrollPageUp();
    void slotTabScrollPageDown();

    void slotSelectAllMessages();
    void slotOpenURLInNewTab( const QString& );

    void slotUpdateStatusBar( const QString& );
    void slotUpdateStatusBarRestoreMouse( const QString &text );
    void slotSimpleMessageStatusBar( const QString &text );
    void slotClearStatusBar();
    void slotStatusBarReady();
    void slotStatusBarClicked( int i );
    void slotCapableResult( const QString &something, bool possible );
    void collectionClicked( const Akonadi::Collection &collection );
    void slotAgentInstanceStatusChanged( const Akonadi::AgentInstance &instance );
    void slotAgentInstanceProgressChanged( const Akonadi::AgentInstance &instance );
    void slotResultStoreJob( KJob* );

signals:
    void setupFinished();
};

}


#endif
