/* This file is part of the KDE project

   Copyright (C) 2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef HEADERVIEW_H
#define HEADERVIEW_H

#include "messagedata.h"
#include <QAbstractItemModel>
#include <QModelIndex>
#include <QVariant>
#include <QTreeView>
#include <QMouseEvent>

#include <akonadi/item.h>

namespace Mailody
{



class HeaderView : public QTreeView
{
    Q_OBJECT

public:
    /** Constructor **/
    HeaderView( QWidget * parent = 0 );

    /** Returns a list of column sizes so you can easily store them */
    QList<int> columnSizes();

    /** Sets the column sizes based on the passed list */
    void setColumnSizes( QList<int> );

    /**
     * call this to expand @p index
     */
    void openItem( const QModelIndex & index );

    /**
     * returns the next new message
     */
    QModelIndex nextUnread() {
        return QModelIndex() ;
    };

    /**
     * If you want a screenie of a widget when a drag is start, set
     * the widget.
     */
    void setDragWidget( QWidget* widget ) {
        m_dragWidget = widget;
    };

protected:
    void mousePressEvent( QMouseEvent * event );
    // void keyPressEvent( QKeyEvent* e );

signals:
    /**
     * emitted on middle click
     * @param item the item
     */
    void selectMessageMiddle( const Akonadi::Item& item );

    /**
     * emitted on right click
     * @param item the item
     */
    void selectMessageRight( const Akonadi::Item& item );

    /**
     * Emitted when user presses the down key, so you can scoll a message
     * down for example.
     */
    void scrollDown();

    /**
     * Emitted when user presses the up key, so you can scoll a message
     * up for example.
     */
    void scrollUp();

    /**
     * Emitted when user presses the page down key, so you can scoll a
     * message down for example.
     */
    void scrollPageDown();

    /**
     * Emitted when user presses the page up key, so you can scoll a
     * message up for example.
     */
    void scrollPageUp();

private:
    QPoint          m_startDrag;
    QWidget         *m_dragWidget;
};

}

#endif
