/* This file is part of the KDE project

   Copyright (C) 2007-2008 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "headerproxy.h"
#include "messagedata.h"
#include "global.h"

#include <QSortFilterProxyModel>

#include <akonadi/kmime/messagemodel.h>

#include <KDebug>

using namespace Mailody;

HeaderProxy::HeaderProxy( QObject * parent )
        : QSortFilterProxyModel( parent ), m_hideDeleted( true )
{
    setSortRole( Qt::EditRole );
    setSortCaseSensitivity( Qt::CaseInsensitive );
}

bool HeaderProxy::filterAcceptsRow( int sourceRow,
                                    const QModelIndex & sourceParent ) const
{
    if ( !filterRegExp().isEmpty() ) {
        QModelIndex index0 = sourceModel()->index( sourceRow, 0, sourceParent );
        QModelIndex index1 = sourceModel()->index( sourceRow, 1, sourceParent );

        return ( sourceModel()->data( index0 ).toString().contains( filterRegExp() )
                 || sourceModel()->data( index1 ).toString().contains( filterRegExp() ) );
    } else if ( m_hideDeleted ) {
        static Akonadi::MessageModel* model =
            static_cast<Akonadi::MessageModel*>( sourceModel() );
        QModelIndex index = sourceModel()->index( sourceRow, 0, sourceParent );
        Akonadi::Item item = model->itemForIndex( index );

        if ( item.hasFlag( "\\Deleted" ) )
            return false;
    }

    return true;
}

bool HeaderProxy::filterAcceptsColumn( int sourceCol, const QModelIndex& ) const
{
    if ( sourceCol == 4 /* size */ || sourceCol == 2 /* Receiver */ )
        return false;
    return true;
}

QVariant HeaderProxy::data( const QModelIndex & index, int role ) const
{
    /* if this is a request for the sender column */
    if ( index.column() == 1  && (role == Qt::DisplayRole || role == Qt::EditRole) ) { 
        const QModelIndex sourceIndex = mapToSource( index );
        const QModelIndex col2 = sourceModel()->index( sourceIndex.row(), 2, sourceIndex.parent() );

        /* fetch the sender */
        QString sender = QSortFilterProxyModel::data( index, Qt::EditRole ).toString();

        /* check if that is my address */
        if ( Global::myEmail( sender ) ) {

            /* Return the recipient instead of the sender, if sort than raw, else prefixed */
            if ( role == Qt::DisplayRole )
                return i18n( "To: %1", sourceModel()->data( col2, Qt::DisplayRole ).toString() );
            else
                return sourceModel()->data( col2, Qt::EditRole ).toString();

        } else /* it's not my address, return the requested value */
            return sourceModel()->data( sourceIndex, role );

    } else /* this is not a request for the sender column, call base */
        return QSortFilterProxyModel::data( index, role );
}

void HeaderProxy::setHideDeleted( bool hide )
{
    m_hideDeleted = hide;
    invalidateFilter();
}

void HeaderProxy::setSortOnChild( bool sort )
{
    sort ? setSortRole( 33 ) : setSortRole( Qt::UserRole );
    invalidate();
}

bool HeaderProxy::lessThan( const QModelIndex &left,
                            const QModelIndex &right ) const
{
    /* Might be needed later on for the sender/received combination I want.
     
    int column = left.column();
    if ( column == 3 ) {
        return sourceModel()->data( left, Qt::EditRole ).toDateTime() <
               sourceModel()->data( right, Qt::EditRole ).toDateTime();
    }
    */
    return QSortFilterProxyModel::lessThan( left,right );
}

#include "headerproxy.moc"
