/* This file is part of the KDE libraries
   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "addresslabel.h"

// Qt
#include <QMouseEvent>

using namespace Mailody;

AddressLabel::AddressLabel( QWidget* parent )
        : QLabel( parent )
{
    connect( this, SIGNAL( linkHovered( const QString& ) ),
             SLOT( slotLinkHovered( const QString& ) ) );
}

AddressLabel::~AddressLabel()
{}

void AddressLabel::slotLinkHovered( const QString& link )
{
    m_link = link;
}

void AddressLabel::mousePressEvent( QMouseEvent * event )
{
    if ( event->button()  == Qt::RightButton && !m_link.isEmpty() )
        emit rightMouseActivated( m_link );
    else if ( event->button()  == Qt::LeftButton && !m_link.isEmpty() )
        emit leftMouseActivated( m_link );
}

#include "addresslabel.moc"
