/* This file is part of the KDE project

   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef ADDRESSBOOK_H
#define ADDRESSBOOK_H

#include <QObject>
#include <kabc/stdaddressbook.h>

namespace Mailody
{

using namespace KABC;

/**
 * @class Addressbook
 * This class takes care of addressbook actions.
 * @author Frode M. Døving <frode@lnix.net>
 */
class Addressbook : public QObject
{
    Q_OBJECT

public:
    /** Default constructor. */
    explicit Addressbook( QObject *parent = 0, const char *name = 0 );

    /** Default destructor. */
    ~Addressbook();

    /**
     * Returns an instance of Addressbook. Never create your own instance
     * of Addressbook, but use this method instead to get the one and only
     * instance.
     */
    static Addressbook *instance();

    /**
     * Adds an address to the addressbook or opens the addressbook
     * at that entry
     */
    void add( const QString& name );

    /**
     * Find addressee by email.
     */
    Addressee::List findByEmail( const QString& );

    /**
     * Returns the pointer to the addressbook.
     */
    KABC::AddressBook* getAddressbookPointer() {
        return m_ab;
    };

private:
    static Addressbook*     m_instance;
    KABC::AddressBook*      m_ab;
};

}

#endif
