/* This file is part of the KDE project
   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// Own
#include "addressbook.h"

// KDE
#include <kpimutils/email.h>
#include <KRun>
#include <KShell>

using namespace Mailody;

Addressbook *Addressbook::m_instance = 0;

Addressbook::Addressbook( QObject *parent, const char *name )
        : QObject( parent )
{
    setObjectName( name );
    m_ab = KABC::StdAddressBook::self( true );
}

Addressbook::~Addressbook()
{
    delete m_ab;
}

Addressbook* Addressbook::instance()
{
    if ( !m_instance )
        m_instance = new Addressbook();
    return m_instance;
}

void Addressbook::add( const QString& name )
{
    kDebug() << name << endl;

    using namespace KABC;
    QString uid;

    // First search for the emailaddress
    QString theEmailaddress;
    QString theName;
    KPIMUtils::normalizedAddress( name, theEmailaddress, theName );
    Addressee::List a( m_ab->findByEmail( theEmailaddress ) );
    if ( a.count() > 0 ) {
        kDebug() << "Address exists" << endl;
        uid = a[0].uid();
    } else {
        // not found? add it
        kDebug() << "Address does not exists" << endl;

        KABC::Addressee addr;
        addr.setNameFromString( theName );
        addr.insertEmail( theEmailaddress, true );

        m_ab->insertAddressee( addr );
        KABC::Ticket *ticket = m_ab->requestSaveTicket( addr.resource() );
        if ( ticket )
            m_ab->save( ticket );

        uid = addr.uid();
        kDebug() << "new uid: " << uid << endl;
    }

    // Open it
    if ( !uid.isEmpty() )
        KRun::runCommand( "kaddressbook --uid " + KShell::quoteArg( uid ), 0 );
}

Addressee::List Addressbook::findByEmail( const QString& email )
{
    return m_ab->findByEmail( email );
}
