import { createLogger } from '../../logger.mjs.js';

const logger = createLogger('selectors');

export const selectMindrs = (/** @type {MailmindrState} */ state) =>
    state.mindrs || [];

export const selectMindrByGuid = (
    /** @type {MailmindrState} */ state,
    guid
) => {
    const mindrs = selectMindrs(state);
    const result = (mindrs || []).find(item => item.guid === guid);

    return result;
};

export const selectOpenDialogs = (/** @type {MailmindrState} */ state) =>
    state.openDialogs || [];

export const selectDialogForType = (
    /** @type {MailmindrState} */ state,
    dialogType
) => {
    const openDialogs = selectOpenDialogs(state);
    logger.log(selectDialogForType.name, { state, openDialogs });
    return openDialogs.find(dialog => dialog.dialogType === dialogType);
};

export const selectSettings = (/** @type {MailmindrState} */ state) =>
    state.settings;

export const selectPresets = (/** @type {MailmindrState} */ state) =>
    state.presets;

export const selectOpenConnections = (/** @type {MailmindrState} */ state) =>
    state.openConnections || [];
