/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-message.h"

#include "mn-message-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 44 "mn-message.gob"

#include "config.h"
#include <errno.h>
#include <glib/gi18n.h>
#include <gnome.h>
#include <libgnomevfs/gnome-vfs.h>
#include "mn-util.h"

#line 35 "mn-message.c"
/* self casting macros */
#define SELF(x) MN_MESSAGE(x)
#define SELF_CONST(x) MN_MESSAGE_CONST(x)
#define IS_SELF(x) MN_IS_MESSAGE(x)
#define TYPE_SELF MN_TYPE_MESSAGE
#define SELF_CLASS(x) MN_MESSAGE_CLASS(x)

#define SELF_GET_CLASS(x) MN_MESSAGE_GET_CLASS(x)

/* self typedefs */
typedef MNMessage Self;
typedef MNMessageClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_message_init (MNMessage * o) G_GNUC_UNUSED;
static void mn_message_class_init (MNMessageClass * c) G_GNUC_UNUSED;
static GObject * ___1_mn_message_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean mn_message_get_subst (MNMessage * self, const char * prop_name, char ** result) G_GNUC_UNUSED;
static char * mn_message_subst_command (MNMessage * self, const char * command, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_execute_command_real (MNMessage * self, const char * command, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_execute_command (MNMessage * self, const char * id, gboolean * status, GError ** err) G_GNUC_UNUSED;
static gboolean ___real_mn_message_can_open_impl (MNMessage * self);
static gboolean mn_message_can_open_impl (MNMessage * self) G_GNUC_UNUSED;
static gboolean ___real_mn_message_open_impl (MNMessage * self, GError ** err);
static gboolean mn_message_open_impl (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean ___real_mn_message_can_mark_as_read_impl (MNMessage * self);
static gboolean mn_message_can_mark_as_read_impl (MNMessage * self) G_GNUC_UNUSED;
static gboolean mn_message_mark_as_read_real (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_mark_as_read_impl (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean ___real_mn_message_can_mark_as_spam (MNMessage * self);
static gboolean ___real_mn_message_can_mark_as_spam_impl (MNMessage * self);
static gboolean mn_message_can_mark_as_spam_impl (MNMessage * self) G_GNUC_UNUSED;
static gboolean mn_message_mark_as_spam_real (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_mark_as_spam_impl (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean ___real_mn_message_can_delete (MNMessage * self);
static gboolean ___real_mn_message_can_delete_impl (MNMessage * self);
static gboolean mn_message_can_delete_impl (MNMessage * self) G_GNUC_UNUSED;
static gboolean mn_message_delete_real (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_delete_impl (MNMessage * self, GError ** err) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_MAILBOX,
	PROP_ERROR,
	PROP_SENT_TIME,
	PROP_ID,
	PROP_FROM,
	PROP_SUBJECT,
	PROP_URI,
	PROP_FILENAME,
	PROP_FLAGS
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_subst mn_message_get_subst
#define self_subst_command mn_message_subst_command
#define self_execute_command_real mn_message_execute_command_real
#define self_execute_command mn_message_execute_command
#define self_can_open mn_message_can_open
#define self_can_open_impl mn_message_can_open_impl
#define self_open mn_message_open
#define self_open_impl mn_message_open_impl
#define self_can_mark_as_read mn_message_can_mark_as_read
#define self_can_mark_as_read_impl mn_message_can_mark_as_read_impl
#define self_mark_as_read_real mn_message_mark_as_read_real
#define self_mark_as_read mn_message_mark_as_read
#define self_mark_as_read_impl mn_message_mark_as_read_impl
#define self_can_mark_as_spam mn_message_can_mark_as_spam
#define self_can_mark_as_spam_impl mn_message_can_mark_as_spam_impl
#define self_mark_as_spam_real mn_message_mark_as_spam_real
#define self_mark_as_spam mn_message_mark_as_spam
#define self_mark_as_spam_impl mn_message_mark_as_spam_impl
#define self_can_delete mn_message_can_delete
#define self_can_delete_impl mn_message_can_delete_impl
#define self_delete_real mn_message_delete_real
#define self_delete mn_message_delete
#define self_delete_impl mn_message_delete_impl
#define self_new mn_message_new
#define self_new_from_error mn_message_new_from_error
#define self_xml_node_new mn_message_xml_node_new
GType
mn_message_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMessageClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_message_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMessage),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_message_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMessage", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMessage *)g_object_new(mn_message_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMessage * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMessage *
GET_NEW_VARG (const char *first, ...)
{
	MNMessage *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMessage *)g_object_new_valist (mn_message_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Message::finalize"
	MNMessage *self G_GNUC_UNUSED = MN_MESSAGE (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 68 "mn-message.gob"
	if(self->error) { g_free ((gpointer) self->error); self->error = NULL; }
#line 173 "mn-message.c"
#line 76 "mn-message.gob"
	if(self->id) { g_free ((gpointer) self->id); self->id = NULL; }
#line 176 "mn-message.c"
#line 80 "mn-message.gob"
	if(self->from) { g_free ((gpointer) self->from); self->from = NULL; }
#line 179 "mn-message.c"
#line 84 "mn-message.gob"
	if(self->subject) { g_free ((gpointer) self->subject); self->subject = NULL; }
#line 182 "mn-message.c"
#line 88 "mn-message.gob"
	if(self->uri) { g_free ((gpointer) self->uri); self->uri = NULL; }
#line 185 "mn-message.c"
}
#undef __GOB_FUNCTION__

static void 
mn_message_init (MNMessage * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message::init"
}
#undef __GOB_FUNCTION__
static void 
mn_message_class_init (MNMessageClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 100 "mn-message.gob"
	g_object_class->constructor = ___1_mn_message_constructor;
#line 327 "mn-message.gob"
	c->can_open_impl = ___real_mn_message_can_open_impl;
#line 347 "mn-message.gob"
	c->open_impl = ___real_mn_message_open_impl;
#line 359 "mn-message.gob"
	c->can_mark_as_read_impl = ___real_mn_message_can_mark_as_read_impl;
#line 211 "mn-message.c"
	c->mark_as_read_impl = NULL;
#line 391 "mn-message.gob"
	c->can_mark_as_spam = ___real_mn_message_can_mark_as_spam;
#line 397 "mn-message.gob"
	c->can_mark_as_spam_impl = ___real_mn_message_can_mark_as_spam_impl;
#line 217 "mn-message.c"
	c->mark_as_spam_impl = NULL;
#line 429 "mn-message.gob"
	c->can_delete = ___real_mn_message_can_delete;
#line 435 "mn-message.gob"
	c->can_delete_impl = ___real_mn_message_can_delete_impl;
#line 223 "mn-message.c"
	c->delete_impl = NULL;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("mailbox" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_MAILBOX,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
	param_spec = g_param_spec_ulong
		("sent_time" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 G_MAXULONG /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SENT_TIME,
		param_spec);
	param_spec = g_param_spec_string
		("id" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_ID,
		param_spec);
	param_spec = g_param_spec_string
		("from" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_FROM,
		param_spec);
	param_spec = g_param_spec_string
		("subject" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SUBJECT,
		param_spec);
	param_spec = g_param_spec_string
		("uri" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_URI,
		param_spec);
	param_spec = g_param_spec_string
		("filename" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | MN_MESSAGE_PARAM_EXPORT));
	g_object_class_install_property (g_object_class,
		PROP_FILENAME,
		param_spec);
	param_spec = g_param_spec_uint
		("flags" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 G_MAXUINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_FLAGS,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message::set_property"
{
	MNMessage *self G_GNUC_UNUSED;

	self = MN_MESSAGE (object);

	switch (property_id) {
	case PROP_MAILBOX:
		{
#line 65 "mn-message.gob"
self->mailbox = g_value_get_pointer (VAL);
#line 335 "mn-message.c"
		}
		break;
	case PROP_ERROR:
		{
#line 69 "mn-message.gob"
{ char *old = self->error; self->error = g_value_dup_string (VAL); g_free (old); }
#line 342 "mn-message.c"
		}
		break;
	case PROP_SENT_TIME:
		{
#line 73 "mn-message.gob"
self->sent_time = g_value_get_ulong (VAL);
#line 349 "mn-message.c"
		}
		break;
	case PROP_ID:
		{
#line 77 "mn-message.gob"
{ char *old = self->id; self->id = g_value_dup_string (VAL); g_free (old); }
#line 356 "mn-message.c"
		}
		break;
	case PROP_FROM:
		{
#line 81 "mn-message.gob"
{ char *old = self->from; self->from = g_value_dup_string (VAL); g_free (old); }
#line 363 "mn-message.c"
		}
		break;
	case PROP_SUBJECT:
		{
#line 85 "mn-message.gob"
{ char *old = self->subject; self->subject = g_value_dup_string (VAL); g_free (old); }
#line 370 "mn-message.c"
		}
		break;
	case PROP_URI:
		{
#line 89 "mn-message.gob"
{ char *old = self->uri; self->uri = g_value_dup_string (VAL); g_free (old); }
#line 377 "mn-message.c"
		}
		break;
	case PROP_FLAGS:
		{
#line 98 "mn-message.gob"
self->flags = g_value_get_uint (VAL);
#line 384 "mn-message.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message::get_property"
{
	MNMessage *self G_GNUC_UNUSED;

	self = MN_MESSAGE (object);

	switch (property_id) {
	case PROP_MAILBOX:
		{
#line 65 "mn-message.gob"
g_value_set_pointer (VAL, self->mailbox);
#line 415 "mn-message.c"
		}
		break;
	case PROP_ERROR:
		{
#line 69 "mn-message.gob"
g_value_set_string (VAL, self->error);
#line 422 "mn-message.c"
		}
		break;
	case PROP_SENT_TIME:
		{
#line 73 "mn-message.gob"
g_value_set_ulong (VAL, self->sent_time);
#line 429 "mn-message.c"
		}
		break;
	case PROP_ID:
		{
#line 77 "mn-message.gob"
g_value_set_string (VAL, self->id);
#line 436 "mn-message.c"
		}
		break;
	case PROP_FROM:
		{
#line 81 "mn-message.gob"
g_value_set_string (VAL, self->from);
#line 443 "mn-message.c"
		}
		break;
	case PROP_SUBJECT:
		{
#line 85 "mn-message.gob"
g_value_set_string (VAL, self->subject);
#line 450 "mn-message.c"
		}
		break;
	case PROP_URI:
		{
#line 89 "mn-message.gob"
g_value_set_string (VAL, self->uri);
#line 457 "mn-message.c"
		}
		break;
	case PROP_FILENAME:
		{
#line 93 "mn-message.gob"

      g_value_take_string(VAL, self->uri ? gnome_vfs_get_local_path_from_uri(self->uri) : NULL);
    
#line 466 "mn-message.c"
		}
		break;
	case PROP_FLAGS:
		{
#line 98 "mn-message.gob"
g_value_set_uint (VAL, self->flags);
#line 473 "mn-message.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 100 "mn-message.gob"
static GObject * 
___1_mn_message_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 493 "mn-message.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Message::constructor"
{
#line 102 "mn-message.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    g_assert(MN_IS_MAILBOX(self->mailbox));

    if (! self->id)
      {
	GString *id;

	/*
	 * An ID should (not mandatory):
	 *
	 *	- be unique (application-wise, because we use the ID
	 *	  to check if a message has already been displayed in
	 *	  the mail summary popup)
	 *	- persist across checks if the message does not change
	 */

	id = g_string_new(NULL);

	if (self->sent_time > 0)
	  g_string_append_printf(id, ":sent-time:%i:", (int) self->sent_time);
	if (self->from)
	  g_string_append_printf(id, ":from:%s:", self->from);
	if (self->subject)
	  g_string_append_printf(id, ":subject:%s:", self->subject);

	if (! *id->str)
	  {
	    static int unique = 0;
	    g_string_append_printf(id, "%i", g_atomic_int_exchange_and_add(&unique, 1));
	  }

	self->id = g_string_free(id, FALSE);
      }

    /* these must be filled after we have processed the id */

    if (! self->from)
      self->from = g_strdup(_("Unknown"));
    if (! self->subject)
      self->subject = g_strdup("");

    return object;
  }}
#line 551 "mn-message.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 152 "mn-message.gob"
static gboolean 
mn_message_get_subst (MNMessage * self, const char * prop_name, char ** result)
#line 558 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::get_subst"
#line 152 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 152 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 152 "mn-message.gob"
	g_return_val_if_fail (prop_name != NULL, (gboolean )0);
#line 152 "mn-message.gob"
	g_return_val_if_fail (result != NULL, (gboolean )0);
#line 569 "mn-message.c"
{
#line 156 "mn-message.gob"
	
    GParamSpec **properties;
    unsigned int n_properties;
    gboolean status = FALSE;
    int i;

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MESSAGE_PARAM_EXPORT) != 0
	  && ! strcmp(g_param_spec_get_name(properties[i]), prop_name))
	{
	  GValue value = { 0, };

	  g_value_init(&value, G_PARAM_SPEC_VALUE_TYPE(properties[i]));
	  g_object_get_property(G_OBJECT(self), prop_name, &value);

	  *result = mn_g_value_to_string(&value);
	  g_value_unset(&value);

	  status = TRUE;
	  break;
	}
    g_free(properties);

    return status;
  }}
#line 598 "mn-message.c"
#undef __GOB_FUNCTION__

#line 183 "mn-message.gob"
static char * 
mn_message_subst_command (MNMessage * self, const char * command, GError ** err)
#line 604 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::subst_command"
#line 183 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 183 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (char * )0);
#line 183 "mn-message.gob"
	g_return_val_if_fail (command != NULL, (char * )0);
#line 613 "mn-message.c"
{
#line 185 "mn-message.gob"
	
    GString *result;
    const char *p;

    result = g_string_new(NULL);

    for (p = command; *p;)
      if (*p == '%')
	{
	  char *prop_name = NULL;

	  if (p[1] == '%')
	    {
	      g_string_append_c(result, '%');
	      p += 2;
	    }
	  else if (p[1] == '{')
	    {
	      char *end;

	      end = strchr(p + 2, '}');
	      if (! end)
		{
		  g_set_error(err, 0, 0, _("unterminated substitution"));
		  goto error;
		}

	      prop_name = g_strndup(p + 2, end - p - 2);
	      p = end + 1;
	    }
	  else
	    {
	      const char *end = p + 1;

	      while (g_ascii_isalnum(*end) || *end == '-' || *end == '_')
		end++;

	      prop_name = g_strndup(p + 1, end - p - 1);
	      p = end;
	    }

	  if (prop_name)
	    {
	      gboolean ok = FALSE;

	      if (*prop_name)
		{
		  char *value;

		  if (self_get_subst(self, prop_name, &value))
		    {
		      char *quoted;

		      quoted = mn_shell_quote_safe(value ? value : "");
		      g_free(value);

		      g_string_append(result, quoted);
		      g_free(quoted);

		      ok = TRUE;
		    }
		  else
		    g_set_error(err, 0, 0, _("unknown substitution \"%s\""), prop_name);
		}
	      else
		g_set_error(err, 0, 0, _("empty substitution"));

	      g_free(prop_name);
	      if (! ok)
		goto error;
	    }
	}
      else
	{
	  g_string_append_c(result, *p);
	  p++;
	}

    goto end;			/* success */

  error:
    g_string_free(result, TRUE);
    result = NULL;

  end:
    return result ? g_string_free(result, FALSE) : NULL;
  }}
#line 703 "mn-message.c"
#undef __GOB_FUNCTION__

#line 273 "mn-message.gob"
static gboolean 
mn_message_execute_command_real (MNMessage * self, const char * command, GError ** err)
#line 709 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::execute_command_real"
#line 273 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 273 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 273 "mn-message.gob"
	g_return_val_if_fail (command != NULL, (gboolean )0);
#line 718 "mn-message.c"
{
#line 277 "mn-message.gob"
	
    char *subst;
    int status;

    subst = self_subst_command(self, command, err);
    if (! subst)
      return FALSE;

    status = gnome_execute_shell(NULL, subst);
    g_free(subst);

    if (status < 0)
      {
	g_set_error(err, 0, 0, "%s", g_strerror(errno));
	return FALSE;
      }

    return TRUE;
  }}
#line 740 "mn-message.c"
#undef __GOB_FUNCTION__

#line 297 "mn-message.gob"
static gboolean 
mn_message_execute_command (MNMessage * self, const char * id, gboolean * status, GError ** err)
#line 746 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::execute_command"
#line 297 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 297 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 297 "mn-message.gob"
	g_return_val_if_fail (id != NULL, (gboolean )0);
#line 297 "mn-message.gob"
	g_return_val_if_fail (status != NULL, (gboolean )0);
#line 757 "mn-message.c"
{
#line 302 "mn-message.gob"
	
    char *command;
    GError *tmp_err = NULL;

    command = mn_mailbox_get_command(self->mailbox, id);
    if (! command)
      return FALSE;

    *status = self_execute_command_real(self, command, &tmp_err);
    if (! *status)
      {
	g_set_error(err, 0, 0, _("Unable to execute \"%s\": %s."), command, tmp_err->message);
	g_error_free(tmp_err);
      }

    g_free(command);
    return TRUE;
  }}
#line 778 "mn-message.c"
#undef __GOB_FUNCTION__

#line 321 "mn-message.gob"
gboolean 
mn_message_can_open (MNMessage * self)
#line 784 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_open"
#line 321 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 321 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 791 "mn-message.c"
{
#line 323 "mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, "open") || self_can_open_impl(self);
  }}
#line 797 "mn-message.c"
#undef __GOB_FUNCTION__

#line 327 "mn-message.gob"
static gboolean 
mn_message_can_open_impl (MNMessage * self)
#line 803 "mn-message.c"
{
	MNMessageClass *klass;
#line 327 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 327 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 810 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_open_impl)
		return (*klass->can_open_impl)(self);
	else
		return (gboolean )(0);
}
#line 327 "mn-message.gob"
static gboolean 
___real_mn_message_can_open_impl (MNMessage * self G_GNUC_UNUSED)
#line 821 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_open_impl"
{
#line 329 "mn-message.gob"
	
    return self->uri != NULL;
  }}
#line 829 "mn-message.c"
#undef __GOB_FUNCTION__

#line 333 "mn-message.gob"
gboolean 
mn_message_open (MNMessage * self, GError ** err)
#line 835 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::open"
#line 333 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 333 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 842 "mn-message.c"
{
#line 335 "mn-message.gob"
	
    gboolean status;

    if (self_execute_command(self, "open", &status, err))
      {
	mn_mailbox_mark_as_read(self);
	return status;
      }
    else
      return self_open_impl(self, err);
  }}
#line 856 "mn-message.c"
#undef __GOB_FUNCTION__

#line 347 "mn-message.gob"
static gboolean 
mn_message_open_impl (MNMessage * self, GError ** err)
#line 862 "mn-message.c"
{
	MNMessageClass *klass;
#line 347 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 347 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 869 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->open_impl)
		return (*klass->open_impl)(self,err);
	else
		return (gboolean )(0);
}
#line 347 "mn-message.gob"
static gboolean 
___real_mn_message_open_impl (MNMessage * self G_GNUC_UNUSED, GError ** err)
#line 880 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::open_impl"
{
#line 349 "mn-message.gob"
	
    return gnome_url_show(self->uri, err);
  }}
#line 888 "mn-message.c"
#undef __GOB_FUNCTION__

#line 353 "mn-message.gob"
gboolean 
mn_message_can_mark_as_read (MNMessage * self)
#line 894 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_mark_as_read"
#line 353 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 353 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 901 "mn-message.c"
{
#line 355 "mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, "mark-as-read") || self_can_mark_as_read_impl(self);
  }}
#line 907 "mn-message.c"
#undef __GOB_FUNCTION__

#line 359 "mn-message.gob"
static gboolean 
mn_message_can_mark_as_read_impl (MNMessage * self)
#line 913 "mn-message.c"
{
	MNMessageClass *klass;
#line 359 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 359 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 920 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_mark_as_read_impl)
		return (*klass->can_mark_as_read_impl)(self);
	else
		return (gboolean )(0);
}
#line 359 "mn-message.gob"
static gboolean 
___real_mn_message_can_mark_as_read_impl (MNMessage * self G_GNUC_UNUSED)
#line 931 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_mark_as_read_impl"
{
#line 361 "mn-message.gob"
	
    return SELF_GET_CLASS(self)->mark_as_read_impl != NULL;
  }}
#line 939 "mn-message.c"
#undef __GOB_FUNCTION__

#line 365 "mn-message.gob"
static gboolean 
mn_message_mark_as_read_real (MNMessage * self, GError ** err)
#line 945 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::mark_as_read_real"
#line 365 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 365 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 952 "mn-message.c"
{
#line 367 "mn-message.gob"
	
    gboolean status;

    if (self_execute_command(self, "mark-as-read", &status, err))
      return status;
    else
      return self_mark_as_read_impl(self, err);
  }}
#line 963 "mn-message.c"
#undef __GOB_FUNCTION__

#line 376 "mn-message.gob"
gboolean 
mn_message_mark_as_read (MNMessage * self, GError ** err)
#line 969 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::mark_as_read"
#line 376 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 376 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 976 "mn-message.c"
{
#line 378 "mn-message.gob"
	
    if (self_mark_as_read_real(self, err))
      {
	mn_mailbox_mark_as_read(self);
	return TRUE;
      }
    else
      return FALSE;
  }}
#line 988 "mn-message.c"
#undef __GOB_FUNCTION__

#line 388 "mn-message.gob"
static gboolean 
mn_message_mark_as_read_impl (MNMessage * self, GError ** err)
#line 994 "mn-message.c"
{
	MNMessageClass *klass;
#line 388 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 388 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1001 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->mark_as_read_impl)
		return (*klass->mark_as_read_impl)(self,err);
	else
		return (gboolean )(0);
}

#line 391 "mn-message.gob"
gboolean 
mn_message_can_mark_as_spam (MNMessage * self)
#line 1013 "mn-message.c"
{
	MNMessageClass *klass;
#line 391 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 391 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1020 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_mark_as_spam)
		return (*klass->can_mark_as_spam)(self);
	else
		return (gboolean )(0);
}
#line 391 "mn-message.gob"
static gboolean 
___real_mn_message_can_mark_as_spam (MNMessage * self G_GNUC_UNUSED)
#line 1031 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_mark_as_spam"
{
#line 393 "mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, "mark-as-spam") || self_can_mark_as_spam_impl(self);
  }}
#line 1039 "mn-message.c"
#undef __GOB_FUNCTION__

#line 397 "mn-message.gob"
static gboolean 
mn_message_can_mark_as_spam_impl (MNMessage * self)
#line 1045 "mn-message.c"
{
	MNMessageClass *klass;
#line 397 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 397 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1052 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_mark_as_spam_impl)
		return (*klass->can_mark_as_spam_impl)(self);
	else
		return (gboolean )(0);
}
#line 397 "mn-message.gob"
static gboolean 
___real_mn_message_can_mark_as_spam_impl (MNMessage * self G_GNUC_UNUSED)
#line 1063 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_mark_as_spam_impl"
{
#line 399 "mn-message.gob"
	
    return SELF_GET_CLASS(self)->mark_as_spam_impl != NULL;
  }}
#line 1071 "mn-message.c"
#undef __GOB_FUNCTION__

#line 403 "mn-message.gob"
static gboolean 
mn_message_mark_as_spam_real (MNMessage * self, GError ** err)
#line 1077 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::mark_as_spam_real"
#line 403 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 403 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1084 "mn-message.c"
{
#line 405 "mn-message.gob"
	
    gboolean status;

    if (self_execute_command(self, "mark-as-spam", &status, err))
      return status;
    else
      return self_mark_as_spam_impl(self, err);
  }}
#line 1095 "mn-message.c"
#undef __GOB_FUNCTION__

#line 414 "mn-message.gob"
gboolean 
mn_message_mark_as_spam (MNMessage * self, GError ** err)
#line 1101 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::mark_as_spam"
#line 414 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 414 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1108 "mn-message.c"
{
#line 416 "mn-message.gob"
	
    if (self_mark_as_spam_real(self, err))
      {
	mn_mailbox_mark_as_read(self);
	return TRUE;
      }
    else
      return FALSE;
  }}
#line 1120 "mn-message.c"
#undef __GOB_FUNCTION__

#line 426 "mn-message.gob"
static gboolean 
mn_message_mark_as_spam_impl (MNMessage * self, GError ** err)
#line 1126 "mn-message.c"
{
	MNMessageClass *klass;
#line 426 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 426 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1133 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->mark_as_spam_impl)
		return (*klass->mark_as_spam_impl)(self,err);
	else
		return (gboolean )(0);
}

#line 429 "mn-message.gob"
gboolean 
mn_message_can_delete (MNMessage * self)
#line 1145 "mn-message.c"
{
	MNMessageClass *klass;
#line 429 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 429 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1152 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_delete)
		return (*klass->can_delete)(self);
	else
		return (gboolean )(0);
}
#line 429 "mn-message.gob"
static gboolean 
___real_mn_message_can_delete (MNMessage * self G_GNUC_UNUSED)
#line 1163 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_delete"
{
#line 431 "mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, "delete") || self_can_delete_impl(self);
  }}
#line 1171 "mn-message.c"
#undef __GOB_FUNCTION__

#line 435 "mn-message.gob"
static gboolean 
mn_message_can_delete_impl (MNMessage * self)
#line 1177 "mn-message.c"
{
	MNMessageClass *klass;
#line 435 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 435 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1184 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_delete_impl)
		return (*klass->can_delete_impl)(self);
	else
		return (gboolean )(0);
}
#line 435 "mn-message.gob"
static gboolean 
___real_mn_message_can_delete_impl (MNMessage * self G_GNUC_UNUSED)
#line 1195 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_delete_impl"
{
#line 437 "mn-message.gob"
	
    return SELF_GET_CLASS(self)->delete_impl != NULL;
  }}
#line 1203 "mn-message.c"
#undef __GOB_FUNCTION__

#line 441 "mn-message.gob"
static gboolean 
mn_message_delete_real (MNMessage * self, GError ** err)
#line 1209 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::delete_real"
#line 441 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 441 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1216 "mn-message.c"
{
#line 443 "mn-message.gob"
	
    gboolean status;

    if (self_execute_command(self, "delete", &status, err))
      return status;
    else
      return self_delete_impl(self, err);
  }}
#line 1227 "mn-message.c"
#undef __GOB_FUNCTION__

#line 452 "mn-message.gob"
gboolean 
mn_message_delete (MNMessage * self, GError ** err)
#line 1233 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::delete"
#line 452 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 452 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1240 "mn-message.c"
{
#line 454 "mn-message.gob"
	
    if (self_delete_real(self, err))
      {
	mn_mailbox_mark_as_read(self);
	return TRUE;
      }
    else
      return FALSE;
  }}
#line 1252 "mn-message.c"
#undef __GOB_FUNCTION__

#line 464 "mn-message.gob"
static gboolean 
mn_message_delete_impl (MNMessage * self, GError ** err)
#line 1258 "mn-message.c"
{
	MNMessageClass *klass;
#line 464 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 464 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1265 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->delete_impl)
		return (*klass->delete_impl)(self,err);
	else
		return (gboolean )(0);
}

#line 467 "mn-message.gob"
MNMessage * 
mn_message_new (MNMailbox * mailbox, const char * error, time_t sent_time, const char * id, const char * from, const char * subject, const char * uri, MNMessageFlags flags)
#line 1277 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::new"
#line 467 "mn-message.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMessage * )0);
#line 467 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMessage * )0);
#line 1284 "mn-message.c"
{
#line 476 "mn-message.gob"
	
    return GET_NEW_VARG(MN_MESSAGE_PROP_MAILBOX(mailbox),
			MN_MESSAGE_PROP_ERROR((char *) error),
			MN_MESSAGE_PROP_SENT_TIME(sent_time),
			MN_MESSAGE_PROP_ID((char *) id),
			MN_MESSAGE_PROP_FROM((char *) from),
			MN_MESSAGE_PROP_SUBJECT((char *) subject),
			MN_MESSAGE_PROP_URI((char *) uri),
			MN_MESSAGE_PROP_FLAGS(flags),
			NULL);
  }}
#line 1298 "mn-message.c"
#undef __GOB_FUNCTION__

#line 488 "mn-message.gob"
MNMessage * 
mn_message_new_from_error (MNMailbox * mailbox, const char * error, MNMessageFlags flags)
#line 1304 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::new_from_error"
#line 488 "mn-message.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMessage * )0);
#line 488 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMessage * )0);
#line 488 "mn-message.gob"
	g_return_val_if_fail (error != NULL, (MNMessage * )0);
#line 1313 "mn-message.c"
{
#line 492 "mn-message.gob"
	
    return self_new(mailbox, error, 0, NULL, NULL, NULL, NULL, flags);
  }}
#line 1319 "mn-message.c"
#undef __GOB_FUNCTION__

#line 496 "mn-message.gob"
xmlNode * 
mn_message_xml_node_new (MNMessage * self)
#line 1325 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::xml_node_new"
#line 496 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (xmlNode * )0);
#line 496 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (xmlNode * )0);
#line 1332 "mn-message.c"
{
#line 498 "mn-message.gob"
	
    xmlNode *node;

    node = xmlNewNode(NULL, "message");

    xmlSetProp(node, "mailbox", self->mailbox->runtime_name);

    if ((self->flags & MN_MESSAGE_NEW) != 0)
      xmlSetProp(node, "new", "true");

    mn_xml_export_properties(G_OBJECT(self), node);

    return node;
  }}
#line 1349 "mn-message.c"
#undef __GOB_FUNCTION__
