/* Generated by GOB (v2.0.12) on Tue Aug  9 22:01:57 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 12

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-vfs-mailbox.h"

#include "mn-vfs-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 35 "mn-vfs-mailbox.gob"

#include "config.h"
#include <glib/gi18n.h>
#ifdef WITH_MBOX
#include "mn-mbox-mailbox-backend.h"
#endif
#ifdef WITH_MH
#include "mn-mh-mailbox-backend.h"
#endif
#ifdef WITH_MAILDIR
#include "mn-maildir-mailbox-backend.h"
#endif
#ifdef WITH_SYLPHEED
#include "mn-sylpheed-mailbox-backend.h"
#endif
#include "mn-vfs.h"
#include "mn-stock.h"
#include "mn-conf.h"

GType mn_vfs_mailbox_backend_types[MN_VFS_MAILBOX_MAX_BACKEND_TYPES + 1];

#line 49 "mn-vfs-mailbox.c"
/* self casting macros */
#define SELF(x) MN_VFS_MAILBOX(x)
#define SELF_CONST(x) MN_VFS_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_VFS_MAILBOX(x)
#define TYPE_SELF MN_TYPE_VFS_MAILBOX
#define SELF_CLASS(x) MN_VFS_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_VFS_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNVFSMailbox Self;
typedef MNVFSMailboxClass SelfClass;

/* here are local prototypes */
static void mn_vfs_mailbox_init (MNVFSMailbox * o) G_GNUC_UNUSED;
static void mn_vfs_mailbox_class_init (MNVFSMailboxClass * c) G_GNUC_UNUSED;
static GObject * ___2_mn_vfs_mailbox_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___3_mn_vfs_mailbox_dispose (GObject * object) G_GNUC_UNUSED;
static void ___4_mn_vfs_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_vfs_mailbox_monitor_cb (GnomeVFSMonitorHandle * handle, const char * monitor_uri, const char * info_uri, GnomeVFSMonitorEventType event_type, gpointer user_data) G_GNUC_UNUSED;
static void ___6_mn_vfs_mailbox_impl_check (MNReentrantMailbox * mailbox, unsigned long check_id) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNReentrantMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_init_types mn_vfs_mailbox_init_types
#define self_monitor_cb mn_vfs_mailbox_monitor_cb
#define self_monitor_error_dialog mn_vfs_mailbox_monitor_error_dialog
GType
mn_vfs_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNVFSMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_vfs_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNVFSMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_vfs_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_REENTRANT_MAILBOX, "MNVFSMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNVFSMailbox *)g_object_new(mn_vfs_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNVFSMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNVFSMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNVFSMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNVFSMailbox *)g_object_new_valist (mn_vfs_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::dispose"
	MNVFSMailbox *self G_GNUC_UNUSED = MN_VFS_MAILBOX (obj_self);
#line 108 "mn-vfs-mailbox.gob"
	___3_mn_vfs_mailbox_dispose(obj_self);
#line 129 "mn-vfs-mailbox.c"
#line 62 "mn-vfs-mailbox.gob"
	if(self->vfs_uri) { gnome_vfs_uri_unref ((gpointer) self->vfs_uri); self->vfs_uri = NULL; }
#line 132 "mn-vfs-mailbox.c"
#line 69 "mn-vfs-mailbox.gob"
	if(self->_priv->backend) { g_object_unref ((gpointer) self->_priv->backend); self->_priv->backend = NULL; }
#line 135 "mn-vfs-mailbox.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::finalize"
	MNVFSMailbox *self G_GNUC_UNUSED = MN_VFS_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 61 "mn-vfs-mailbox.gob"
	if(self->uri) { g_free ((gpointer) self->uri); self->uri = NULL; }
#line 150 "mn-vfs-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_vfs_mailbox_init (MNVFSMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_VFS_MAILBOX,MNVFSMailboxPrivate);
#line 35 "mn-vfs-mailbox.gob"
	o->_priv->type_monitor_result = GNOME_VFS_OK;
#line 161 "mn-vfs-mailbox.c"
#line 35 "mn-vfs-mailbox.gob"
	o->contents_monitor_result = GNOME_VFS_OK;
#line 164 "mn-vfs-mailbox.c"
}
#undef __GOB_FUNCTION__
static void 
mn_vfs_mailbox_class_init (MNVFSMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)c;
	MNReentrantMailboxClass *mn_reentrant_mailbox_class = (MNReentrantMailboxClass *)c;

	g_type_class_add_private(c,sizeof(MNVFSMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_REENTRANT_MAILBOX);

#line 91 "mn-vfs-mailbox.gob"
	g_object_class->constructor = ___2_mn_vfs_mailbox_constructor;
#line 108 "mn-vfs-mailbox.gob"
	g_object_class->dispose = ___dispose;
#line 126 "mn-vfs-mailbox.gob"
	mn_mailbox_class->seal = ___4_mn_vfs_mailbox_seal;
#line 171 "mn-vfs-mailbox.gob"
	mn_reentrant_mailbox_class->impl_check = ___6_mn_vfs_mailbox_impl_check;
#line 187 "mn-vfs-mailbox.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 71 "mn-vfs-mailbox.gob"
void 
mn_vfs_mailbox_init_types (void)
#line 197 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::init_types"
{
#line 73 "mn-vfs-mailbox.gob"
	
    int i = 0;

#ifdef WITH_MBOX
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_MBOX_MAILBOX_BACKEND;
#endif
#ifdef WITH_MH
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_MH_MAILBOX_BACKEND;
#endif
#ifdef WITH_MAILDIR
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_MAILDIR_MAILBOX_BACKEND;
#endif
#ifdef WITH_SYLPHEED
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_SYLPHEED_MAILBOX_BACKEND;
#endif
    mn_vfs_mailbox_backend_types[i] = 0;
  }}
#line 219 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 91 "mn-vfs-mailbox.gob"
static GObject * 
___2_mn_vfs_mailbox_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 225 "mn-vfs-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::constructor"
{
#line 93 "mn-vfs-mailbox.gob"
	
    GObject *object;
    Self *self;
    SelfClass *class;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);
    class = SELF_GET_CLASS(self);

    if (class->stock_id)
      mn_mailbox_set_stock_id(MN_MAILBOX(self), (char *) class->stock_id);

    return object;
  }}
#line 248 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 108 "mn-vfs-mailbox.gob"
static void 
___3_mn_vfs_mailbox_dispose (GObject * object G_GNUC_UNUSED)
#line 255 "mn-vfs-mailbox.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::dispose"
{
#line 110 "mn-vfs-mailbox.gob"
	
    Self *self = SELF(object);

    /*
     * We are no longer operational after dispose (see unrefwith
     * above), so we must remove our monitor.
     */
    if (selfp->monitor_handle)
      {
	gnome_vfs_monitor_cancel(selfp->monitor_handle);
	selfp->monitor_handle = NULL;
      }

    PARENT_HANDLER(object);
  }}
#line 278 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 126 "mn-vfs-mailbox.gob"
static void 
___4_mn_vfs_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 285 "mn-vfs-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::seal"
{
#line 128 "mn-vfs-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    if (self->uri)
      {
	self->vfs_uri = gnome_vfs_uri_new(self->uri);

	if (! mailbox->runtime_name)
	  {
	    char *path;

	    path = gnome_vfs_get_local_path_from_uri(self->uri);
	    if (path)
	      {
		mailbox->runtime_name = g_filename_display_name(path);
		g_free(path);
	      }
	    else
	      mailbox->runtime_name = self->vfs_uri
		? gnome_vfs_uri_to_string(self->vfs_uri, GNOME_VFS_URI_HIDE_PASSWORD)
		: g_strdup(self->uri);
	  }
      }
  }}
#line 319 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 155 "mn-vfs-mailbox.gob"
static void 
mn_vfs_mailbox_monitor_cb (GnomeVFSMonitorHandle * handle, const char * monitor_uri, const char * info_uri, GnomeVFSMonitorEventType event_type, gpointer user_data)
#line 326 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::monitor_cb"
{
#line 161 "mn-vfs-mailbox.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	Self *self = user_data;
	mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(self));
      }
  }}
#line 340 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 171 "mn-vfs-mailbox.gob"
static void 
___6_mn_vfs_mailbox_impl_check (MNReentrantMailbox * mailbox G_GNUC_UNUSED, unsigned long check_id)
#line 346 "mn-vfs-mailbox.c"
#define PARENT_HANDLER(___mailbox,___check_id) \
	{ if(MN_REENTRANT_MAILBOX_CLASS(parent_class)->impl_check) \
		(* MN_REENTRANT_MAILBOX_CLASS(parent_class)->impl_check)(___mailbox,___check_id); }
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::impl_check"
{
#line 173 "mn-vfs-mailbox.gob"
	
    Self *self = SELF(mailbox);
    MNVFSMailboxBackend *backend;
    GnomeVFSMonitorHandle *handle;
    GType backend_type = 0;
    gboolean exists;

    mn_reentrant_mailbox_lock(mailbox);

    handle = selfp->monitor_handle;

    backend = selfp->backend;
    if (backend)
      g_object_ref(backend);

    mn_reentrant_mailbox_unlock(mailbox);

    if (! handle)
      {
	GnomeVFSResult result;

	result = gnome_vfs_monitor_add(&handle,
				       self->uri,
				       GNOME_VFS_MONITOR_FILE,
				       self_monitor_cb,
				       self);

	if (result == GNOME_VFS_OK)
	  {
	    mn_reentrant_mailbox_lock(mailbox);

	    if (! selfp->monitor_handle)
	      {
		selfp->monitor_handle = handle;
		handle = NULL;
	      }

	    mn_reentrant_mailbox_unlock(mailbox);

	    if (handle)
	      gnome_vfs_monitor_cancel(handle);
	    else
	      {
		GDK_THREADS_ENTER();
		mn_mailbox_set_must_poll(MN_MAILBOX(self), FALSE);
		gdk_flush();
		GDK_THREADS_LEAVE();
	      }
	  }
	else
	  {
	    gboolean warn = FALSE;

	    mn_reentrant_mailbox_lock(mailbox);

	    if (! selfp->monitor_handle && result != selfp->type_monitor_result)
	      {
		warn = TRUE;
		selfp->type_monitor_result = result;
	      }

	    mn_reentrant_mailbox_unlock(mailbox);
	    
	    if (warn)
	      {
		mn_mailbox_warning(MN_MAILBOX(self), _("unable to monitor mailbox type (%s), poll mode activated"), gnome_vfs_result_to_string(result));
	    
		GDK_THREADS_ENTER();
		self_monitor_error_dialog();
		gdk_flush();
		GDK_THREADS_LEAVE();
	      }
	  }
      }
    
    if (backend && MN_VFS_MAILBOX_BACKEND_GET_CLASS(backend)->is(NULL, self))
      backend_type = G_OBJECT_TYPE(backend);
    else
      {
	exists = mn_vfs_test(self->vfs_uri, G_FILE_TEST_EXISTS);
	if (exists)
	  {
	    int i;

	    for (i = 0; mn_vfs_mailbox_backend_types[i]; i++)
	      {
		MNVFSMailboxBackendClass *class;
		
		class = g_type_class_peek(mn_vfs_mailbox_backend_types[i]);
		g_return_if_fail(class != NULL);
		
		if (class->is(NULL, self))
		  {
		    backend_type = mn_vfs_mailbox_backend_types[i];
		    break;
		  }
		
		if (mn_reentrant_mailbox_check_aborted(mailbox, check_id))
		  goto end;
	      }
	  }
      }
    
    if (! backend || backend_type != G_OBJECT_TYPE(backend))
      {
	gboolean is_local;
	MNVFSMailboxBackend *new_backend = NULL;

	is_local = gnome_vfs_uri_is_local(self->vfs_uri);

	GDK_THREADS_ENTER();

	if (! mn_reentrant_mailbox_check_aborted_unlocked(mailbox, check_id))
	  {
	    if (backend)
	      {
		/* reset must-poll and contents_monitor_result */
		mn_mailbox_set_must_poll(MN_MAILBOX(self), selfp->monitor_handle == NULL);
		self->contents_monitor_result = GNOME_VFS_OK;
	      }

	    if (backend_type)
	      {
		new_backend = g_object_new(backend_type, MN_VFS_MAILBOX_BACKEND_PROP_MAILBOX(self), NULL);

		mn_mailbox_set_format(MN_MAILBOX(self), (char *) MN_VFS_MAILBOX_BACKEND_GET_CLASS(new_backend)->format);
		if (! SELF_GET_CLASS(self)->stock_id)
		  mn_mailbox_set_stock_id(MN_MAILBOX(self), is_local ? MN_STOCK_LOCAL : MN_STOCK_REMOTE);
	      }
	    else
	      {
		mn_mailbox_set_format(MN_MAILBOX(self), NULL);
		if (! SELF_GET_CLASS(self)->stock_id)
		  mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_UNKNOWN);
		mn_mailbox_set_error(MN_MAILBOX(self), exists ? _("unknown mailbox format") : _("does not exist"));
	      }
	  }

	gdk_flush();
	GDK_THREADS_LEAVE();

	mn_reentrant_mailbox_lock(mailbox);

	if (backend)
	  {
	    g_object_unref(backend);
	    backend = NULL;
	  }

	if (! mn_reentrant_mailbox_check_aborted_unlocked(mailbox, check_id))
	  {
	    if (selfp->backend)
	      {
		g_object_unref(selfp->backend);
		selfp->backend = NULL;
	      }

	    if (new_backend)
	      {
		selfp->backend = backend = new_backend;
		new_backend = NULL;

		g_object_ref(backend);
	      }
	  }
	
	mn_reentrant_mailbox_unlock(mailbox);

	if (new_backend)
	  g_object_unref(new_backend);
      }
    
    if (backend)
      mn_vfs_mailbox_backend_check(backend, check_id);
    
  end:
    if (backend)
      {
	mn_reentrant_mailbox_lock(mailbox);
	g_object_unref(backend);
	mn_reentrant_mailbox_unlock(mailbox);
      }
  }}
#line 537 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 357 "mn-vfs-mailbox.gob"
void 
mn_vfs_mailbox_monitor_error_dialog (void)
#line 544 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::monitor_error_dialog"
{
#line 359 "mn-vfs-mailbox.gob"
	
    static gboolean first_time = TRUE;
    int minutes;
    int seconds;
    char *str;

    if (! first_time)
      return;

    if (eel_gconf_get_boolean(MN_CONF_IMMEDIATE_NOTIFICATION_ERROR_DIALOG_DO_NOT_SHOW))
      return;

    first_time = FALSE;

    minutes = eel_gconf_get_integer(MN_CONF_DELAY_MINUTES);
    seconds = eel_gconf_get_integer(MN_CONF_DELAY_SECONDS);
		    
    if (minutes == 0)
      str = g_strdup_printf(ngettext("As a fallback, they will be "
				     "checked every %i second (this "
				     "delay is configurable from the "
				     "Properties Dialog).",
				     "As a fallback, they will be "
				     "checked every %i seconds (this "
				     "delay is configurable from the "
				     "Properties Dialog).",
				     seconds),
			    seconds);
    else if (seconds == 0)
      str = g_strdup_printf(ngettext("As a fallback, they will be "
				     "checked every %i minute (this "
				     "delay is configurable from the "
				     "Properties Dialog).",
				     "As a fallback, they will be "
				     "checked every %i minutes (this "
				     "delay is configurable from the "
				     "Properties Dialog).",
				     minutes),
			    minutes);
    else
      str = g_strdup_printf(ngettext("As a fallback, they will be "
				     "checked approximately every %i "
				     "minute (this delay is "
				     "configurable from the "
				     "Properties Dialog).",
				     "As a fallback, they will be "
				     "checked approximately every %i "
				     "minutes (this delay is "
				     "configurable from the "
				     "Properties Dialog).",
				     minutes),
			    minutes);
		    
    mn_error_dialog(NULL,
		    MN_CONF_IMMEDIATE_NOTIFICATION_ERROR_DIALOG_DO_NOT_SHOW,
		    "immediate-notification",
		    _("A monitoring error has occurred"),
		    _("Mail Notification was unable to enable immediate "
		      "notification for one or more mailboxes. %s"), str);
    g_free(str);
  }}
#line 610 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
