/* Generated by GOB (v2.0.12) on Tue Aug  9 22:01:58 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 12

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-shell.h"

#include "mn-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 31 "mn-shell.gob"

#include "config.h"
#include <errno.h>
#include <gnome.h>
#include <eel/eel.h>
#include "mn-properties-dialog.h"
#include "mn-util.h"
#include "mn-conf.h"
#include "mn-mailboxes.h"
#include "mn-about-dialog.h"
#include "mn-main-window.h"
#include "mn-mail-summary-popup.h"
#include "mn-message-view.h"
#include "mn-message.h"

MNShell *mn_shell = NULL;

#line 45 "mn-shell.c"
/* self casting macros */
#define SELF(x) MN_SHELL(x)
#define SELF_CONST(x) MN_SHELL_CONST(x)
#define IS_SELF(x) MN_IS_SHELL(x)
#define TYPE_SELF MN_TYPE_SHELL
#define SELF_CLASS(x) MN_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) MN_SHELL_GET_CLASS(x)

/* self typedefs */
typedef MNShell Self;
typedef MNShellClass SelfClass;

/* here are local prototypes */
static void mn_shell_class_init (MNShellClass * c) G_GNUC_UNUSED;
static void mn_shell_init (MNShell * self) G_GNUC_UNUSED;
static void ___2_mn_shell_finalize (GObject * object) G_GNUC_UNUSED;
static void mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_init_icon (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_notify_blink_on_errors_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_summary_tooltip_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_mail_summary_popup_enable_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_update_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_remove_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_update_sensitivity (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_update_icon (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_update_tooltip (MNShell * self) G_GNUC_UNUSED;
static int mn_shell_new_mailboxes_compare_func (gconstpointer a, gconstpointer b) G_GNUC_UNUSED;
static time_t mn_shell_get_latest_sent_time (MNMailbox * mailbox) G_GNUC_UNUSED;
static GtkWidget * mn_shell_tooltip_section_new (GtkVBox * vbox, const char * title) G_GNUC_UNUSED;
static void mn_shell_tooltip_text_section_new (GtkVBox * vbox, const char * title, const char * text) G_GNUC_UNUSED;
static void mn_shell_update_popup (MNShell * self, gboolean has_new) G_GNUC_UNUSED;
static void mn_shell_popup_weak_notify_cb (MNShell * self, GObject * former_object) G_GNUC_UNUSED;
static void mn_shell_display_window (MNShell * self, GType type, GtkWidget ** ptr, GtkWindow * parent) G_GNUC_UNUSED;
static void mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_messages_changed_h mn_shell_messages_changed_h
#define self_mailbox_removed_h mn_shell_mailbox_removed_h
#define self_init_icon mn_shell_init_icon
#define self_notify_blink_on_errors_cb mn_shell_notify_blink_on_errors_cb
#define self_notify_mail_reader_cb mn_shell_notify_mail_reader_cb
#define self_notify_summary_tooltip_cb mn_shell_notify_summary_tooltip_cb
#define self_notify_mail_summary_popup_enable_cb mn_shell_notify_mail_summary_popup_enable_cb
#define self_icon_activate_h mn_shell_icon_activate_h
#define self_icon_activate_mail_reader_h mn_shell_icon_activate_mail_reader_h
#define self_icon_activate_update_h mn_shell_icon_activate_update_h
#define self_icon_activate_properties_h mn_shell_icon_activate_properties_h
#define self_icon_activate_help_h mn_shell_icon_activate_help_h
#define self_icon_activate_about_h mn_shell_icon_activate_about_h
#define self_icon_activate_remove_h mn_shell_icon_activate_remove_h
#define self_icon_destroy_h mn_shell_icon_destroy_h
#define self_update_sensitivity mn_shell_update_sensitivity
#define self_update_icon mn_shell_update_icon
#define self_update_tooltip mn_shell_update_tooltip
#define self_new_mailboxes_compare_func mn_shell_new_mailboxes_compare_func
#define self_get_latest_sent_time mn_shell_get_latest_sent_time
#define self_tooltip_section_new mn_shell_tooltip_section_new
#define self_tooltip_text_section_new mn_shell_tooltip_text_section_new
#define self_update_popup mn_shell_update_popup
#define self_popup_weak_notify_cb mn_shell_popup_weak_notify_cb
#define self_new mn_shell_new
#define self_display_main_window mn_shell_display_main_window
#define self_display_properties_dialog mn_shell_display_properties_dialog
#define self_display_about_dialog mn_shell_display_about_dialog
#define self_display_window mn_shell_display_window
#define self_close_mail_summary_popup mn_shell_close_mail_summary_popup
#define self_add_mailbox_properties_dialog mn_shell_add_mailbox_properties_dialog
#define self_mailbox_properties_dialog_weak_notify_cb mn_shell_mailbox_properties_dialog_weak_notify_cb
#define self_get_mailbox_properties_dialog mn_shell_get_mailbox_properties_dialog
GType
mn_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_shell_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNShell *)g_object_new(mn_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNShell *
GET_NEW_VARG (const char *first, ...)
{
	MNShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNShell *)g_object_new_valist (mn_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::dispose"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 51 "mn-shell.gob"
	if(self->mailboxes) { g_object_unref ((gpointer) self->mailboxes); self->mailboxes = NULL; }
#line 179 "mn-shell.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 93 "mn-shell.gob"
	___2_mn_shell_finalize(obj_self);
#line 192 "mn-shell.c"
#line 61 "mn-shell.gob"
	if(self->_priv->popup_messages) { mn_g_object_slist_free ((gpointer) self->_priv->popup_messages); self->_priv->popup_messages = NULL; }
#line 195 "mn-shell.c"
#line 62 "mn-shell.gob"
	if(self->_priv->popup_previous_messages) { mn_g_object_slist_free ((gpointer) self->_priv->popup_previous_messages); self->_priv->popup_previous_messages = NULL; }
#line 198 "mn-shell.c"
}
#undef __GOB_FUNCTION__

static void 
mn_shell_class_init (MNShellClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Shell::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNShellPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 93 "mn-shell.gob"
	g_object_class->finalize = ___finalize;
#line 214 "mn-shell.c"
	g_object_class->dispose = ___dispose;
}
#undef __GOB_FUNCTION__
#line 66 "mn-shell.gob"
static void 
mn_shell_init (MNShell * self G_GNUC_UNUSED)
#line 221 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_SHELL,MNShellPrivate);
#line 51 "mn-shell.gob"
	self->mailboxes = mn_mailboxes_new();
#line 227 "mn-shell.c"
 {
#line 67 "mn-shell.gob"

    g_assert(mn_shell == NULL);

    mn_shell = self;
    eel_add_weak_pointer(&mn_shell);

    self_init_icon(self);

    mn_conf_notifications_add(self,
			      MN_CONF_BLINK_ON_ERRORS, self_notify_blink_on_errors_cb, self,
			      MN_CONF_COMMANDS_MAIL_READER_NAMESPACE, self_notify_mail_reader_cb, self,
			      MN_CONF_SUMMARY_TOOLTIP, self_notify_summary_tooltip_cb, self,
			      MN_CONF_MAIL_SUMMARY_POPUP_ENABLE, self_notify_mail_summary_popup_enable_cb, self,
			      NULL);

    g_object_connect(self->mailboxes,
		     "signal::messages-changed", self_messages_changed_h, self,
		     "signal::mailbox-removed", self_mailbox_removed_h, self,
		     "swapped-signal::notify::must-poll", self_update_sensitivity, self,
		     "swapped-signal::list-changed", self_update_tooltip, self,
		     "swapped-signal::list-changed", self_update_icon, self,
		     "swapped-signal::error-changed", self_update_tooltip, self,
		     "swapped-signal::error-changed", self_update_icon, self,
		     NULL);
  
#line 255 "mn-shell.c"
 }
}
#undef __GOB_FUNCTION__



#line 93 "mn-shell.gob"
static void 
___2_mn_shell_finalize (GObject * object G_GNUC_UNUSED)
#line 265 "mn-shell.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
{
#line 95 "mn-shell.gob"
	
    gtk_main_quit();
    PARENT_HANDLER(object);
  }}
#line 277 "mn-shell.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 100 "mn-shell.gob"
static void 
mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data)
#line 284 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::messages_changed_h"
{
#line 104 "mn-shell.gob"
	
    Self *self = user_data;

    if (has_new)
      {
	gnome_triggers_do(_("You have new mail."), NULL, "mail-notification", "new-mail", NULL);
	if (mn_conf_has_command(MN_CONF_COMMANDS_NEW_MAIL_NAMESPACE))
	  mn_execute_command(MN_CONF_COMMANDS_NEW_MAIL_COMMAND);
      }

    if (eel_gconf_get_boolean(MN_CONF_MAIL_SUMMARY_POPUP_ENABLE))
      self_update_popup(self, has_new);
    
    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 305 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 121 "mn-shell.gob"
static void 
mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data)
#line 311 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailbox_removed_h"
{
#line 125 "mn-shell.gob"
	
    Self *self = user_data;
    MNMailboxPropertiesDialog *dialog;

    /* destroy the associated properties dialog, if any */
    dialog = self_get_mailbox_properties_dialog(self, mailbox);
    if (dialog)
      gtk_widget_destroy(GTK_WIDGET(dialog));
  }}
#line 325 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 135 "mn-shell.gob"
static void 
mn_shell_init_icon (MNShell * self)
#line 331 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::init_icon"
#line 135 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 135 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 338 "mn-shell.c"
{
#line 137 "mn-shell.gob"
	
    selfp->icon = MN_MAIL_ICON(mn_mail_icon_new());

    g_object_connect(selfp->icon,
		     "signal::activate", self_icon_activate_h, self,
		     "swapped-signal::activate-main-window", self_display_main_window, self,
		     "signal::activate-mail-reader", self_icon_activate_mail_reader_h, self,
		     "signal::activate-update", self_icon_activate_update_h, self,
		     "signal::activate-properties", self_icon_activate_properties_h, self,
		     "signal::activate-help", self_icon_activate_help_h, self,
		     "signal::activate-about", self_icon_activate_about_h, self,
		     "signal::activate-remove", self_icon_activate_remove_h, self,
		     "signal::destroy", self_icon_destroy_h, self,
		     NULL);
		     
    self_update_sensitivity(self);
    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 360 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 157 "mn-shell.gob"
static void 
mn_shell_notify_blink_on_errors_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 366 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_blink_on_errors_cb"
{
#line 162 "mn-shell.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    self_update_icon(self);
    GDK_THREADS_LEAVE();
  }}
#line 378 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 170 "mn-shell.gob"
static void 
mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 384 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_mail_reader_cb"
{
#line 175 "mn-shell.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    self_update_sensitivity(self);
    GDK_THREADS_LEAVE();
  }}
#line 396 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 183 "mn-shell.gob"
static void 
mn_shell_notify_summary_tooltip_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 402 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_summary_tooltip_cb"
{
#line 188 "mn-shell.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    self_update_tooltip(self);
    GDK_THREADS_LEAVE();
  }}
#line 414 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 196 "mn-shell.gob"
static void 
mn_shell_notify_mail_summary_popup_enable_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 420 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_mail_summary_popup_enable_cb"
{
#line 201 "mn-shell.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();

    if (selfp->popup && ! eel_gconf_get_boolean(MN_CONF_MAIL_SUMMARY_POPUP_ENABLE))
      gtk_widget_destroy(selfp->popup);
      
    GDK_THREADS_LEAVE();
  }}
#line 435 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 212 "mn-shell.gob"
static void 
mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data)
#line 441 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_h"
{
#line 214 "mn-shell.gob"
	
    MNShell *self = user_data;
    MNAction action;

    action = mn_conf_get_enum_value(MN_TYPE_ACTION, MN_CONF_DOUBLE_CLICK_ACTION_2);

    switch (action)
      {
      case MN_ACTION_DISPLAY_MAIN_WINDOW:
	self_display_main_window(self);
	break;

      case MN_ACTION_LAUNCH_MAIL_READER:
	if (mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READER_NAMESPACE))
	  mn_execute_command(MN_CONF_COMMANDS_MAIL_READER_COMMAND);
	break;

      case MN_ACTION_UPDATE_MAIL_STATUS:
	mn_mailboxes_check(self->mailboxes);
	break;

      default:
	g_return_if_reached();
      }
  }}
#line 471 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 240 "mn-shell.gob"
static void 
mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data)
#line 477 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_mail_reader_h"
{
#line 242 "mn-shell.gob"
	
    mn_execute_command(MN_CONF_COMMANDS_MAIL_READER_COMMAND);
  }}
#line 485 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 246 "mn-shell.gob"
static void 
mn_shell_icon_activate_update_h (MNMailIcon * icon, gpointer user_data)
#line 491 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_update_h"
{
#line 248 "mn-shell.gob"
	
    Self *self = user_data;
    mn_mailboxes_check(self->mailboxes);
  }}
#line 500 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 253 "mn-shell.gob"
static void 
mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data)
#line 506 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_properties_h"
{
#line 255 "mn-shell.gob"
	
    Self *self = user_data;
    self_display_properties_dialog(self, NULL);
  }}
#line 515 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 260 "mn-shell.gob"
static void 
mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data)
#line 521 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_help_h"
{
#line 262 "mn-shell.gob"
	
    mn_display_help(NULL, NULL);
  }}
#line 529 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 266 "mn-shell.gob"
static void 
mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data)
#line 535 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_about_h"
{
#line 268 "mn-shell.gob"
	
    Self *self = user_data;
    self_display_about_dialog(self, NULL);
  }}
#line 544 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 273 "mn-shell.gob"
static void 
mn_shell_icon_activate_remove_h (MNMailIcon * icon, gpointer user_data)
#line 550 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_remove_h"
{
#line 275 "mn-shell.gob"
	
    Self *self = user_data;
    g_object_unref(self);
  }}
#line 559 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 280 "mn-shell.gob"
static void 
mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data)
#line 565 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_destroy_h"
{
#line 282 "mn-shell.gob"
	
    Self *self = user_data;

    /* The Notification Area applet has been terminated. Recreate the icon. */
    self_init_icon(self);
  }}
#line 576 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 289 "mn-shell.gob"
static void 
mn_shell_update_sensitivity (MNShell * self)
#line 582 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_sensitivity"
#line 289 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 289 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 589 "mn-shell.c"
{
#line 291 "mn-shell.gob"
	
    gtk_widget_set_sensitive(selfp->icon->mail_reader_item, mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READER_NAMESPACE));
    gtk_widget_set_sensitive(selfp->icon->update_item, mn_mailboxes_get_must_poll(self->mailboxes));
  }}
#line 596 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 296 "mn-shell.gob"
static void 
mn_shell_update_icon (MNShell * self)
#line 602 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_icon"
#line 296 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 296 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 609 "mn-shell.c"
{
#line 298 "mn-shell.gob"
	
    GList *l;
    gboolean has_new = FALSE;
    gboolean blink = FALSE;

    MN_LIST_FOREACH(l, self->mailboxes->list)
      {
	MNMailbox *mailbox = l->data;

	if (mailbox->messages)
	  has_new = TRUE;
	if (mailbox->error)
	  blink = TRUE;
      }

    if (selfp->has_new && ! has_new && mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READ_NAMESPACE))
      mn_execute_command(MN_CONF_COMMANDS_MAIL_READ_COMMAND);
    selfp->has_new = has_new;
    
    if (blink && ! eel_gconf_get_boolean(MN_CONF_BLINK_ON_ERRORS))
      blink = FALSE;

    if (has_new || blink)
      {
	mn_blinking_image_set_blinking(MN_BLINKING_IMAGE(selfp->icon->image), blink);
	gtk_widget_show(GTK_WIDGET(selfp->icon));
      }
    else
      gtk_widget_hide(GTK_WIDGET(selfp->icon));
  }}
#line 642 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 329 "mn-shell.gob"
static void 
mn_shell_update_tooltip (MNShell * self)
#line 648 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_tooltip"
#line 329 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 329 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 655 "mn-shell.c"
{
#line 331 "mn-shell.gob"
	
    GtkWidget *vbox;

    vbox = gtk_vbox_new(FALSE, 18);

    if (self->mailboxes->list)
      {
	GList *l;
	GSList *sl;
	GSList *new_mailboxes = NULL;
	GSList *error_mailboxes = NULL;

	MN_LIST_FOREACH(l, self->mailboxes->list)
          {
	    MNMailbox *mailbox = l->data;
	    
	    if (mailbox->messages)
	      new_mailboxes = g_slist_append(new_mailboxes, mailbox);

	    if (mailbox->error)
	      error_mailboxes = g_slist_append(error_mailboxes, mailbox);
	  }

	if (new_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    new_mailboxes = g_slist_sort(new_mailboxes, self_new_mailboxes_compare_func);
	    MN_LIST_FOREACH(sl, new_mailboxes)
	      {
		MNMailbox *mailbox = sl->data;
		int n_messages;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append(string, mailbox->runtime_name);
		
		n_messages = g_slist_length(mailbox->messages);
		if (n_messages > 0)
		  g_string_append_printf(string, " (%i)", n_messages);
	      }
	    g_slist_free(new_mailboxes);
	    
	    self_tooltip_text_section_new(GTK_VBOX(vbox), _("Mailboxes Having New Mail"), string->str);
	    g_string_free(string, TRUE);
	  }

	if (error_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    error_mailboxes = g_slist_sort(error_mailboxes, mn_mailboxes_compare_by_name_func);
	    MN_LIST_FOREACH(sl, error_mailboxes)
	      {
		MNMailbox *mailbox = sl->data;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append_printf(string, "%s: %s", mailbox->runtime_name, mailbox->error);
	      }
	    g_slist_free(error_mailboxes);

	    self_tooltip_text_section_new(GTK_VBOX(vbox), _("Errors"), string->str);
	    g_string_free(string, TRUE);
	  }
      }

    if (eel_gconf_get_boolean(MN_CONF_SUMMARY_TOOLTIP))
      {
	GSList *messages;
	
	messages = mn_mailboxes_get_messages(mn_shell->mailboxes);
	if (messages)
	  {
	    GtkWidget *alignment;
	    GtkWidget *message_view;
	
	    alignment = self_tooltip_section_new(GTK_VBOX(vbox), _("Mail Summary"));
	    
	    message_view = mn_message_view_new(TRUE, FALSE);
	    gtk_widget_set_name(message_view, "mn-message-view");
	    
	    mn_message_view_set_messages(MN_MESSAGE_VIEW(message_view), messages);
	    mn_g_object_slist_free(messages);
	    
	    gtk_container_add(GTK_CONTAINER(alignment), message_view);
	  }
      }

    gtk_widget_show_all(vbox);
    mn_mail_icon_set_tip_widget(selfp->icon, vbox);
  }}
#line 750 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 424 "mn-shell.gob"
static int 
mn_shell_new_mailboxes_compare_func (gconstpointer a, gconstpointer b)
#line 756 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::new_mailboxes_compare_func"
{
#line 426 "mn-shell.gob"
	
    MNMailbox *mailbox_a = (MNMailbox *) a;
    MNMailbox *mailbox_b = (MNMailbox *) b;
    int cmp;

    /* sort by sent time (descending order) */
    cmp = self_get_latest_sent_time(mailbox_b) - self_get_latest_sent_time(mailbox_a);
    /* else sort by number of messages (descending order) */
    if (cmp == 0)
      cmp = g_slist_length(mailbox_b->messages) - g_slist_length(mailbox_a->messages);
    /* else sort by name (ascending order) */
    if (cmp == 0)
      cmp = mn_mailboxes_compare_by_name_func(a, b);

    return cmp;
  }}
#line 777 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 443 "mn-shell.gob"
static time_t 
mn_shell_get_latest_sent_time (MNMailbox * mailbox)
#line 783 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::get_latest_sent_time"
#line 443 "mn-shell.gob"
	g_return_val_if_fail (mailbox != NULL, (time_t )0);
#line 443 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (time_t )0);
#line 790 "mn-shell.c"
{
#line 445 "mn-shell.gob"
	
    GSList *l;
    time_t latest = 0;

    MN_LIST_FOREACH(l, mailbox->messages)
      {
	MNMessage *message = l->data;

	if (message->sent_time > latest)
	  latest = message->sent_time;
      }

    return latest;
  }}
#line 807 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 460 "mn-shell.gob"
static GtkWidget * 
mn_shell_tooltip_section_new (GtkVBox * vbox, const char * title)
#line 813 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::tooltip_section_new"
#line 460 "mn-shell.gob"
	g_return_val_if_fail (vbox != NULL, (GtkWidget * )0);
#line 460 "mn-shell.gob"
	g_return_val_if_fail (GTK_IS_VBOX (vbox), (GtkWidget * )0);
#line 460 "mn-shell.gob"
	g_return_val_if_fail (title != NULL, (GtkWidget * )0);
#line 822 "mn-shell.c"
{
#line 463 "mn-shell.gob"
	
    GtkWidget *child_vbox;
    char *markup;
    GtkWidget *alignment;
    GtkWidget *label;

    child_vbox = gtk_vbox_new(FALSE, 6);

    markup = g_markup_printf_escaped("<span weight=\"bold\">%s</span>", title);
    label = gtk_label_new(markup);
    g_free(markup);

    gtk_widget_set_name(label, "mn-tooltip-section-title");
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    gtk_label_set_use_markup(GTK_LABEL(label), TRUE);

    gtk_box_pack_start(GTK_BOX(child_vbox), label, FALSE, FALSE, 0);

    alignment = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
    gtk_alignment_set_padding(GTK_ALIGNMENT(alignment), 0, 0, 12, 0);

    gtk_box_pack_start(GTK_BOX(child_vbox), alignment, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), child_vbox, TRUE, TRUE, 0);

    return alignment;
  }}
#line 851 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 490 "mn-shell.gob"
static void 
mn_shell_tooltip_text_section_new (GtkVBox * vbox, const char * title, const char * text)
#line 857 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::tooltip_text_section_new"
#line 490 "mn-shell.gob"
	g_return_if_fail (vbox != NULL);
#line 490 "mn-shell.gob"
	g_return_if_fail (GTK_IS_VBOX (vbox));
#line 490 "mn-shell.gob"
	g_return_if_fail (title != NULL);
#line 490 "mn-shell.gob"
	g_return_if_fail (text != NULL);
#line 868 "mn-shell.c"
{
#line 494 "mn-shell.gob"
	
    GtkWidget *alignment;
    GtkWidget *label;

    alignment = self_tooltip_section_new(GTK_VBOX(vbox), title);

    label = gtk_label_new(text);
    gtk_widget_set_name(label, "mn-tooltip-section-body");
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

    gtk_container_add(GTK_CONTAINER(alignment), label);
  }}
#line 883 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 507 "mn-shell.gob"
static void 
mn_shell_update_popup (MNShell * self, gboolean has_new)
#line 889 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_popup"
#line 507 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 507 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 896 "mn-shell.c"
{
#line 509 "mn-shell.gob"
	
    if (! selfp->main_window
	&& (! selfp->properties_dialog || ! mn_properties_dialog_test_popup_displayed(MN_PROPERTIES_DIALOG(selfp->properties_dialog)))
	&& (selfp->popup || has_new))
      {
	GSList *l;

	mn_g_object_slist_free(selfp->popup_messages);
	selfp->popup_messages = mn_mailboxes_get_messages(self->mailboxes);

      loop1:
	MN_LIST_FOREACH(l, selfp->popup_previous_messages)
	  {
	    MNMessage *message = l->data;
	    
	    if (! mn_message_slist_find_by_id(selfp->popup_messages, message))
	      {
		selfp->popup_previous_messages = mn_g_object_slist_delete_link(selfp->popup_previous_messages, l);
		goto loop1;
	      }
	  }

	if (eel_gconf_get_boolean(MN_CONF_MAIL_SUMMARY_POPUP_ONLY_RECENT))
	  {
	  loop2:
	    MN_LIST_FOREACH(l, selfp->popup_messages)
	      {
		MNMessage *message = l->data;
		
		if (mn_message_slist_find_by_id(selfp->popup_previous_messages, message))
		  {
		    selfp->popup_messages = mn_g_object_slist_delete_link(selfp->popup_messages, l);
		    goto loop2;
		  }
	      }
	  }

	if (selfp->popup_messages)
	  {
	    if (! selfp->popup)
	      {
		selfp->popup = mn_mail_summary_popup_new();

		eel_add_weak_pointer(&selfp->popup);
		g_object_weak_ref(G_OBJECT(selfp->popup), (GWeakNotify) self_popup_weak_notify_cb, self);
	      }

	    mn_mail_summary_popup_set_messages(MN_MAIL_SUMMARY_POPUP(selfp->popup), selfp->popup_messages);
	    gtk_widget_show(selfp->popup);

	    /* we only reset the timeout if there is new mail */

	    if (has_new)
	      mn_mail_summary_popup_reset_timeout(MN_MAIL_SUMMARY_POPUP(selfp->popup));

	    return;		/* something has been shown */
	  }
      }

    /* nothing has been shown, destroy the popup if it exists */
    if (selfp->popup)
      gtk_widget_destroy(selfp->popup);
  }}
#line 962 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 573 "mn-shell.gob"
static void 
mn_shell_popup_weak_notify_cb (MNShell * self, GObject * former_object)
#line 968 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::popup_weak_notify_cb"
#line 573 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 573 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 975 "mn-shell.c"
{
#line 575 "mn-shell.gob"
	
    selfp->popup_previous_messages = g_slist_concat(selfp->popup_previous_messages, selfp->popup_messages);
    selfp->popup_messages = NULL;
  }}
#line 982 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 580 "mn-shell.gob"
MNShell * 
mn_shell_new (void)
#line 988 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::new"
{
#line 582 "mn-shell.gob"
	
    return GET_NEW;
  }}
#line 996 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 586 "mn-shell.gob"
void 
mn_shell_display_main_window (MNShell * self)
#line 1002 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_main_window"
#line 586 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 586 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1009 "mn-shell.c"
{
#line 588 "mn-shell.gob"
	
    self_display_window(self, MN_TYPE_MAIN_WINDOW, &selfp->main_window, NULL);

    /* we don't need the mail summary popup anymore */
    self_close_mail_summary_popup(self);
  }}
#line 1018 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 595 "mn-shell.gob"
void 
mn_shell_display_properties_dialog (MNShell * self, GtkWindow * parent)
#line 1024 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_properties_dialog"
#line 595 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 595 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1031 "mn-shell.c"
{
#line 597 "mn-shell.gob"
	
    self_display_window(self, MN_TYPE_PROPERTIES_DIALOG, &selfp->properties_dialog, parent);
  }}
#line 1037 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 601 "mn-shell.gob"
void 
mn_shell_display_about_dialog (MNShell * self, GtkWindow * parent)
#line 1043 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_about_dialog"
#line 601 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 601 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1050 "mn-shell.c"
{
#line 603 "mn-shell.gob"
	
    self_display_window(self, MN_TYPE_ABOUT_DIALOG, &selfp->about_dialog, parent);
  }}
#line 1056 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 607 "mn-shell.gob"
static void 
mn_shell_display_window (MNShell * self, GType type, GtkWidget ** ptr, GtkWindow * parent)
#line 1062 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_window"
#line 607 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 607 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 607 "mn-shell.gob"
	g_return_if_fail (type != 0);
#line 607 "mn-shell.gob"
	g_return_if_fail (ptr != NULL);
#line 1073 "mn-shell.c"
{
#line 612 "mn-shell.gob"
	
    if (*ptr)
      {
	gtk_window_present(GTK_WINDOW(*ptr));
	return;
      }

    *ptr = g_object_new(type, NULL);
    eel_add_weak_pointer(ptr);

    if (parent)
      gtk_window_set_transient_for(GTK_WINDOW(*ptr), parent);

    gtk_widget_show(*ptr);
  }}
#line 1091 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 628 "mn-shell.gob"
void 
mn_shell_close_mail_summary_popup (MNShell * self)
#line 1097 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::close_mail_summary_popup"
#line 628 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 628 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1104 "mn-shell.c"
{
#line 630 "mn-shell.gob"
	
    if (selfp->popup)
      gtk_widget_destroy(selfp->popup);
  }}
#line 1111 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 635 "mn-shell.gob"
void 
mn_shell_add_mailbox_properties_dialog (MNShell * self, MNMailboxPropertiesDialog * dialog)
#line 1117 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::add_mailbox_properties_dialog"
#line 635 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 635 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 635 "mn-shell.gob"
	g_return_if_fail (dialog != NULL);
#line 635 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (dialog));
#line 1128 "mn-shell.c"
{
#line 637 "mn-shell.gob"
	
    selfp->mailbox_properties_dialogs = g_slist_append(selfp->mailbox_properties_dialogs, dialog);
    g_object_weak_ref(G_OBJECT(dialog), self_mailbox_properties_dialog_weak_notify_cb, self);
  }}
#line 1135 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 642 "mn-shell.gob"
static void 
mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object)
#line 1141 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailbox_properties_dialog_weak_notify_cb"
{
#line 645 "mn-shell.gob"
	
    Self *self = data;

    selfp->mailbox_properties_dialogs = g_slist_remove(selfp->mailbox_properties_dialogs, former_object);
  }}
#line 1151 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 651 "mn-shell.gob"
MNMailboxPropertiesDialog * 
mn_shell_get_mailbox_properties_dialog (MNShell * self, MNMailbox * mailbox)
#line 1157 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::get_mailbox_properties_dialog"
#line 651 "mn-shell.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxPropertiesDialog * )0);
#line 651 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_SHELL (self), (MNMailboxPropertiesDialog * )0);
#line 651 "mn-shell.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMailboxPropertiesDialog * )0);
#line 651 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMailboxPropertiesDialog * )0);
#line 1168 "mn-shell.c"
{
#line 653 "mn-shell.gob"
	
    GSList *l;

    MN_LIST_FOREACH(l, selfp->mailbox_properties_dialogs)
      {
	MNMailboxPropertiesDialog *dialog = l->data;
	MNMailbox *this_mailbox;
	gboolean found;

	this_mailbox = mn_mailbox_properties_dialog_get_mailbox(dialog);
	found = this_mailbox == mailbox;
	g_object_unref(this_mailbox);

	if (found)
	  return dialog;
      }

    return NULL;
  }}
#line 1190 "mn-shell.c"
#undef __GOB_FUNCTION__
static const GEnumValue _mn_position_values[] = {
	{ MN_POSITION_TOP_LEFT, (char *)"MN_POSITION_TOP_LEFT", (char *)"top-left" },
	{ MN_POSITION_TOP_RIGHT, (char *)"MN_POSITION_TOP_RIGHT", (char *)"top-right" },
	{ MN_POSITION_BOTTOM_LEFT, (char *)"MN_POSITION_BOTTOM_LEFT", (char *)"bottom-left" },
	{ MN_POSITION_BOTTOM_RIGHT, (char *)"MN_POSITION_BOTTOM_RIGHT", (char *)"bottom-right" },
	{ 0, NULL, NULL }
};

GType
mn_position_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNPosition", _mn_position_values);
	return type;
}

static const GEnumValue _mn_action_values[] = {
	{ MN_ACTION_DISPLAY_MAIN_WINDOW, (char *)"MN_ACTION_DISPLAY_MAIN_WINDOW", (char *)"display-main-window" },
	{ MN_ACTION_LAUNCH_MAIL_READER, (char *)"MN_ACTION_LAUNCH_MAIL_READER", (char *)"launch-mail-reader" },
	{ MN_ACTION_UPDATE_MAIL_STATUS, (char *)"MN_ACTION_UPDATE_MAIL_STATUS", (char *)"update-mail-status" },
	{ 0, NULL, NULL }
};

GType
mn_action_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNAction", _mn_action_values);
	return type;
}

static const GEnumValue _mn_toolbar_style_values[] = {
	{ MN_TOOLBAR_STYLE_ICONS, (char *)"MN_TOOLBAR_STYLE_ICONS", (char *)"icons" },
	{ MN_TOOLBAR_STYLE_TEXT, (char *)"MN_TOOLBAR_STYLE_TEXT", (char *)"text" },
	{ MN_TOOLBAR_STYLE_BOTH, (char *)"MN_TOOLBAR_STYLE_BOTH", (char *)"both" },
	{ MN_TOOLBAR_STYLE_BOTH_HORIZ, (char *)"MN_TOOLBAR_STYLE_BOTH_HORIZ", (char *)"both-horiz" },
	{ MN_TOOLBAR_STYLE_DESKTOP_DEFAULT, (char *)"MN_TOOLBAR_STYLE_DESKTOP_DEFAULT", (char *)"desktop-default" },
	{ 0, NULL, NULL }
};

GType
mn_toolbar_style_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNToolbarStyle", _mn_toolbar_style_values);
	return type;
}

static const GEnumValue _mn_aspect_source_values[] = {
	{ MN_ASPECT_SOURCE_THEME, (char *)"MN_ASPECT_SOURCE_THEME", (char *)"theme" },
	{ MN_ASPECT_SOURCE_CUSTOM, (char *)"MN_ASPECT_SOURCE_CUSTOM", (char *)"custom" },
	{ 0, NULL, NULL }
};

GType
mn_aspect_source_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNAspectSource", _mn_aspect_source_values);
	return type;
}

