/* Generated by GOB (v2.0.12) on Tue Aug  9 22:01:57 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 12

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailbox.h"

#include "mn-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 48 "mn-mailbox.gob"

#include "config.h"
#include <glib/gi18n.h>
#include <eel/eel.h>
#include <libgnomevfs/gnome-vfs.h>
#if defined(WITH_MBOX) || defined(WITH_MH) || defined(WITH_MAILDIR) || defined(WITH_SYLPHEED)
#include "mn-system-vfs-mailbox.h"
#include "mn-custom-vfs-mailbox.h"
#endif
#ifdef WITH_POP3
#include "mn-pop3-mailbox.h"
#endif
#ifdef WITH_IMAP
#include "mn-imap-mailbox.h"
#endif
#ifdef WITH_GMAIL
#include "mn-gmail-mailbox.h"
#endif
#ifdef WITH_EVOLUTION
#include "mn-evolution-mailbox.h"
#endif
#include "mn-util.h"
#include "mn-message.h"

struct _MNMailboxConfiguration
{
  GType		type;
  unsigned int	n_parameters;
  GParameter	*parameters;
};

GType mn_mailbox_types[MN_MAILBOX_MAX_TYPES + 1];

#line 61 "mn-mailbox.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX(x)
#define SELF_CONST(x) MN_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX(x)
#define TYPE_SELF MN_TYPE_MAILBOX
#define SELF_CLASS(x) MN_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNMailbox Self;
typedef MNMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_mailbox_init (MNMailbox * o) G_GNUC_UNUSED;
static void mn_mailbox_class_init (MNMailboxClass * c) G_GNUC_UNUSED;
static void mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new) G_GNUC_UNUSED;
static GType mn_mailbox_get_type_from_name (const char * type) G_GNUC_UNUSED;
static MNMailbox * mn_mailbox_parse_obsolete_uri (const char * uri) G_GNUC_UNUSED;
static gboolean mn_mailbox_validate (MNMailbox * self, GError ** err) G_GNUC_UNUSED;
static void ___real_mn_mailbox_seal (MNMailbox * self);
static MNMailbox * mn_mailbox_parse_uri (MNMailbox * self, const char * uri) G_GNUC_UNUSED;
static gboolean mn_mailbox_import_string (GValue * value, const char * str) G_GNUC_UNUSED;
static char * mn_mailbox_export_string (const GValue * value) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__removed(object,func,data)	mn_mailbox_connect__removed((object),(func),(data))
#define self_connect_after__removed(object,func,data)	mn_mailbox_connect_after__removed((object),(func),(data))
#define self_connect_data__removed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__removed((object),(func),(data),(destroy_data),(flags))
#define self_connect__messages_changed(object,func,data)	mn_mailbox_connect__messages_changed((object),(func),(data))
#define self_connect_after__messages_changed(object,func,data)	mn_mailbox_connect_after__messages_changed((object),(func),(data))
#define self_connect_data__messages_changed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__messages_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (MNMailbox *, gboolean , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailbox *)data1,
		(gboolean ) g_value_get_boolean (param_values + 1),
		data2);
}


enum {
	REMOVED_SIGNAL,
	MESSAGES_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_NAME,
	PROP_STOCK_ID,
	PROP_FORMAT,
	PROP_MUST_POLL,
	PROP_MESSAGES,
	PROP_ERROR
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_removed mn_mailbox_removed
#define self_get_stock_id mn_mailbox_get_stock_id
#define self_set_stock_id mn_mailbox_set_stock_id
#define self_get_format mn_mailbox_get_format
#define self_set_format mn_mailbox_set_format
#define self_get_must_poll mn_mailbox_get_must_poll
#define self_set_must_poll mn_mailbox_set_must_poll
#define self_get_messages mn_mailbox_get_messages
#define self_set_messages mn_mailbox_set_messages
#define self_messages_changed mn_mailbox_messages_changed
#define self_set_error mn_mailbox_set_error
#define self_init_types mn_mailbox_init_types
#define self_get_type_from_name mn_mailbox_get_type_from_name
#define self_new mn_mailbox_new
#define self_new_from_xml_node mn_mailbox_new_from_xml_node
#define self_xml_node_new mn_mailbox_xml_node_new
#define self_new_from_uri mn_mailbox_new_from_uri
#define self_new_from_configuration mn_mailbox_new_from_configuration
#define self_get_configuration mn_mailbox_get_configuration
#define self_configuration_free mn_mailbox_configuration_free
#define self_new_from_obsolete_uri mn_mailbox_new_from_obsolete_uri
#define self_parse_obsolete_uri mn_mailbox_parse_obsolete_uri
#define self_validate mn_mailbox_validate
#define self_seal mn_mailbox_seal
#define self_parse_uri mn_mailbox_parse_uri
#define self_check mn_mailbox_check
#define self_notice mn_mailbox_notice
#define self_warning mn_mailbox_warning
#define self_import_string mn_mailbox_import_string
#define self_export_string mn_mailbox_export_string
GType
mn_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailbox *)g_object_new(mn_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailbox *)g_object_new_valist (mn_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
	MNMailbox *self G_GNUC_UNUSED = MN_MAILBOX (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 96 "mn-mailbox.gob"
	if(self->runtime_name) { g_free ((gpointer) self->runtime_name); self->runtime_name = NULL; }
#line 235 "mn-mailbox.c"
#line 98 "mn-mailbox.gob"
	if(self->name) { g_free ((gpointer) self->name); self->name = NULL; }
#line 238 "mn-mailbox.c"
#line 110 "mn-mailbox.gob"
	if(self->messages) { mn_g_object_slist_free ((gpointer) self->messages); self->messages = NULL; }
#line 241 "mn-mailbox.c"
#line 163 "mn-mailbox.gob"
	if(self->error) { g_free ((gpointer) self->error); self->error = NULL; }
#line 244 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_mailbox_init (MNMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::init"
}
#undef __GOB_FUNCTION__
static void 
mn_mailbox_class_init (MNMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[REMOVED_SIGNAL] =
		g_signal_new ("removed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxClass, removed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[MESSAGES_CHANGED_SIGNAL] =
		g_signal_new ("messages_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxClass, messages_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_BOOLEAN);
	if ___GOB_UNLIKELY(sizeof(gboolean ) != sizeof(gboolean ) || parent_class == NULL /* avoid warning */) {
		g_error("mn-mailbox.gob line 160: Type mismatch of \"messages_changed\" signal signature");
	}

	c->removed = NULL;
	c->messages_changed = NULL;
#line 753 "mn-mailbox.gob"
	c->seal = ___real_mn_mailbox_seal;
#line 287 "mn-mailbox.c"
	c->parse_uri = NULL;
	c->check = NULL;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("name" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_string
		("stock_id" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_STOCK_ID,
		param_spec);
	param_spec = g_param_spec_string
		("format" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_FORMAT,
		param_spec);
	param_spec = g_param_spec_boolean
		("must_poll" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_MUST_POLL,
		param_spec);
	param_spec = g_param_spec_pointer
		("messages" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGES,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::set_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 99 "mn-mailbox.gob"
{ char *old = self->name; self->name = g_value_dup_string (VAL); g_free (old); }
#line 369 "mn-mailbox.c"
		}
		break;
	case PROP_STOCK_ID:
		{
#line 102 "mn-mailbox.gob"
{ char *old = self->stock_id; self->stock_id = g_value_dup_string (VAL); g_free (old); }
#line 376 "mn-mailbox.c"
		}
		break;
	case PROP_FORMAT:
		{
#line 105 "mn-mailbox.gob"
{ char *old = self->format; self->format = g_value_dup_string (VAL); g_free (old); }
#line 383 "mn-mailbox.c"
		}
		break;
	case PROP_MUST_POLL:
		{
#line 108 "mn-mailbox.gob"
self->must_poll = g_value_get_boolean (VAL);
#line 390 "mn-mailbox.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 113 "mn-mailbox.gob"

      GSList *messages;
      GSList *l;
      gboolean changed = FALSE;
      gboolean has_new = FALSE;

      messages = g_value_get_pointer(VAL);
      
      MN_LIST_FOREACH(l, self->messages)
	if (! mn_message_slist_find_by_id(messages, l->data))
	  {
	    changed = TRUE;
	    break;
	  }
      
      MN_LIST_FOREACH(l, messages)
	if (! mn_message_slist_find_by_id(self->messages, l->data))
	  {
	    changed = TRUE;
	    has_new = TRUE;
	    break;
	  }

      mn_g_object_slist_free(self->messages);
      self->messages = mn_g_object_slist_copy(messages);

      if (changed)
	self_messages_changed(self, has_new);
    
#line 425 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 166 "mn-mailbox.gob"

      g_free(self->error);
      self->error = g_value_dup_string(VAL);

      /* if an error is set, we unset messages */
      if (self->error)
	self_set_messages(self, NULL);
    
#line 439 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::get_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 99 "mn-mailbox.gob"
g_value_set_string (VAL, self->name);
#line 470 "mn-mailbox.c"
		}
		break;
	case PROP_STOCK_ID:
		{
#line 102 "mn-mailbox.gob"
g_value_set_string (VAL, self->stock_id);
#line 477 "mn-mailbox.c"
		}
		break;
	case PROP_FORMAT:
		{
#line 105 "mn-mailbox.gob"
g_value_set_string (VAL, self->format);
#line 484 "mn-mailbox.c"
		}
		break;
	case PROP_MUST_POLL:
		{
#line 108 "mn-mailbox.gob"
g_value_set_boolean (VAL, self->must_poll);
#line 491 "mn-mailbox.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 143 "mn-mailbox.gob"

      g_value_set_pointer(VAL, self->messages);
    
#line 500 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 175 "mn-mailbox.gob"

      g_value_set_string(VAL, self->error);
    
#line 509 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



/**
 * mn_mailbox_removed:
 * @self: the object which received the signal
 *
 * This signal gets emitted after the mailbox is removed from the
 * mailboxes list.
 **/
#line 93 "mn-mailbox.gob"
void 
mn_mailbox_removed (MNMailbox * self)
#line 536 "mn-mailbox.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 93 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 93 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 548 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[REMOVED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

#line 102 "mn-mailbox.gob"
gchar * 
mn_mailbox_get_stock_id (MNMailbox * self)
#line 565 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_stock_id"
{
#line 102 "mn-mailbox.gob"
		gchar* val; g_object_get (G_OBJECT (self), "stock_id", &val, NULL); return val;
}}
#line 572 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 102 "mn-mailbox.gob"
void 
mn_mailbox_set_stock_id (MNMailbox * self, gchar * val)
#line 578 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_stock_id"
{
#line 102 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "stock_id", val, NULL);
}}
#line 585 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 105 "mn-mailbox.gob"
gchar * 
mn_mailbox_get_format (MNMailbox * self)
#line 591 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_format"
{
#line 105 "mn-mailbox.gob"
		gchar* val; g_object_get (G_OBJECT (self), "format", &val, NULL); return val;
}}
#line 598 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 105 "mn-mailbox.gob"
void 
mn_mailbox_set_format (MNMailbox * self, gchar * val)
#line 604 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_format"
{
#line 105 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "format", val, NULL);
}}
#line 611 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 108 "mn-mailbox.gob"
gboolean 
mn_mailbox_get_must_poll (MNMailbox * self)
#line 617 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_must_poll"
{
#line 108 "mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "must_poll", &val, NULL); return val;
}}
#line 624 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 108 "mn-mailbox.gob"
void 
mn_mailbox_set_must_poll (MNMailbox * self, gboolean val)
#line 630 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_must_poll"
{
#line 108 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "must_poll", val, NULL);
}}
#line 637 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 143 "mn-mailbox.gob"
const GSList * 
mn_mailbox_get_messages (MNMailbox * self)
#line 643 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_messages"
{
#line 111 "mn-mailbox.gob"
		const GSList* val; g_object_get (G_OBJECT (self), "messages", &val, NULL); return val;
}}
#line 650 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 113 "mn-mailbox.gob"
void 
mn_mailbox_set_messages (MNMailbox * self, const GSList * val)
#line 656 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_messages"
{
#line 111 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "messages", val, NULL);
}}
#line 663 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 160 "mn-mailbox.gob"
static void 
mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new)
#line 669 "mn-mailbox.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 160 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 160 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 681 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_BOOLEAN);
	g_value_set_boolean (&___param_values[1], (gboolean ) has_new);

	g_signal_emitv (___param_values,
		object_signals[MESSAGES_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 179 "mn-mailbox.gob"
void 
mn_mailbox_set_error (MNMailbox * self, const char * format, ...)
#line 703 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_error"
#line 179 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 179 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 710 "mn-mailbox.c"
{
#line 181 "mn-mailbox.gob"
	
    va_list args;
    char *error = NULL;

    if (format)
      {
	va_start(args, format);
	error = g_strdup_vprintf(format, args);
	va_end(args);
      }
    
    g_object_set(G_OBJECT(self), MN_MAILBOX_PROP_ERROR(error), NULL);
    g_free(error);
  }}
#line 727 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 196 "mn-mailbox.gob"
void 
mn_mailbox_init_types (void)
#line 733 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::init_types"
{
#line 198 "mn-mailbox.gob"
	
    int i = 0;

#if defined(WITH_MBOX) || defined(WITH_MH) || defined(WITH_MAILDIR) || defined(WITH_SYLPHEED)
    /*
     * MNSystemVFSMailbox must be registered before
     * MNCustomVFSMailbox, because the latter's parse_uri() method
     * will accept any URI.
     */
    mn_mailbox_types[i++] = MN_TYPE_SYSTEM_VFS_MAILBOX;
    mn_mailbox_types[i++] = MN_TYPE_CUSTOM_VFS_MAILBOX;
#endif
#ifdef WITH_POP3
    mn_mailbox_types[i++] = MN_TYPE_POP3_MAILBOX;
#endif
#ifdef WITH_IMAP
    mn_mailbox_types[i++] = MN_TYPE_IMAP_MAILBOX;
#endif
#ifdef WITH_GMAIL
    mn_mailbox_types[i++] = MN_TYPE_GMAIL_MAILBOX;
#endif
#ifdef WITH_EVOLUTION
    mn_mailbox_types[i++] = MN_TYPE_EVOLUTION_MAILBOX;
#endif
    mn_mailbox_types[i] = 0;
  }}
#line 764 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 225 "mn-mailbox.gob"
static GType 
mn_mailbox_get_type_from_name (const char * type)
#line 770 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_type_from_name"
{
#line 227 "mn-mailbox.gob"
	
    int i;

    for (i = 0; mn_mailbox_types[i]; i++)
      {
	SelfClass *class;

	class = g_type_class_peek(mn_mailbox_types[i]);
	g_return_val_if_fail(class != NULL, 0);

	if (! strcmp(class->type, type))
	  return mn_mailbox_types[i];
      }

    return 0;
  }}
#line 791 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 244 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new (const char * type, const char * first, ...)
#line 797 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new"
{
#line 246 "mn-mailbox.gob"
	
    va_list args;
    GType type_id;
    GObject *object;

    g_return_val_if_fail(type != NULL, NULL);

    type_id = self_get_type_from_name(type);
    if (! type_id)
      return NULL;

    va_start(args, first);
    object = g_object_new_valist(type_id, first, args);
    va_end(args);

    return SELF(object);
  }}
#line 819 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 264 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_xml_node (xmlNode * node, GError ** err)
#line 825 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_xml_node"
{
#line 266 "mn-mailbox.gob"
	
    char *type;
    Self *self = NULL;
    GParamSpec **properties;
    unsigned int n_properties;
    int i;

    g_return_val_if_fail(node != NULL, NULL);

    type = xmlGetProp(node, "type");
    if (! type)
      {
	g_set_error(err, 0, 0, _("\"type\" attribute missing"));
	return NULL;
      }

    self = self_new(type, NULL);
    if (! self)
      {
	g_set_error(err, 0, 0, _("unknown mailbox type \"%s\""), type);
	goto end;
      }

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_PERMANENT) != 0)
	{
	  char *content;

	  content = xmlGetProp(node, g_param_spec_get_name(properties[i]));
	  if (content)
	    {
	      GValue value = { 0, };

	      g_value_init(&value, G_PARAM_SPEC_VALUE_TYPE(properties[i]));

	      if (self_import_string(&value, content))
		g_object_set_property(G_OBJECT(self), g_param_spec_get_name(properties[i]), &value);
	      else
		g_warning(_("property \"%s\": unable to transform string \"%s\" into a value of type \"%s\""),
			  g_param_spec_get_name(properties[i]), content, G_VALUE_TYPE_NAME(&value));

	      g_value_unset(&value);
	      xmlFree(content);
	    }
	}
    g_free(properties);
    
    if (! self_validate(self, err))
      {
	g_object_unref(self);
	self = NULL;
      }
    
  end:
    g_free(type);
    return self;
  }}
#line 888 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 325 "mn-mailbox.gob"
xmlNode * 
mn_mailbox_xml_node_new (MNMailbox * self)
#line 894 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::xml_node_new"
#line 325 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (xmlNode * )0);
#line 325 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (xmlNode * )0);
#line 901 "mn-mailbox.c"
{
#line 327 "mn-mailbox.gob"
	
    xmlNode *node;
    GParamSpec **properties;
    unsigned int n_properties;
    int i;

    node = xmlNewNode(NULL, "mailbox");
    xmlSetProp(node, "type", SELF_GET_CLASS(self)->type);
    
    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_PERMANENT) != 0)
	{
	  GValue value = { 0, };
	  gboolean is_default;
	  
	  g_value_init(&value, G_PARAM_SPEC_VALUE_TYPE(properties[i]));
	  g_object_get_property(G_OBJECT(self), g_param_spec_get_name(properties[i]), &value);

	  if ((properties[i]->flags & MN_MAILBOX_PARAM_IGNORE_CASE) != 0)
	    {
	      GValue default_value = { 0, };
	      const char *str;
	      const char *default_str;

	      g_assert(G_IS_PARAM_SPEC_STRING(properties[i]));

	      g_value_init(&default_value, G_TYPE_STRING);
	      g_param_value_set_default(properties[i], &default_value);

	      str = g_value_get_string(&value);
	      default_str = g_value_get_string(&default_value);

	      is_default = str && default_str && ! mn_utf8_strcasecmp(str, default_str);

	      g_value_unset(&default_value);
	    }
	  else
	    is_default = g_param_value_defaults(properties[i], &value);
	  
	  if (! is_default)
	    {
	      char *str;

	      str = self_export_string(&value);
	      xmlSetProp(node, g_param_spec_get_name(properties[i]), str);
	      g_free(str);
	    }
	  
	  g_value_unset(&value);
	}
    g_free(properties);

    return node;
  }}
#line 959 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 383 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_uri (const char * uri)
#line 965 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_uri"
#line 383 "mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 970 "mn-mailbox.c"
{
#line 385 "mn-mailbox.gob"
	
    int i;

    for (i = 0; mn_mailbox_types[i]; i++)
      {
	MNMailboxClass *class;

	class = g_type_class_peek(mn_mailbox_types[i]);
	g_return_val_if_fail(class != NULL, NULL);

	if (class->parse_uri)
	  {
	    MNMailbox *mailbox;

	    mailbox = class->parse_uri(NULL, uri);
	    if (mailbox)
	      return mailbox;
	  }
      }
    
    return NULL;
  }}
#line 995 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 408 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_configuration (MNMailboxConfiguration * config)
#line 1001 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_configuration"
#line 408 "mn-mailbox.gob"
	g_return_val_if_fail (config != NULL, (MNMailbox * )0);
#line 1006 "mn-mailbox.c"
{
#line 410 "mn-mailbox.gob"
	
    return g_object_newv(config->type, config->n_parameters, config->parameters);
  }}
#line 1012 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 414 "mn-mailbox.gob"
MNMailboxConfiguration * 
mn_mailbox_get_configuration (MNMailbox * self)
#line 1018 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_configuration"
#line 414 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxConfiguration * )0);
#line 414 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMailboxConfiguration * )0);
#line 1025 "mn-mailbox.c"
{
#line 416 "mn-mailbox.gob"
	
    GObject *object = G_OBJECT(self);
    GArray *parameters;
    GParamSpec **properties;
    unsigned int n_properties;
    int i;
    MNMailboxConfiguration *config;

    parameters = g_array_new(FALSE, FALSE, sizeof(GParameter));

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_PERMANENT) != 0)
	{
	  GParameter parameter = { NULL, { 0, } };

	  parameter.name = g_param_spec_get_name(properties[i]);

	  g_value_init(&parameter.value, G_PARAM_SPEC_VALUE_TYPE(properties[i]));
	  g_object_get_property(object, parameter.name, &parameter.value);
	  
	  g_array_append_val(parameters, parameter);
	}
    g_free(properties);

    config = g_new0(MNMailboxConfiguration, 1);
    config->type = G_OBJECT_TYPE(self);
    config->n_parameters = parameters->len;
    config->parameters = (GParameter *) g_array_free(parameters, FALSE);

    return config;
  }}
#line 1060 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 449 "mn-mailbox.gob"
void 
mn_mailbox_configuration_free (MNMailboxConfiguration * config)
#line 1066 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::configuration_free"
#line 449 "mn-mailbox.gob"
	g_return_if_fail (config != NULL);
#line 1071 "mn-mailbox.c"
{
#line 451 "mn-mailbox.gob"
	
    int i;

    for (i = 0; i < config->n_parameters; i++)
      g_value_unset(&config->parameters[i].value);

    g_free(config->parameters);
    g_free(config);
  }}
#line 1083 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 461 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_obsolete_uri (const char * uri)
#line 1089 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_obsolete_uri"
#line 461 "mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1094 "mn-mailbox.c"
{
#line 463 "mn-mailbox.gob"
	
    char *real_uri;
    char *scheme;
    gboolean obsolete = FALSE;
    Self *self = NULL;

    real_uri = g_str_has_prefix(uri, "pop3:") /* also handle very old pop3 locators */
      ? g_strconcat("pop://", uri + 5, NULL)
      : g_strdup(uri);

    scheme = gnome_vfs_get_uri_scheme(real_uri);
    if (scheme)
      {
	if (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops")
	    || ! strcmp(scheme, "imap") || ! strcmp(scheme, "imaps")
	    || ! strcmp(scheme, "gmail"))
	  obsolete = TRUE;
	g_free(scheme);
      }

    self = obsolete ? self_parse_obsolete_uri(real_uri) : self_new_from_uri(real_uri);
    g_free(real_uri);

    if (self && ! self_validate(self, NULL))
      {
	g_object_unref(self);
	self = NULL;
      }
    
    return self;
  }}
#line 1128 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 495 "mn-mailbox.gob"
static MNMailbox * 
mn_mailbox_parse_obsolete_uri (const char * uri)
#line 1134 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::parse_obsolete_uri"
#line 495 "mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1139 "mn-mailbox.c"
{
#line 497 "mn-mailbox.gob"
	
    int len;
    int buflen;
    char *scheme;
    char *username;
    char *password;
    char *authmech;
    char *hostname;
    int port;
    char *path;
    char **queries;
    Self *self = NULL;

    len = strlen(uri);
    buflen = len + 1;

    {
      char *pat;
      char scheme_buf[buflen];
      char auth_buf[buflen];
      char location_buf[buflen];
      char username_buf[buflen];
      char password_buf[buflen];
      char authmech_buf[buflen];
      char hostname_buf[buflen];
      int _port;
      char path_buf[buflen];
      char queries_buf[buflen];
      gboolean has_location = FALSE;
      gboolean has_password = FALSE;
      gboolean has_authmech = FALSE;
      gboolean has_port = FALSE;
      gboolean has_path = FALSE;
      gboolean has_queries = FALSE;
      int n;

      /* split URI in 3 parts: scheme, auth and location */

      pat = g_strdup_printf("%%%i[^:]://%%%i[^@]@%%%is", len, len, len);
      n = sscanf(uri, pat, scheme_buf, auth_buf, location_buf);
      g_free(pat);

      if (n >= 2)
	{
	  if (n == 3)
	    has_location = TRUE;
	}
      else
	return NULL;		/* unparsable */

      /* split auth part in 3 subparts: username, password and authmech */

      /*
       * For backward compatibility with previous versions of Mail
       * Notification, we also support ;auth= (in lowercase).
       */
      
      pat = g_strdup_printf("%%%i[^:]:%%%i[^;];%%*1[aA]%%*1[uU]%%*1[tT]%%*1[hH]=%%%is", len, len, len);
      n = sscanf(auth_buf, pat, username_buf, password_buf, authmech_buf);
      g_free(pat);

      if (n >= 2)
	{
	  has_password = TRUE;
	  if (n == 3)
	    has_authmech = TRUE;
	}
      else
	{
	  pat = g_strdup_printf("%%%i[^;];%%*1[aA]%%*1[uU]%%*1[tT]%%*1[hH]=%%%is", len, len);
	  n = sscanf(auth_buf, pat, username_buf, authmech_buf);
	  g_free(pat);

	  if (n >= 1)
	    {
	      if (n == 2)
		has_authmech = TRUE;
	    }
	  else
	    return NULL;	/* unparsable */
	}

      if (has_location)
	{
	  char hostport_buf[buflen];

	  /* split location part in 3 subparts: hostport, path and queries */

	  pat = g_strdup_printf("%%%i[^/]/%%%i[^?]?%%%is", len, len, len);
	  n = sscanf(location_buf, pat, hostport_buf, path_buf, queries_buf);
	  g_free(pat);

	  if (n >= 2)
	    {
	      has_path = TRUE;
	      if (n == 3)
		has_queries = TRUE;
	    }
	  else
	    {
	      pat = g_strdup_printf("%%%i[^?]?%%%is", len, len);
	      n = sscanf(location_buf, pat, hostport_buf, queries_buf);
	      g_free(pat);

	      if (n == 2)
		has_queries = TRUE;
	    }

	  /* split hostport in 2 subparts: host and port */

	  pat = g_strdup_printf("[%%%i[^]]]:%%u", len);
	  n = sscanf(hostport_buf, pat, hostname_buf, &_port);
	  g_free(pat);
	
	  if (n < 1)
	    {
	      pat = g_strdup_printf("%%%i[^:]:%%u", len);
	      n = sscanf(hostport_buf, pat, hostname_buf, &_port);
	      g_free(pat);
	    }
	
	  if (n == 2)
	    has_port = TRUE;
	}

      scheme = gnome_vfs_unescape_string(scheme_buf, NULL);
      username = gnome_vfs_unescape_string(username_buf, NULL);
      password = has_password ? gnome_vfs_unescape_string(password_buf, NULL) : NULL;
      authmech = has_authmech ? gnome_vfs_unescape_string(authmech_buf, NULL) : NULL;
      hostname = has_location ? gnome_vfs_unescape_string(hostname_buf, NULL) : NULL;
      port = has_port ? _port : 0;
      path = has_path ? gnome_vfs_unescape_string(path_buf, NULL) : NULL;
      if (has_queries)
	{
	  int i;
	  
	  queries = g_strsplit(queries_buf, "&", 0);
	  for (i = 0; queries[i]; i++)
	    {
	      char *unescaped;

	      unescaped = gnome_vfs_unescape_string(queries[i], NULL);

	      g_free(queries[i]);
	      queries[i] = unescaped;
	    }
	}
      else
	queries = NULL;
    }

    if (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops"))
      {
#ifdef WITH_POP3
	MNPIMailboxConnectionType connection_type;

	if (queries && eel_g_strv_find(queries, "STLS") != -1)
	  connection_type = MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL;
	else
	  connection_type = ! strcmp(scheme, "pops")
	    ? MN_PI_MAILBOX_CONNECTION_TYPE_SSL
	    : MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL;

	self = self_new("pop3",
			"connection-type", connection_type,
			"username", username,
			"password", password,
			"authmech", authmech,
			"hostname", hostname,
			"port", port,
			NULL);
#endif
      }
    else if (! strcmp(scheme, "imap") || ! strcmp(scheme, "imaps"))
      {
#ifdef WITH_IMAP
	MNPIMailboxConnectionType connection_type;

	if (queries && eel_g_strv_find(queries, "STARTTLS") != -1)
	  connection_type = MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL;
	else
	  connection_type = ! strcmp(scheme, "imaps")
	    ? MN_PI_MAILBOX_CONNECTION_TYPE_SSL
	    : MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL;

	self = self_new("imap",
			"connection-type", connection_type,
			"username", username,
			"password", password,
			"authmech", authmech,
			"hostname", hostname,
			"port", port,
			"mailbox", path,
			NULL);

	if (queries && eel_g_strv_find(queries, "noidle") != -1)
	  g_object_set(G_OBJECT(self), "use-idle-extension", MN_IMAP_MAILBOX_USE_IDLE_NEVER, NULL);
#endif
      }
    else if (! strcmp(scheme, "gmail"))
      {
#ifdef WITH_GMAIL
	self = self_new("gmail",
			"username", username,
			"password", password,
			NULL);
#endif
      }

    g_free(scheme);
    g_free(username);
    g_free(password);
    g_free(authmech);
    g_free(hostname);
    g_free(path);
    g_strfreev(queries);

    return self;
  }}
#line 1361 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 717 "mn-mailbox.gob"
static gboolean 
mn_mailbox_validate (MNMailbox * self, GError ** err)
#line 1367 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::validate"
#line 717 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 717 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 1374 "mn-mailbox.c"
{
#line 719 "mn-mailbox.gob"
	
    GParamSpec **properties;
    unsigned int n_properties;
    int i;

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_REQUIRED) != 0)
	{
	  GValue value = { 0, };
	  const char *str;
	  gboolean is_empty;
	  
	  g_return_val_if_fail(G_IS_PARAM_SPEC_STRING(properties[i]), FALSE);
	  
	  g_value_init(&value, G_TYPE_STRING);
	  g_object_get_property(G_OBJECT(self), g_param_spec_get_name(properties[i]), &value);
	  
	  str = g_value_get_string(&value);
	  is_empty = ! str || ! *str;
	  
	  g_value_unset(&value);
	  
	  if (is_empty)
	    {
	      g_set_error(err, 0, 0, _("property \"%s\" has no value"), g_param_spec_get_name(properties[i]));
	      return FALSE;
	    }
	}
    g_free(properties);

    return TRUE;
  }}
#line 1410 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 753 "mn-mailbox.gob"
void 
mn_mailbox_seal (MNMailbox * self)
#line 1416 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 753 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 753 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1423 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->seal)
		(*klass->seal)(self);
}
#line 753 "mn-mailbox.gob"
static void 
___real_mn_mailbox_seal (MNMailbox * self G_GNUC_UNUSED)
#line 1432 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::seal"
{
#line 755 "mn-mailbox.gob"
	
    if (self->name)
      {
	g_free(self->runtime_name);
	self->runtime_name = g_strdup(self->name);
      }
  }}
#line 1444 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 763 "mn-mailbox.gob"
static MNMailbox * 
mn_mailbox_parse_uri (MNMailbox * self, const char * uri)
#line 1450 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 763 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMailbox * )0);
#line 763 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMailbox * )0);
#line 1457 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->parse_uri)
		return (*klass->parse_uri)(self,uri);
	else
		return (MNMailbox * )(0);
}

#line 766 "mn-mailbox.gob"
void 
mn_mailbox_check (MNMailbox * self)
#line 1469 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 766 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 766 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1476 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->check)
		(*klass->check)(self);
}

#line 769 "mn-mailbox.gob"
void 
mn_mailbox_notice (MNMailbox * self, const char * format, ...)
#line 1486 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::notice"
#line 769 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 769 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 769 "mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 1495 "mn-mailbox.c"
{
#line 771 "mn-mailbox.gob"
	
    va_list args;
    char *message;
    
    va_start(args, format);
    message = g_strdup_vprintf(format, args);
    va_end(args);

    mn_info("%s: %s", self->runtime_name, message);
    g_free(message);
  }}
#line 1509 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 783 "mn-mailbox.gob"
void 
mn_mailbox_warning (MNMailbox * self, const char * format, ...)
#line 1515 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::warning"
#line 783 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 783 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 783 "mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 1524 "mn-mailbox.c"
{
#line 785 "mn-mailbox.gob"
	
    va_list args;
    char *message;

    va_start(args, format);
    message = g_strdup_vprintf(format, args);
    va_end(args);

    g_warning("%s: %s", self->runtime_name, message);
    g_free(message);
  }}
#line 1538 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 797 "mn-mailbox.gob"
static gboolean 
mn_mailbox_import_string (GValue * value, const char * str)
#line 1544 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::import_string"
#line 797 "mn-mailbox.gob"
	g_return_val_if_fail (value != NULL, (gboolean )0);
#line 797 "mn-mailbox.gob"
	g_return_val_if_fail (str != NULL, (gboolean )0);
#line 1551 "mn-mailbox.c"
{
#line 799 "mn-mailbox.gob"
	
    g_return_val_if_fail(G_IS_VALUE(value), FALSE);

    if (G_VALUE_HOLDS_BOOLEAN(value))
      {
	if (! strcmp(str, "false"))
	  g_value_set_boolean(value, FALSE);
	else if (! strcmp(str, "true"))
	  g_value_set_boolean(value, TRUE);
	else
	  return FALSE;
      }
    else if (G_VALUE_HOLDS_INT(value))
      {
	int n;
	char *endptr;

	n = strtol(str, &endptr, 10);
	if (*endptr == '\0')	/* successful conversion */
	  g_value_set_int(value, n);
	else
	  return FALSE;
      }
    else if (G_VALUE_HOLDS_STRING(value))
      g_value_set_string(value, str);
    else if (G_VALUE_HOLDS_ENUM(value))
      {
	GEnumClass *enum_class;
	GEnumValue *enum_value;
	gboolean found;

	enum_class = g_type_class_ref(G_VALUE_TYPE(value));
	enum_value = g_enum_get_value_by_nick(enum_class, str);

	if (enum_value)
	  {
	    g_value_set_enum(value, enum_value->value);
	    found = TRUE;
	  }
	else
	  found = FALSE;

	g_type_class_unref(enum_class);

	if (! found)
	  return FALSE;
      }
    else
      g_return_val_if_reached(FALSE);

    return TRUE;
  }}
#line 1606 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 852 "mn-mailbox.gob"
static char * 
mn_mailbox_export_string (const GValue * value)
#line 1612 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::export_string"
#line 852 "mn-mailbox.gob"
	g_return_val_if_fail (value != NULL, (char * )0);
#line 1617 "mn-mailbox.c"
{
#line 854 "mn-mailbox.gob"
	
    char *str;

    if (G_VALUE_HOLDS_BOOLEAN(value))
      str = g_strdup(g_value_get_boolean(value) ? "true" : "false");
    else if (G_VALUE_HOLDS_INT(value))
      str = g_strdup_printf("%i", g_value_get_int(value));
    else if (G_VALUE_HOLDS_STRING(value))
      str = g_value_dup_string(value);
    else if (G_VALUE_HOLDS_ENUM(value))
      {
	GEnumClass *enum_class;
	GEnumValue *enum_value;

	enum_class = g_type_class_ref(G_VALUE_TYPE(value));
	enum_value = g_enum_get_value(enum_class, g_value_get_enum(value));
	g_return_val_if_fail(enum_value != NULL, NULL);

	str = g_strdup(enum_value->value_nick);
	g_type_class_unref(enum_class);
      }
    else
      g_return_val_if_reached(NULL);

    return str;
  }}
#line 1646 "mn-mailbox.c"
#undef __GOB_FUNCTION__
