/*******************

Written by Frank Rimlinger, August 1992
Revised by Frank Rimlinger, January 1993
*******************/
#include "FGLvarInterface.h"
#include "FGLvarInitInfo.h"
#include "FGLink.h"
#include "crossTrainer.h"
#include "GLfunctions.h"
#include "FResources.h"
#include "FGLrecycleStack.h"
#include <stdio.h>

//INTERFACE WITH FGLink
FGLvarInterface::FGLvarInterface(FGLink *aGLink, FGLvarInitInfo* info)
	:FObject(){

// set itsGLink
	itsGLink=aGLink;
	BlockMove((Ptr)info->errorStr,(Ptr)itsName,255);
	IDactiveMax=info->IDactiveMax;
	noEntries[GLr]=info->rNoEntries;	
	
// CAUTION: noEntries[GLir] and noEntried[GLi] must be equal
// for packFunc to work correctly
	
	noEntries[GLir]=info->iNoEntries;		
	noEntries[GLi]=info->iNoEntries;
	
					
	noEntries[GLlut]=info->lutNoEntries;			
	ChildNoEntries=info->ChildNoEntries;	// child vertices generated by FGLwalkNode
	useD=info->useD;
	DtypeSize=info->DtypeSize;
	useiD=info->useiD;
	iDtypeSize=info->iDtypeSize;
	recycleReal=info->recycleReal;
	recycleIdeal=info->recycleIdeal;
	backYardSize[GLr]=info->rBackYardSize;		
	backYardSize[GLir]=info->irBackYardSize;		
	backYardSize[GLi]=info->iBackYardSize;		
	backYardSize[GLlut]=info->lutBackYardSize;		
	backYardSize[GLrv]=info->rvBackYardSize;			
	backYardSize[GLiv]=info->ivBackYardSize;
	recycleBlockSize=info->recycleBlockSize;
	ComputePacketSizes();
	
// initialize the recycling stacks
	FGLrecycleStack *aRecycleStack;	
	for(long index=0;index<GLflags;++index){
		recycle[index]= new FGLrecycleStack(index,recycleBlockSize);
	}
	rDead=new FGLrecycleStack(GLrv,recycleBlockSize);
	iDead=new FGLrecycleStack(GLiv,recycleBlockSize);
//initialize memory management counters
	for(long index=0;index<GLflags;++index){
		Packets[index]=0;
		Seeks[index]=0;
		Total[index]=0;
		InUse[index]=0;
	}
//check for valid value of IDactiveMax
	if(IDactiveMax<0){
		varErr(18);
	}
//initialize IDnoActive
	IDnoActive=0;
//initialize IDcounter
	IDcounter=0;
//nominally initialize the registers
	e=1;
	j=0;
	GLref NA=FGLink::NA;
	bv=NA;
	cv=NA;
//ideal vertex lookup table doesn't have a packet yet
	ivLutRef=NA;
//initialize ID stuff
	Boolean **IDinUse= (Boolean **)GLhandle(IDactiveMax*sizeof(Boolean),
							"FGLvarInterface::FGLvarInterface");
	this->IDinUse=IDinUse;
	long** currentID=(long**)GLhandle(IDactiveMax*sizeof(long),
							"FGLvarInterface::FGLvarInterface");
	this->currentID=currentID;
	for(long index=0;index<IDactiveMax;++index){
		(*IDinUse)[index]=FALSE;
	}
	activeNodes=new FList;
	activeNodes->SetBlockSize(2*IDactiveMax+3); //just a fudge.
	itsGLink->AddGLvar(this);
}

FGLvarInterface::~FGLvarInterface(void){
// CAUTION: this method does not necessarily release memory allocated by the
// BlockManager to hold the GLvar data.  

// BlockManager memory can be freed directly by disposing itsCGLink,
// or indirectly by disposing ALL the CGLvars owned by itsCGLink.
// When a FGLink detects that all its CGLvars have been disposed, then
// it reinitializes itsBlockManager.
	for(long index=0;index<GLflags;++index){
		delete recycle[index];recycle[index]=0;
	}
	delete rDead;rDead=0;
	delete iDead;iDead=0;
	delete activeNodes;activeNodes=0;
#ifdef Frank_GenuineMac
	forgetHan((Handle)currentID);
	forgetHan((Handle)IDinUse);
#else
	Handle han=(Handle)currentID;
	forgetHan(han);
	han=(Handle)IDinUse;
	forgetHan(han);
#endif
	if(!itsGLink->DisposalSequenceInProgress){
		itsGLink->RemoveGLvar(this);
	}
}

void FGLvarInterface::ComputePacketSizes(void){
	// assumes that the following are initialized
	//  noentries[*]
	//  backYardSize[*]	
	//  useiD
	//  useD
	//  DtypeSize
	//  iDtypeSize
	
	//  CAUTION:  sets DtypeSize=0 if useD=FALSE.
	//  CAUTION:  sets iDtypdSize=0 if useiD=FALSE.
							
	// check validity of noEntries
	// check validity of noEntries
	if(noEntries[GLr]<1){
		varErr(10);
	}	
	if(noEntries[GLir]<1){
		varErr(12);
	}	
	if(noEntries[GLi]<1){
		varErr(13);
	}	
	if(noEntries[GLlut]<1){
		varErr(14);
	}	
	if(ChildNoEntries<1){
		varErr(15);
	}	
	// check validity of backYardSize
	if(backYardSize[GLr]<0){
		varErr(37);
	}	
	if(backYardSize[GLir]<0){
		varErr(37);
	}	
	if(backYardSize[GLi]<0){
		varErr(37);
	}	
	if(backYardSize[GLlut]<0){
		varErr(37);
	}	
	if(backYardSize[GLrv]<0){
		varErr(37);
	}	
	if(backYardSize[GLiv]<0){
		varErr(37);
	}

//set dataOffset
	long initialOffset=sizeof(long)+2*sizeof(GLref); //header for real/ideal link
											     //and ideal vertex lut
	dataOffset[GLr]=initialOffset;
	dataOffset[GLir]=initialOffset;
	dataOffset[GLi]=initialOffset;
	dataOffset[GLlut]=initialOffset;
	dataOffset[GLiv]=2*sizeof(Boolean)+sizeof(GLref)+sizeof(long);
	dataOffset[GLrv]=2*(sizeof(Boolean)+sizeof(GLref))+IDactiveMax*sizeof(long);

//  define ownerOffset, this only pertains to GLr,GLir, and GLi
//  the other values are set to 0 to optimize code for xGetPacketOwner

	ownerOffset[GLr]=initialOffset+2*noEntries[GLr]*sizeof(GLref);
	ownerOffset[GLir]=initialOffset+2*noEntries[GLir]*sizeof(GLref);
	ownerOffset[GLi]=initialOffset+2*noEntries[GLi]*sizeof(GLref);
	ownerOffset[GLlut]=0;
	ownerOffset[GLiv]=0;
	ownerOffset[GLrv]=0;
	
//  define backYardOffset

	if(!useD)DtypeSize=0;
	if(!useiD)iDtypeSize=0;

	backYardOffset[GLiv]=dataOffset[GLiv]+iDtypeSize;
	backYardOffset[GLrv]=dataOffset[GLrv]+DtypeSize;
	backYardOffset[GLr]=ownerOffset[GLr]+sizeof(GLref);		
	backYardOffset[GLir]=ownerOffset[GLir]+sizeof(GLref);
	backYardOffset[GLi]=ownerOffset[GLi]+sizeof(GLref);
	backYardOffset[GLlut]=initialOffset+noEntries[GLlut]*sizeof(GLref);
// define packet sizes
	for(long i=0;i<GLflags;++i){
		packetSize[i]=backYardOffset[i]+backYardSize[i];
	}
}

void FGLvarInterface::xFlush(short vertexType){
	GLref ref;
	switch(vertexType){
		case GLreal:{
			while(rDead->numItems>0){
				rDead->recyclePop(ref,this);
				recycle[GLrv]->recyclePush(this,ref);
			}
		}
		break;
		case GLideal:{
			while(iDead->numItems>0){
				iDead->recyclePop(ref,this);
				recycle[GLiv]->recyclePush(this,ref);
			}

		}
		break;
		default: varErr(33);
	}
}

Boolean FGLvarInterface::isDead(void){
	Ptr DEREF=this&bv;
	GLref ref;
	BlockMove(&DEREF[2*sizeof(Boolean)],(Ptr)&ref,sizeof(GLref));
	this-bv;	
	return ref.index==FGLink::DEADVERTEX.index;
}

//ERROR DETECTION
void FGLvarInterface::varErr(int ID){ 
	// displays varErr resource message with index ID.
	Str255 paramNULL;
	*paramNULL=0;
	Str255 param0;
	sprintf((char *)param0,"varErr %d",ID);  // setting up param0
	CtoPstr((char*)param0);
	Str255 param1;
	BlockMove((Ptr)itsName,(Ptr)param1,255);
	Str255 param2;
	GetIndString(param2,FResources::xSTRvarErr,ID);  // setting up param2
	if(param2[0]==0){
		GetIndString(param2,FResources::xSTRvarErr,1);
	}
	ParamText(param0,param1,param2,paramNULL);
	GeneralAlert();
} 

Ptr FGLvarInterface::xCheckPtr(const GLref& addr){
	// CAUTION: this routine is normally called
	// indirectly via 
	//
	//    const GLref& operator&(FGLvarInterface*,const GLref&)
	//
	// This operator locks the block containing addr so the
	// returned pointer remains valid in the event memory moves.
	// You must be careful because each call to operator& must be
	// balanced with a call to operator- which unlocks the block.
	//
	// In certain low-level situations where it is known that the
	// block is already locked, xCheckPtr is called directly to
	// avoid needless locking/unlocked overhead.
	
	Handle blockhandle;
	FBlockManager *BlockManager;
	BlockManager=itsGLink->itsBlockManager;

	blockhandle=(Handle)BlockManager->NthItem(addr.index);
	if(blockhandle==NULL){
		varErr(5);
	}
	if(addr.offset<0L || addr.offset>=BlockManager->TopSize){
		varErr(5);
	}

	return &((*blockhandle)[addr.offset]);
}


Boolean FGLvarInterface::thisRead(int refnum){ // moves memory
	return FALSE;
}

Boolean FGLvarInterface::thisWrite(int refnum){
	return FALSE;
}


