# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1ObjectReference(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'kind': 'str',
            'namespace': 'str',
            'name': 'str',
            'uid': 'str',
            'api_version': 'str',
            'resource_version': 'str',
            'field_path': 'str'
        }

        self.attribute_map = {
            'kind': 'kind',
            'namespace': 'namespace',
            'name': 'name',
            'uid': 'uid',
            'api_version': 'apiVersion',
            'resource_version': 'resourceVersion',
            'field_path': 'fieldPath'
        }

        self._kind = None
        self._namespace = None
        self._name = None
        self._uid = None
        self._api_version = None
        self._resource_version = None
        self._field_path = None

    @property
    def kind(self):
        """
        Gets the kind of this V1ObjectReference.
        kind of the referent; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#types-kinds

        :return: The kind of this V1ObjectReference.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this V1ObjectReference.
        kind of the referent; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#types-kinds

        :param kind: The kind of this V1ObjectReference.
        :type: str
        """
        self._kind = kind

    @property
    def namespace(self):
        """
        Gets the namespace of this V1ObjectReference.
        namespace of the referent; see http://releases.k8s.io/v1.0.4/docs/namespaces.md

        :return: The namespace of this V1ObjectReference.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this V1ObjectReference.
        namespace of the referent; see http://releases.k8s.io/v1.0.4/docs/namespaces.md

        :param namespace: The namespace of this V1ObjectReference.
        :type: str
        """
        self._namespace = namespace

    @property
    def name(self):
        """
        Gets the name of this V1ObjectReference.
        name of the referent; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#names

        :return: The name of this V1ObjectReference.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this V1ObjectReference.
        name of the referent; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#names

        :param name: The name of this V1ObjectReference.
        :type: str
        """
        self._name = name

    @property
    def uid(self):
        """
        Gets the uid of this V1ObjectReference.
        uid of the referent; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#uids

        :return: The uid of this V1ObjectReference.
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """
        Sets the uid of this V1ObjectReference.
        uid of the referent; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#uids

        :param uid: The uid of this V1ObjectReference.
        :type: str
        """
        self._uid = uid

    @property
    def api_version(self):
        """
        Gets the api_version of this V1ObjectReference.
        API version of the referent

        :return: The api_version of this V1ObjectReference.
        :rtype: str
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version):
        """
        Sets the api_version of this V1ObjectReference.
        API version of the referent

        :param api_version: The api_version of this V1ObjectReference.
        :type: str
        """
        self._api_version = api_version

    @property
    def resource_version(self):
        """
        Gets the resource_version of this V1ObjectReference.
        specific resourceVersion to which this reference is made, if any: http://releases.k8s.io/v1.0.4/docs/api-conventions.md#concurrency-control-and-consistency

        :return: The resource_version of this V1ObjectReference.
        :rtype: str
        """
        return self._resource_version

    @resource_version.setter
    def resource_version(self, resource_version):
        """
        Sets the resource_version of this V1ObjectReference.
        specific resourceVersion to which this reference is made, if any: http://releases.k8s.io/v1.0.4/docs/api-conventions.md#concurrency-control-and-consistency

        :param resource_version: The resource_version of this V1ObjectReference.
        :type: str
        """
        self._resource_version = resource_version

    @property
    def field_path(self):
        """
        Gets the field_path of this V1ObjectReference.
        if referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]

        :return: The field_path of this V1ObjectReference.
        :rtype: str
        """
        return self._field_path

    @field_path.setter
    def field_path(self, field_path):
        """
        Sets the field_path of this V1ObjectReference.
        if referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]

        :param field_path: The field_path of this V1ObjectReference.
        :type: str
        """
        self._field_path = field_path

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
