
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file AxisAttributes.h
    \\brief Definition of Axis Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "AxisWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



AxisWrapper::AxisWrapper(): axis_(new Axis())


{


	

}
AxisWrapper::AxisWrapper(Axis* axis): axis_(axis)
{

	
}

AxisWrapper::~AxisWrapper()
{

}

void AxisWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("AXIS_ORIENTATION") ) {
		string orientation_value = request("AXIS_ORIENTATION");
		axis_->orientation_ = orientation_value;
		}
	if  (request.countValues("AXIS_POSITION") ) {
		string position_value = request("AXIS_POSITION");
		axis_->position_ = position_value;
		}
	if  (request.countValues("AXIS_LINE") ) {
		string line_value = request("AXIS_LINE");
		
		axis_->line_ = MagTranslator<string, bool>()(line_value);
		
		}
	if  (request.countValues("AXIS_LINE_THICKNESS") ) {
		int line_thickness_value = request("AXIS_LINE_THICKNESS");
		axis_->line_thickness_ = line_thickness_value;
		}
	if  (request.countValues("AXIS_GRID") ) {
		string grid_value = request("AXIS_GRID");
		
		axis_->grid_ = MagTranslator<string, bool>()(grid_value);
		
		}
	if  (request.countValues("AXIS_GRID_THICKNESS") ) {
		int grid_thickness_value = request("AXIS_GRID_THICKNESS");
		axis_->grid_thickness_ = grid_thickness_value;
		}
	if  (request.countValues("AXIS_MINOR_GRID") ) {
		string minor_grid_value = request("AXIS_MINOR_GRID");
		
		axis_->minor_grid_ = MagTranslator<string, bool>()(minor_grid_value);
		
		}
	if  (request.countValues("AXIS_MINOR_GRID_THICKNESS") ) {
		int minor_grid_thickness_value = request("AXIS_MINOR_GRID_THICKNESS");
		axis_->minor_grid_thickness_ = minor_grid_thickness_value;
		}
	if  (request.countValues("AXIS_GRID_REFERENCE_LEVEL") ) {
		double grid_reference_level_value = request("AXIS_GRID_REFERENCE_LEVEL");
		axis_->grid_reference_level_ = grid_reference_level_value;
		}
	if  (request.countValues("AXIS_GRID_REFERENCE_THICKNESS") ) {
		int grid_reference_thickness_value = request("AXIS_GRID_REFERENCE_THICKNESS");
		axis_->grid_reference_thickness_ = grid_reference_thickness_value;
		}
	if  (request.countValues("AXIS_TITLE") ) {
		string title_value = request("AXIS_TITLE");
		
		axis_->title_ = MagTranslator<string, bool>()(title_value);
		
		}
	if  (request.countValues("AXIS_TITLE_TEXT") ) {
		string title_text_value = request("AXIS_TITLE_TEXT");
		axis_->title_text_ = title_text_value;
		}
	if  (request.countValues("AXIS_TITLE_ORIENTATION") ) {
		string title_orientation_value = request("AXIS_TITLE_ORIENTATION");
		axis_->title_orientation_ = title_orientation_value;
		}
	if  (request.countValues("AXIS_TITLE_HEIGHT") ) {
		double title_height_value = request("AXIS_TITLE_HEIGHT");
		axis_->title_height_ = title_height_value;
		}
	if  (request.countValues("AXIS_TITLE_FONT") ) {
		string title_font_value = request("AXIS_TITLE_FONT");
		axis_->title_font_ = title_font_value;
		}
	if  (request.countValues("AXIS_TITLE_FONT_STYLE") ) {
		string title_font_style_value = request("AXIS_TITLE_FONT_STYLE");
		axis_->title_font_style_ = title_font_style_value;
		}
	if  (request.countValues("AXIS_TITLE_POSITION") ) {
		double title_relative_position_value = request("AXIS_TITLE_POSITION");
		axis_->title_relative_position_ = title_relative_position_value;
		}
	if  (request.countValues("AXIS_TICK") ) {
		string tick_value = request("AXIS_TICK");
		
		axis_->tick_ = MagTranslator<string, bool>()(tick_value);
		
		}
	if  (request.countValues("AXIS_TICK_INTERVAL") ) {
		double interval_value = request("AXIS_TICK_INTERVAL");
		axis_->interval_ = interval_value;
		}
	doublearray  positions_value;
	for (int i = 0; i < request.countValues("AXIS_TICK_POSITION_LIST"); i++)
		positions_value.push_back((double)request("AXIS_TICK_POSITION_LIST", i));
	if ( !positions_value.empty() )
		axis_->positions_ = positions_value;
	if  (request.countValues("AXIS_TICK_POSITION") ) {
		string tick_position_value = request("AXIS_TICK_POSITION");
		axis_->tick_position_ = tick_position_value;
		}
	if  (request.countValues("AXIS_TICK_SIZE") ) {
		double tick_length_value = request("AXIS_TICK_SIZE");
		axis_->tick_length_ = tick_length_value;
		}
	if  (request.countValues("AXIS_TICK_THICKNESS") ) {
		int tick_thickness_value = request("AXIS_TICK_THICKNESS");
		axis_->tick_thickness_ = tick_thickness_value;
		}
	if  (request.countValues("AXIS_TICK_LABEL") ) {
		string label_value = request("AXIS_TICK_LABEL");
		
		axis_->label_ = MagTranslator<string, bool>()(label_value);
		
		}
	if  (request.countValues("AXIS_TICK_LABEL_TYPE") ) {
		string label_type_value = request("AXIS_TICK_LABEL_TYPE");
		axis_->label_type_ = label_type_value;
		}
	if  (request.countValues("AXIS_TICK_LABEL_FREQUENCY") ) {
		int label_frequency_value = request("AXIS_TICK_LABEL_FREQUENCY");
		axis_->label_frequency_ = label_frequency_value;
		}
	if  (request.countValues("AXIS_TICK_LABEL_FIRST") ) {
		string label_first_value = request("AXIS_TICK_LABEL_FIRST");
		
		axis_->label_first_ = MagTranslator<string, bool>()(label_first_value);
		
		}
	if  (request.countValues("AXIS_TICK_LABEL_LAST") ) {
		string label_last_value = request("AXIS_TICK_LABEL_LAST");
		
		axis_->label_last_ = MagTranslator<string, bool>()(label_last_value);
		
		}
	if  (request.countValues("AXIS_TICK_LABEL_POSITION") ) {
		string label_position_value = request("AXIS_TICK_LABEL_POSITION");
		axis_->label_position_ = label_position_value;
		}
	if  (request.countValues("AXIS_TICK_LABEL_ORIENTATION") ) {
		string label_orientation_value = request("AXIS_TICK_LABEL_ORIENTATION");
		axis_->label_orientation_ = label_orientation_value;
		}
	if  (request.countValues("AXIS_TICK_LABEL_FONT") ) {
		string label_font_value = request("AXIS_TICK_LABEL_FONT");
		axis_->label_font_ = label_font_value;
		}
	if  (request.countValues("AXIS_TICK_LABEL_FONT_STYLE") ) {
		string label_font_style_value = request("AXIS_TICK_LABEL_FONT_STYLE");
		axis_->label_font_style_ = label_font_style_value;
		}
	if  (request.countValues("AXIS_TICK_LABEL_HEIGHT") ) {
		double label_height_value = request("AXIS_TICK_LABEL_HEIGHT");
		axis_->label_height_ = label_height_value;
		}
	stringarray  label_labels_value;
	for (int i = 0; i < request.countValues("AXIS_TICK_LABEL_LIST"); i++)
		label_labels_value.push_back((string)request("AXIS_TICK_LABEL_LIST", i));
	if ( !label_labels_value.empty() )
		axis_->label_labels_ = label_labels_value;
	if  (request.countValues("AXIS_TICK_LABEL_FORMAT") ) {
		string label_format_value = request("AXIS_TICK_LABEL_FORMAT");
		axis_->label_format_ = label_format_value;
		}
	if  (request.countValues("AXIS_MINOR_TICK") ) {
		string minor_tick_value = request("AXIS_MINOR_TICK");
		
		axis_->minor_tick_ = MagTranslator<string, bool>()(minor_tick_value);
		
		}
	if  (request.countValues("AXIS_MINOR_TICK_COUNT") ) {
		int minor_tick_count_value = request("AXIS_MINOR_TICK_COUNT");
		axis_->minor_tick_count_ = minor_tick_count_value;
		}
	if  (request.countValues("AXIS_MINOR_TICK_THICKNESS") ) {
		int minor_tick_thickness_value = request("AXIS_MINOR_TICK_THICKNESS");
		axis_->minor_tick_thickness_ = minor_tick_thickness_value;
		}
	if  (request.countValues("AXIS_TIP_TITLE") ) {
		string tip_value = request("AXIS_TIP_TITLE");
		
		axis_->tip_ = MagTranslator<string, bool>()(tip_value);
		
		}
	if  (request.countValues("AXIS_TIP_TITLE_TEXT") ) {
		string tip_text_value = request("AXIS_TIP_TITLE_TEXT");
		axis_->tip_text_ = tip_text_value;
		}
	if  (request.countValues("AXIS_TIP_TITLE_HEIGHT") ) {
		double tip_height_value = request("AXIS_TIP_TITLE_HEIGHT");
		axis_->tip_height_ = tip_height_value;
		}
	if  (request.countValues("AXIS_TIP_TITLE_QUALITY") ) {
		string tip_quality_value = request("AXIS_TIP_TITLE_QUALITY");
		axis_->tip_quality_ = tip_quality_value;
		}
	
	
		string method_value = request.countValues("AXIS_TYPE") ?  (string) request("AXIS_TYPE") : "regular";
	MagLog::debug() << " AXIS_TYPE set to " << method_value << endl;
	AxisMethodWrapper* method_wrapper = 0;
	try
	{
		method_wrapper = SimpleFactory<AxisMethodWrapper>::create(method_value);
	}
	 catch (NoFactoryException&) {
		if (MagicsGlobal::strict()) {
            throw;
        }
		MagLog::warning() << "[" << method_value << "] is not a valid value for method: reset to default -> [regular]" << endl;
		method_wrapper = SimpleFactory<AxisMethodWrapper>::create("regular");
	}
	method_wrapper->set(request);
	axis_->method_ =  unique_ptr<AxisMethod>(method_wrapper->object());
	delete method_wrapper;
	if  (request.countValues("AXIS_LINE_COLOUR") ) {
		string line_colour_value = request("AXIS_LINE_COLOUR");
		axis_->line_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(line_colour_value));
	}
		
	
	if  (request.countValues("AXIS_LINE_STYLE") ) {
		string line_style_value = request("AXIS_LINE_STYLE");
		axis_->line_style_ = MagTranslator<string, LineStyle>()(line_style_value);
	}
		
	if  (request.countValues("AXIS_GRID_COLOUR") ) {
		string grid_colour_value = request("AXIS_GRID_COLOUR");
		axis_->grid_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(grid_colour_value));
	}
		
	
	if  (request.countValues("AXIS_GRID_LINE_STYLE") ) {
		string grid_style_value = request("AXIS_GRID_LINE_STYLE");
		axis_->grid_style_ = MagTranslator<string, LineStyle>()(grid_style_value);
	}
		
	if  (request.countValues("AXIS_MINOR_GRID_COLOUR") ) {
		string minor_grid_colour_value = request("AXIS_MINOR_GRID_COLOUR");
		axis_->minor_grid_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(minor_grid_colour_value));
	}
		
	
	if  (request.countValues("AXIS_MINOR_GRID_LINE_STYLE") ) {
		string minor_grid_style_value = request("AXIS_MINOR_GRID_LINE_STYLE");
		axis_->minor_grid_style_ = MagTranslator<string, LineStyle>()(minor_grid_style_value);
	}
		
	if  (request.countValues("AXIS_GRID_REFERENCE_COLOUR") ) {
		string grid_reference_colour_value = request("AXIS_GRID_REFERENCE_COLOUR");
		axis_->grid_reference_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(grid_reference_colour_value));
	}
		
	
	if  (request.countValues("AXIS_GRID_REFERENCE_LINE_STYLE") ) {
		string grid_reference_style_value = request("AXIS_GRID_REFERENCE_LINE_STYLE");
		axis_->grid_reference_style_ = MagTranslator<string, LineStyle>()(grid_reference_style_value);
	}
		
	if  (request.countValues("AXIS_TITLE_COLOUR") ) {
		string title_colour_value = request("AXIS_TITLE_COLOUR");
		axis_->title_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(title_colour_value));
	}
		
	if  (request.countValues("AXIS_TICK_COLOUR") ) {
		string tick_colour_value = request("AXIS_TICK_COLOUR");
		axis_->tick_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(tick_colour_value));
	}
		
	if  (request.countValues("AXIS_TICK_LABEL_COLOUR") ) {
		string label_colour_value = request("AXIS_TICK_LABEL_COLOUR");
		axis_->label_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(label_colour_value));
	}
		
	if  (request.countValues("AXIS_MINOR_TICK_COLOUR") ) {
		string minor_tick_colour_value = request("AXIS_MINOR_TICK_COLOUR");
		axis_->minor_tick_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(minor_tick_colour_value));
	}
		
	if  (request.countValues("AXIS_TIP_TITLE_COLOUR") ) {
		string tip_colour_value = request("AXIS_TIP_TITLE_COLOUR");
		axis_->tip_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(tip_colour_value));
	}
		
	
}

void AxisWrapper::print(ostream& out)  const
{
	out << "AxisWrapper[]";
}


#include "AxisMethodWrapper.h"

static SimpleObjectMaker<AxisMethodWrapper> Axis_axis_type_regular_Wrapper("regular");


#include "PositionListAxisMethodWrapper.h"
static SimpleObjectMaker<PositionListAxisMethod, AxisMethod> Axis_axis_type_position_list ("position_list");
static SimpleObjectMaker<PositionListAxisMethodWrapper, AxisMethodWrapper> Axis_axis_type_position_list_wrapper ("position_list");


#include "LogarithmicAxisMethodWrapper.h"
static SimpleObjectMaker<LogarithmicAxisMethod, AxisMethod> Axis_axis_type_logarithmic ("logarithmic");
static SimpleObjectMaker<LogarithmicAxisMethodWrapper, AxisMethodWrapper> Axis_axis_type_logarithmic_wrapper ("logarithmic");


#include "DateAxisMethodWrapper.h"
static SimpleObjectMaker<DateAxisMethod, AxisMethod> Axis_axis_type_date ("date");
static SimpleObjectMaker<DateAxisMethodWrapper, AxisMethodWrapper> Axis_axis_type_date_wrapper ("date");


#include "HyperAxisMethodWrapper.h"
static SimpleObjectMaker<HyperAxisMethod, AxisMethod> Axis_axis_type_geoline ("geoline");
static SimpleObjectMaker<HyperAxisMethodWrapper, AxisMethodWrapper> Axis_axis_type_geoline_wrapper ("geoline");
















