
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ValuePlotMethodAttributes.h
    \\brief Definition of ValuePlotMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "ValuePlotMethodWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


ValuePlotMethodWrapper::ValuePlotMethodWrapper(): valueplotmethod_(new ValuePlotMethod())

{

	
	
	
} 
ValuePlotMethodWrapper::ValuePlotMethodWrapper(ValuePlotMethod* valueplotmethod): valueplotmethod_(valueplotmethod)
{
	
	
} 

ValuePlotMethodWrapper::~ValuePlotMethodWrapper()
{
	
}

void ValuePlotMethodWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("CONTOUR_GRID_VALUE_MIN") ) {
		double min_value = request("CONTOUR_GRID_VALUE_MIN");
		valueplotmethod_->min_ = min_value;
		}
	if  (request.countValues("CONTOUR_GRID_VALUE_MAX") ) {
		double max_value = request("CONTOUR_GRID_VALUE_MAX");
		valueplotmethod_->max_ = max_value;
		}
	if  (request.countValues("CONTOUR_GRID_VALUE_LAT_FREQUENCY") ) {
		int lat_frequency_value = request("CONTOUR_GRID_VALUE_LAT_FREQUENCY");
		valueplotmethod_->lat_frequency_ = lat_frequency_value;
		}
	if  (request.countValues("CONTOUR_GRID_VALUE_LON_FREQUENCY") ) {
		int lon_frequency_value = request("CONTOUR_GRID_VALUE_LON_FREQUENCY");
		valueplotmethod_->lon_frequency_ = lon_frequency_value;
		}
	if  (request.countValues("CONTOUR_GRID_VALUE_HEIGHT") ) {
		double height_value = request("CONTOUR_GRID_VALUE_HEIGHT");
		valueplotmethod_->height_ = height_value;
		}
	if  (request.countValues("CONTOUR_GRID_VALUE_FORMAT") ) {
		string format_value = request("CONTOUR_GRID_VALUE_FORMAT");
		valueplotmethod_->format_ = format_value;
		}
	if  (request.countValues("CONTOUR_GRID_VALUE_QUALITY") ) {
		string quality_value = request("CONTOUR_GRID_VALUE_QUALITY");
		valueplotmethod_->quality_ = quality_value;
		}
	if  (request.countValues("CONTOUR_GRID_VALUE_VERTICAL_ALIGN") ) {
		string vertical_align_value = request("CONTOUR_GRID_VALUE_VERTICAL_ALIGN");
		valueplotmethod_->vertical_align_ = vertical_align_value;
		}
	
	if  (request.countValues("CONTOUR_GRID_VALUE_COLOUR") ) {
		string colour_value = request("CONTOUR_GRID_VALUE_COLOUR");
		valueplotmethod_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
	if  (request.countValues("CONTOUR_GRID_VALUE_JUSTIFICATION") ) {
		string justification_value = request("CONTOUR_GRID_VALUE_JUSTIFICATION");
		valueplotmethod_->justification_ = MagTranslator<string, Justification>()(justification_value);
	}
		
	
}

void ValuePlotMethodWrapper::print(ostream& out)  const
{
	out << "ValuePlotMethodWrapper[]";
}


    





