
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file FortranSceneNodeAttributes.h
    \\brief Definition of FortranSceneNode Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "FortranSceneNodeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


FortranSceneNodeWrapper::FortranSceneNodeWrapper(): fortranscenenode_(new FortranSceneNode())

{

	
	
	
} 
FortranSceneNodeWrapper::FortranSceneNodeWrapper(FortranSceneNode* fortranscenenode): fortranscenenode_(fortranscenenode)
{
	
	
} 

FortranSceneNodeWrapper::~FortranSceneNodeWrapper()
{
	
}

void FortranSceneNodeWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("PAGE_X_POSITION") ) {
		double x_value = request("PAGE_X_POSITION");
		fortranscenenode_->x_ = x_value;
		}
	if  (request.countValues("PAGE_Y_POSITION") ) {
		double y_value = request("PAGE_Y_POSITION");
		fortranscenenode_->y_ = y_value;
		}
	if  (request.countValues("PAGE_X_LENGTH") ) {
		double width_value = request("PAGE_X_LENGTH");
		fortranscenenode_->width_ = width_value;
		}
	if  (request.countValues("PAGE_Y_LENGTH") ) {
		double height_value = request("PAGE_Y_LENGTH");
		fortranscenenode_->height_ = height_value;
		}
	if  (request.countValues("PAGE_FRAME") ) {
		string frame_value = request("PAGE_FRAME");
		fortranscenenode_->frame_ = MagTranslator<string, bool>()(frame_value);
		}
	if  (request.countValues("PAGE_FRAME_THICKNESS") ) {
		int frame_thickness_value = request("PAGE_FRAME_THICKNESS");
		fortranscenenode_->frame_thickness_ = frame_thickness_value;
		}
	if  (request.countValues("LAYOUT") ) {
		string plot_layout_value = request("LAYOUT");
		fortranscenenode_->plot_layout_ = plot_layout_value;
		}
	if  (request.countValues("PLOT_START") ) {
		string plot_start_value = request("PLOT_START");
		fortranscenenode_->plot_start_ = plot_start_value;
		}
	if  (request.countValues("PLOT_DIRECTION") ) {
		string plot_direction_value = request("PLOT_DIRECTION");
		fortranscenenode_->plot_direction_ = plot_direction_value;
		}
	if  (request.countValues("PAGE_THEME") ) {
		string theme_value = request("PAGE_THEME");
		fortranscenenode_->theme_ = theme_value;
		}
	if  (request.countValues("SKINNY_MODE") ) {
		string skinny_value = request("SKINNY_MODE");
		fortranscenenode_->skinny_ = MagTranslator<string, bool>()(skinny_value);
		}
	
	if  (request.countValues("PAGE_FRAME_COLOUR") ) {
		string frame_colour_value = request("PAGE_FRAME_COLOUR");
		fortranscenenode_->frame_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(frame_colour_value));
	}
		
	
	if  (request.countValues("PAGE_FRAME_LINE_STYLE") ) {
		string frame_line_style_value = request("PAGE_FRAME_LINE_STYLE");
		fortranscenenode_->frame_line_style_ = MagTranslator<string, LineStyle>()(frame_line_style_value);
	}
		
	
		string page_id_value = request.countValues("PAGE_ID_LINE") ?  (string) request("PAGE_ID_LINE") : "on";
	MagLog::debug() << " PAGE_ID_LINE set to " << page_id_value << endl;
	NoPageIDWrapper* page_id_wrapper = 0;
	try
	{
		page_id_wrapper = SimpleFactory<NoPageIDWrapper>::create(page_id_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << page_id_value << "] is not a valid value for page_id: reset to default -> [on]" << endl;
		page_id_wrapper = SimpleFactory<NoPageIDWrapper>::create("on");
	}
	page_id_wrapper->set(request);
	fortranscenenode_->page_id_ =  unique_ptr<NoPageID>(page_id_wrapper->object());
	delete page_id_wrapper;
	
}

void FortranSceneNodeWrapper::print(ostream& out)  const
{
	out << "FortranSceneNodeWrapper[]";
}


    





#include "PageIDWrapper.h"
static SimpleObjectMaker<PageID, NoPageID> FortranSceneNode_page_id_line_on ("on");
static SimpleObjectMaker<PageIDWrapper, NoPageIDWrapper> FortranSceneNode_page_id_line_on_wrapper ("on");


#include "NoPageIDWrapper.h"

static SimpleObjectMaker<NoPageIDWrapper> FortranSceneNode_page_id_line_off_Wrapper("off");



