
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file XmlRootNodeAttributes.h
    \\brief Definition of XmlRootNode Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "XmlRootNodeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


XmlRootNodeWrapper::XmlRootNodeWrapper(): xmlrootnode_(new XmlRootNode())

{

	
	
	
} 
XmlRootNodeWrapper::XmlRootNodeWrapper(XmlRootNode* xmlrootnode): xmlrootnode_(xmlrootnode)
{
	
	
} 

XmlRootNodeWrapper::~XmlRootNodeWrapper()
{
	
}

void XmlRootNodeWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("ROOT_NODE_FORMAT") ) {
		string format_value = request("ROOT_NODE_FORMAT");
		xmlrootnode_->format_ = format_value;
		}
	if  (request.countValues("ROOT_NODE_ORIENTATION") ) {
		string orientation_value = request("ROOT_NODE_ORIENTATION");
		xmlrootnode_->orientation_ = orientation_value;
		}
	if  (request.countValues("ROOT_NODE_WIDTH") ) {
		double width_value = request("ROOT_NODE_WIDTH");
		xmlrootnode_->width_ = width_value;
		}
	if  (request.countValues("ROOT_NODE_HEIGHT") ) {
		double height_value = request("ROOT_NODE_HEIGHT");
		xmlrootnode_->height_ = height_value;
		}
	if  (request.countValues("ROOT_NODE_FRAME") ) {
		string border_value = request("ROOT_NODE_FRAME");
		xmlrootnode_->border_ = MagTranslator<string, bool>()(border_value);
		}
	if  (request.countValues("ROOT_NODE_FRAME_THICKNESS") ) {
		int border_thickness_value = request("ROOT_NODE_FRAME_THICKNESS");
		xmlrootnode_->border_thickness_ = border_thickness_value;
		}
	if  (request.countValues("ROOT_NODE_APPLICATION") ) {
		string application_value = request("ROOT_NODE_APPLICATION");
		xmlrootnode_->application_ = application_value;
		}
	
	if  (request.countValues("ROOT_NODE_FRAME_COLOUR") ) {
		string border_colour_value = request("ROOT_NODE_FRAME_COLOUR");
		xmlrootnode_->border_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(border_colour_value));
	}
		
	
	if  (request.countValues("ROOT_NODE_FRAME_LINE_STYLE") ) {
		string border_style_value = request("ROOT_NODE_FRAME_LINE_STYLE");
		xmlrootnode_->border_style_ = MagTranslator<string, LineStyle>()(border_style_value);
	}
		
	
}

void XmlRootNodeWrapper::print(ostream& out)  const
{
	out << "XmlRootNodeWrapper[]";
}


    





