
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file NoCoastPlottingAttributes.h
    \\brief Definition of NoCoastPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "NoCoastPlottingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

NoCoastPlottingAttributes::NoCoastPlottingAttributes():
	resolution_(ParameterManager::getString("map_coastline_resolution")),
	land_(ParameterManager::getBool("map_coastline_land_shade")),
	sea_(ParameterManager::getBool("map_coastline_sea_shade")),
	preview_(ParameterManager::getBool("map_preview")),
	rivers_(ParameterManager::getString("map_rivers")),
	rivers_thickness_(ParameterManager::getInt("map_rivers_thickness")),
	efas_(ParameterManager::getString("map_efas")),
	efas_domain_(ParameterManager::getString("map_efas_domain")),
	efas_thickness_(ParameterManager::getInt("map_efas_thickness")),
	user_layer_(ParameterManager::getString("map_user_layer")),
	user_layer_name_(ParameterManager::getString("map_user_layer_name")),
	user_layer_projection_(ParameterManager::getString("map_user_layer_projection")),
	user_layer_thickness_(ParameterManager::getInt("map_user_layer_thickness"))
	,
	land_colour_(MagTranslator<string, Colour>().magics("map_coastline_land_shade_colour")),
	sea_colour_(MagTranslator<string, Colour>().magics("map_coastline_sea_shade_colour")),
	boundaries_(MagTranslator<string, NoBoundaries>().magics("map_boundaries")),
	cities_(MagTranslator<string, NoCities>().magics("map_cities")),
	rivers_style_(MagTranslator<string, LineStyle>().magics("map_rivers_style")),
	rivers_colour_(MagTranslator<string, Colour>().magics("map_rivers_colour")),
	efas_style_(MagTranslator<string, LineStyle>().magics("map_efas_style")),
	efas_colour_(MagTranslator<string, Colour>().magics("map_efas_colour")),
	user_layer_style_(MagTranslator<string, LineStyle>().magics("map_user_layer_style")),
	user_layer_colour_(MagTranslator<string, Colour>().magics("map_user_layer_colour"))
	 
{
} 


NoCoastPlottingAttributes::~NoCoastPlottingAttributes()
{
	
}

    
void NoCoastPlottingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "map";
	prefix[i++] = "map_coastline";
	
	setAttribute(prefix, "map_coastline_resolution", resolution_, params);
	setAttribute(prefix, "map_coastline_land_shade", land_, params);
	setAttribute(prefix, "map_coastline_sea_shade", sea_, params);
	setAttribute(prefix, "map_preview", preview_, params);
	setAttribute(prefix, "map_rivers", rivers_, params);
	setAttribute(prefix, "map_rivers_thickness", rivers_thickness_, params);
	setAttribute(prefix, "map_efas", efas_, params);
	setAttribute(prefix, "map_efas_domain", efas_domain_, params);
	setAttribute(prefix, "map_efas_thickness", efas_thickness_, params);
	setAttribute(prefix, "map_user_layer", user_layer_, params);
	setAttribute(prefix, "map_user_layer_name", user_layer_name_, params);
	setAttribute(prefix, "map_user_layer_projection", user_layer_projection_, params);
	setAttribute(prefix, "map_user_layer_thickness", user_layer_thickness_, params);
	
	setMember(prefix, "map_coastline_land_shade_colour", land_colour_, params);
	setMember(prefix, "map_coastline_sea_shade_colour", sea_colour_, params);
	setMember(prefix, "map_boundaries", boundaries_, params);
	setMember(prefix, "map_cities", cities_, params);
	setAttribute(prefix, "map_rivers_style", rivers_style_, params);
	setMember(prefix, "map_rivers_colour", rivers_colour_, params);
	setAttribute(prefix, "map_efas_style", efas_style_, params);
	setMember(prefix, "map_efas_colour", efas_colour_, params);
	setAttribute(prefix, "map_user_layer_style", user_layer_style_, params);
	setMember(prefix, "map_user_layer_colour", user_layer_colour_, params);
	
}

void NoCoastPlottingAttributes::copy(const NoCoastPlottingAttributes& other)
{
	resolution_ = other.resolution_;
	land_ = other.land_;
	sea_ = other.sea_;
	preview_ = other.preview_;
	rivers_ = other.rivers_;
	rivers_thickness_ = other.rivers_thickness_;
	efas_ = other.efas_;
	efas_domain_ = other.efas_domain_;
	efas_thickness_ = other.efas_thickness_;
	user_layer_ = other.user_layer_;
	user_layer_name_ = other.user_layer_name_;
	user_layer_projection_ = other.user_layer_projection_;
	user_layer_thickness_ = other.user_layer_thickness_;
	land_colour_ = unique_ptr<Colour>(other.land_colour_->clone());
	sea_colour_ = unique_ptr<Colour>(other.sea_colour_->clone());
	boundaries_ = unique_ptr<NoBoundaries>(other.boundaries_->clone());
	cities_ = unique_ptr<NoCities>(other.cities_->clone());
	rivers_style_ = other.rivers_style_;
	rivers_colour_ = unique_ptr<Colour>(other.rivers_colour_->clone());
	efas_style_ = other.efas_style_;
	efas_colour_ = unique_ptr<Colour>(other.efas_colour_->clone());
	user_layer_style_ = other.user_layer_style_;
	user_layer_colour_ = unique_ptr<Colour>(other.user_layer_colour_->clone());
	
} 


bool NoCoastPlottingAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "coast")  )
		return true;
	if ( acceptNode(node, boundaries_) )
		return true;
	if ( acceptNode(node, cities_) )
		return true;
	
	return false;
}

void NoCoastPlottingAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "coast")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), boundaries_, node);
		setMember(node.name(), cities_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), boundaries_, *elt); 
		setMember(elt->name(), cities_, *elt); 
		
	}
}

void NoCoastPlottingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " resolution = " <<  resolution_;
	out << " land = " <<  land_;
	out << " sea = " <<  sea_;
	out << " preview = " <<  preview_;
	out << " rivers = " <<  rivers_;
	out << " rivers_thickness = " <<  rivers_thickness_;
	out << " efas = " <<  efas_;
	out << " efas_domain = " <<  efas_domain_;
	out << " efas_thickness = " <<  efas_thickness_;
	out << " user_layer = " <<  user_layer_;
	out << " user_layer_name = " <<  user_layer_name_;
	out << " user_layer_projection = " <<  user_layer_projection_;
	out << " user_layer_thickness = " <<  user_layer_thickness_;
	out << " land_colour = " <<  *land_colour_;
	out << " sea_colour = " <<  *sea_colour_;
	out << " boundaries = " <<  *boundaries_;
	out << " cities = " <<  *cities_;
	out << " rivers_style = " <<  rivers_style_;
	out << " rivers_colour = " <<  *rivers_colour_;
	out << " efas_style = " <<  efas_style_;
	out << " efas_colour = " <<  *efas_colour_;
	out << " user_layer_style = " <<  user_layer_style_;
	out << " user_layer_colour = " <<  *user_layer_colour_;
	
	out << "]" << "\n";
}

void NoCoastPlottingAttributes::toxml(ostream& out)  const
{
	out <<  "\"coast\""; 
	out << ", \"map_coastline_resolution\":";
	niceprint(out,resolution_);
	out << ", \"map_coastline_land_shade\":";
	niceprint(out,land_);
	out << ", \"map_coastline_sea_shade\":";
	niceprint(out,sea_);
	out << ", \"map_preview\":";
	niceprint(out,preview_);
	out << ", \"map_rivers\":";
	niceprint(out,rivers_);
	out << ", \"map_rivers_thickness\":";
	niceprint(out,rivers_thickness_);
	out << ", \"map_efas\":";
	niceprint(out,efas_);
	out << ", \"map_efas_domain\":";
	niceprint(out,efas_domain_);
	out << ", \"map_efas_thickness\":";
	niceprint(out,efas_thickness_);
	out << ", \"map_user_layer\":";
	niceprint(out,user_layer_);
	out << ", \"map_user_layer_name\":";
	niceprint(out,user_layer_name_);
	out << ", \"map_user_layer_projection\":";
	niceprint(out,user_layer_projection_);
	out << ", \"map_user_layer_thickness\":";
	niceprint(out,user_layer_thickness_);
	out << ", \"map_coastline_land_shade_colour\":";
	niceprint(out, *land_colour_);
	out << ", \"map_coastline_sea_shade_colour\":";
	niceprint(out, *sea_colour_);
	out << ", \"map_boundaries\":";
	boundaries_->toxml(out);
	out << ", \"map_cities\":";
	cities_->toxml(out);
	out << ", \"map_rivers_style\":";
	niceprint(out, rivers_style_);
	out << ", \"map_rivers_colour\":";
	niceprint(out, *rivers_colour_);
	out << ", \"map_efas_style\":";
	niceprint(out, efas_style_);
	out << ", \"map_efas_colour\":";
	niceprint(out, *efas_colour_);
	out << ", \"map_user_layer_style\":";
	niceprint(out, user_layer_style_);
	out << ", \"map_user_layer_colour\":";
	niceprint(out, *user_layer_colour_);
	
}

static MagicsParameter<string> map_coastline_resolution("map_coastline_resolution", "automatic", "");
static MagicsParameter<string> map_coastline_land_shade("map_coastline_land_shade", "off", "");
static MagicsParameter<string> map_coastline_sea_shade("map_coastline_sea_shade", "off", "");
static MagicsParameter<string> map_preview("map_preview", "off", "");
static MagicsParameter<string> map_rivers("map_rivers", "off", "");
static MagicsParameter<int> map_rivers_thickness("map_rivers_thickness", 1, "");
static MagicsParameter<string> map_efas("map_efas", "off", "");
static MagicsParameter<string> map_efas_domain("map_efas_domain", "current", "");
static MagicsParameter<int> map_efas_thickness("map_efas_thickness", 1, "");
static MagicsParameter<string> map_user_layer("map_user_layer", "off", "");
static MagicsParameter<string> map_user_layer_name("map_user_layer_name", "", "");
static MagicsParameter<string> map_user_layer_projection("map_user_layer_projection", "", "");
static MagicsParameter<int> map_user_layer_thickness("map_user_layer_thickness", 1, "");
static MagicsParameter<string> map_coastline_land_shade_colour("map_coastline_land_shade_colour", "green", ""); 
static MagicsParameter<string> map_coastline_sea_shade_colour("map_coastline_sea_shade_colour", "blue", ""); 
static MagicsParameter<string> map_boundaries("map_boundaries", "off", ""); 
static MagicsParameter<string> map_cities("map_cities", "off", ""); 
static MagicsParameter<string> map_rivers_style("map_rivers_style", "solid", ""); 
static MagicsParameter<string> map_rivers_colour("map_rivers_colour", "blue", ""); 
static MagicsParameter<string> map_efas_style("map_efas_style", "solid", ""); 
static MagicsParameter<string> map_efas_colour("map_efas_colour", "blue", ""); 
static MagicsParameter<string> map_user_layer_style("map_user_layer_style", "solid", ""); 
static MagicsParameter<string> map_user_layer_colour("map_user_layer_colour", "blue", ""); 
#include "Boundaries.h"
static SimpleObjectMaker<Boundaries , NoBoundaries> boundaries_Boundaries("boundaries");
static SimpleObjectMaker<Boundaries , NoBoundaries> on_Boundaries("on");
static SimpleObjectMaker<NoBoundaries , NoBoundaries> noboundaries_NoBoundaries("noboundaries");
static SimpleObjectMaker<NoBoundaries , NoBoundaries> off_NoBoundaries("off");
static SimpleObjectMaker<Cities , NoCities> cities_Cities("cities");
static SimpleObjectMaker<Cities , NoCities> on_Cities("on");
static SimpleObjectMaker<NoCities , NoCities> nocities_NoCities("nocities");
static SimpleObjectMaker<NoCities , NoCities> off_NoCities("off");
