
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MetgramGraphAttributes.h
    \\brief Definition of MetgramGraph Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "MetgramGraphWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


MetgramGraphWrapper::MetgramGraphWrapper(): metgramgraph_(new MetgramGraph())

{

	
	
	
} 
MetgramGraphWrapper::MetgramGraphWrapper(MetgramGraph* metgramgraph): metgramgraph_(metgramgraph)
{
	
	
} 

MetgramGraphWrapper::~MetgramGraphWrapper()
{
	
}

void MetgramGraphWrapper::set(const MagRequest& request)
{
	
	

	
	
		string style_value = request.countValues("METGRAM_PLOT_STYLE") ?  (string) request("METGRAM_PLOT_STYLE") : "curve";
	MagLog::debug() << " METGRAM_PLOT_STYLE set to " << style_value << endl;
	MetgramStyleWrapper* style_wrapper = 0;
#ifdef MAGICS_EXCEPTION
	try
#endif
	{
		style_wrapper = SimpleFactory<MetgramStyleWrapper>::create(style_value);
	}
#ifdef MAGICS_EXCEPTION
	 catch (NoFactoryException) {
#else
	 if (!style_wrapper) {
#endif
		MagLog::warning() << "[" << style_value << "] is not a valid value for style: reset to default -> [curve]" << endl;
		style_wrapper = SimpleFactory<MetgramStyleWrapper>::create("curve");
	}
	style_wrapper->set(request);
	metgramgraph_->style_ =  unique_ptr<MetgramStyle>(style_wrapper->object());
	delete style_wrapper;
	
}

void MetgramGraphWrapper::print(ostream& out)  const
{
	out << "MetgramGraphWrapper[]";
}


    



#include "MetgramBarWrapper.h"
static SimpleObjectMaker<MetgramBar, MetgramStyle> MetgramGraph_metgram_plot_style_bar ("bar");
static SimpleObjectMaker<MetgramBarWrapper, MetgramStyleWrapper> MetgramGraph_metgram_plot_style_bar_wrapper ("bar");


#include "MetgramFlagsWrapper.h"
static SimpleObjectMaker<MetgramFlags, MetgramStyle> MetgramGraph_metgram_plot_style_flags ("flags");
static SimpleObjectMaker<MetgramFlagsWrapper, MetgramStyleWrapper> MetgramGraph_metgram_plot_style_flags_wrapper ("flags");


#include "MetgramCurveWrapper.h"
static SimpleObjectMaker<MetgramCurve, MetgramStyle> MetgramGraph_metgram_plot_style_curve ("curve");
static SimpleObjectMaker<MetgramCurveWrapper, MetgramStyleWrapper> MetgramGraph_metgram_plot_style_curve_wrapper ("curve");



