
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file LandgramBoxAttributes.h
    \\brief Definition of LandgramBox Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "LandgramBoxWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


LandgramBoxWrapper::LandgramBoxWrapper(): landgrambox_(new LandgramBox())

{

	
	
	
} 
LandgramBoxWrapper::LandgramBoxWrapper(LandgramBox* landgrambox): landgrambox_(landgrambox)
{
	
	
} 

LandgramBoxWrapper::~LandgramBoxWrapper()
{
	
}

void LandgramBoxWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("LANDGRAM_WIDTH") ) {
		double width_value = request("LANDGRAM_WIDTH");
		landgrambox_->width_ = width_value;
		}
	if  (request.countValues("LANDGRAM_TOP_BOX1_SHADING") ) {
		string top1_shading_value = request("LANDGRAM_TOP_BOX1_SHADING");
		landgrambox_->top1_shading_ = top1_shading_value;
		}
	if  (request.countValues("LANDGRAM_TOP_BOX2_SHADING") ) {
		string top2_shading_value = request("LANDGRAM_TOP_BOX2_SHADING");
		landgrambox_->top2_shading_ = top2_shading_value;
		}
	if  (request.countValues("LANDGRAM_BOTTOM_BOX1_SHADING") ) {
		string bottom1_shading_value = request("LANDGRAM_BOTTOM_BOX1_SHADING");
		landgrambox_->bottom1_shading_ = bottom1_shading_value;
		}
	if  (request.countValues("LANDGRAM_BOTTOM_BOX2_SHADING") ) {
		string bottom2_shading_value = request("LANDGRAM_BOTTOM_BOX2_SHADING");
		landgrambox_->bottom2_shading_ = bottom2_shading_value;
		}
	
	if  (request.countValues("LANDGRAM_TOP_BOX1_COLOUR") ) {
		string top1_colour_value = request("LANDGRAM_TOP_BOX1_COLOUR");
		landgrambox_->top1_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(top1_colour_value));
	}
		
	if  (request.countValues("LANDGRAM_TOP_BOX2_COLOUR") ) {
		string top2_colour_value = request("LANDGRAM_TOP_BOX2_COLOUR");
		landgrambox_->top2_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(top2_colour_value));
	}
		
	if  (request.countValues("LANDGRAM_BOTTOM_BOX1_COLOUR") ) {
		string bottom1_colour_value = request("LANDGRAM_BOTTOM_BOX1_COLOUR");
		landgrambox_->bottom1_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(bottom1_colour_value));
	}
		
	if  (request.countValues("LANDGRAM_BOTTOM_BOX2_COLOUR") ) {
		string bottom2_colour_value = request("LANDGRAM_BOTTOM_BOX2_COLOUR");
		landgrambox_->bottom2_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(bottom2_colour_value));
	}
		
	
}

void LandgramBoxWrapper::print(ostream& out)  const
{
	out << "LandgramBoxWrapper[]";
}


    







