
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ImportPlotAttributes.h
    \\brief Definition of ImportPlot Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "ImportPlotWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


ImportPlotWrapper::ImportPlotWrapper(): importplot_(new ImportPlot())

{

	
	
	
} 
ImportPlotWrapper::ImportPlotWrapper(ImportPlot* importplot): importplot_(importplot)
{
	
	
} 

ImportPlotWrapper::~ImportPlotWrapper()
{
	
}

void ImportPlotWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("IMPORT_FORMAT") ) {
		string format_value = request("IMPORT_FORMAT");
		importplot_->format_ = format_value;
		}
	if  (request.countValues("IMPORT_SYSTEM_COORDINATES") ) {
		string system_value = request("IMPORT_SYSTEM_COORDINATES");
		importplot_->system_ = system_value;
		}
	if  (request.countValues("IMPORT_X_POSITION") ) {
		double x_value = request("IMPORT_X_POSITION");
		importplot_->x_ = x_value;
		}
	if  (request.countValues("IMPORT_Y_POSITION") ) {
		double y_value = request("IMPORT_Y_POSITION");
		importplot_->y_ = y_value;
		}
	if  (request.countValues("IMPORT_WIDTH") ) {
		double width_value = request("IMPORT_WIDTH");
		importplot_->width_ = width_value;
		}
	if  (request.countValues("CRS") ) {
		string crs_value = request("CRS");
		importplot_->crs_ = crs_value;
		}
	if  (request.countValues("CRS_MINX") ) {
		double crs_minx_value = request("CRS_MINX");
		importplot_->crs_minx_ = crs_minx_value;
		}
	if  (request.countValues("CRS_MAXX") ) {
		double crs_maxx_value = request("CRS_MAXX");
		importplot_->crs_maxx_ = crs_maxx_value;
		}
	if  (request.countValues("CRS_MINY") ) {
		double crs_miny_value = request("CRS_MINY");
		importplot_->crs_miny_ = crs_miny_value;
		}
	if  (request.countValues("CRS_MAXY") ) {
		double crs_maxy_value = request("CRS_MAXY");
		importplot_->crs_maxy_ = crs_maxy_value;
		}
	if  (request.countValues("IMPORT_HEIGHT") ) {
		double height_value = request("IMPORT_HEIGHT");
		importplot_->height_ = height_value;
		}
	
	
}

void ImportPlotWrapper::print(ostream& out)  const
{
	out << "ImportPlotWrapper[]";
}


    



