
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GridShadingAttributes.h
    \\brief Definition of GridShading Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "GridShadingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

GridShadingAttributes::GridShadingAttributes():
	position_(ParameterManager::getString("contour_grid_shading_position"))
	
	 
{
} 


GridShadingAttributes::~GridShadingAttributes()
{
	
}

    
void GridShadingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "contour_grid_shading_position", position_, params);
	
	
}

void GridShadingAttributes::copy(const GridShadingAttributes& other)
{
	position_ = other.position_;
	
} 


bool GridShadingAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void GridShadingAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void GridShadingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " position = " <<  position_;
	
	out << "]" << "\n";
}

void GridShadingAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"contour_grid_shading_position\":";
	niceprint(out,position_);
	
}

static MagicsParameter<string> contour_grid_shading_position("contour_grid_shading_position", "middle", "");
