
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BoxPlotWhiskerBoxAttributes.h
    \\brief Definition of BoxPlotWhiskerBox Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "BoxPlotWhiskerBoxWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


BoxPlotWhiskerBoxWrapper::BoxPlotWhiskerBoxWrapper(): boxplotwhiskerbox_(new BoxPlotWhiskerBox())

{

	
	
	
} 
BoxPlotWhiskerBoxWrapper::BoxPlotWhiskerBoxWrapper(BoxPlotWhiskerBox* boxplotwhiskerbox): boxplotwhiskerbox_(boxplotwhiskerbox)
{
	
	
} 

BoxPlotWhiskerBoxWrapper::~BoxPlotWhiskerBoxWrapper()
{
	
}

void BoxPlotWhiskerBoxWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("BOXPLOT_WHISKER_BOX_WIDTH") ) {
		double width_value = request("BOXPLOT_WHISKER_BOX_WIDTH");
		boxplotwhiskerbox_->width_ = width_value;
		}
	
	if  (request.countValues("BOXPLOT_WHISKER_BOX_COLOUR") ) {
		string colour_value = request("BOXPLOT_WHISKER_BOX_COLOUR");
		boxplotwhiskerbox_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
		string border_value = request.countValues("BOXPLOT_WHISKER_BOX_BORDER") ?  (string) request("BOXPLOT_WHISKER_BOX_BORDER") : "on";
	MagLog::debug() << " BOXPLOT_WHISKER_BOX_BORDER set to " << border_value << endl;
	NoBoxPlotWhiskerBorderWrapper* border_wrapper = 0;
#ifdef MAGICS_EXCEPTION
	try
#endif
	{
		border_wrapper = SimpleFactory<NoBoxPlotWhiskerBorderWrapper>::create(border_value);
	}
#ifdef MAGICS_EXCEPTION
	 catch (NoFactoryException) {
#else
	 if (!border_wrapper) {
#endif
		MagLog::warning() << "[" << border_value << "] is not a valid value for border: reset to default -> [on]" << endl;
		border_wrapper = SimpleFactory<NoBoxPlotWhiskerBorderWrapper>::create("on");
	}
	border_wrapper->set(request);
	boxplotwhiskerbox_->border_ =  unique_ptr<NoBoxPlotWhiskerBorder>(border_wrapper->object());
	delete border_wrapper;
	
}

void BoxPlotWhiskerBoxWrapper::print(ostream& out)  const
{
	out << "BoxPlotWhiskerBoxWrapper[]";
}


    




#include "BoxPlotWhiskerBorderWrapper.h"
static SimpleObjectMaker<BoxPlotWhiskerBorder, NoBoxPlotWhiskerBorder> BoxPlotWhiskerBox_boxplot_whisker_box_border_border ("border");
static SimpleObjectMaker<BoxPlotWhiskerBorderWrapper, NoBoxPlotWhiskerBorderWrapper> BoxPlotWhiskerBox_boxplot_whisker_box_border_border_wrapper ("border");


#include "BoxPlotWhiskerBorderWrapper.h"
static SimpleObjectMaker<BoxPlotWhiskerBorder, NoBoxPlotWhiskerBorder> BoxPlotWhiskerBox_boxplot_whisker_box_border_on ("on");
static SimpleObjectMaker<BoxPlotWhiskerBorderWrapper, NoBoxPlotWhiskerBorderWrapper> BoxPlotWhiskerBox_boxplot_whisker_box_border_on_wrapper ("on");


#include "NoBoxPlotWhiskerBorderWrapper.h"

static SimpleObjectMaker<NoBoxPlotWhiskerBorderWrapper> BoxPlotWhiskerBox_boxplot_whisker_box_border_noborder_Wrapper("noborder");


#include "NoBoxPlotWhiskerBorderWrapper.h"

static SimpleObjectMaker<NoBoxPlotWhiskerBorderWrapper> BoxPlotWhiskerBox_boxplot_whisker_box_border_off_Wrapper("off");



