
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BarAttributes.h
    \\brief Definition of Bar Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "BarAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

BarAttributes::BarAttributes():
	orientation_(ParameterManager::getString("graph_bar_orientation")),
	width_(ParameterManager::getDouble("graph_bar_width")),
	bar_style_(ParameterManager::getString("graph_bar_style")),
	thickness_(ParameterManager::getInt("graph_bar_line_thickness")),
	clipping_(ParameterManager::getBool("graph_bar_clipping")),
	annotation_(ParameterManager::getStringArray("graph_bar_annotation")),
	annotation_size_(ParameterManager::getDouble("graph_bar_annotation_font_size")),
	min_value_(ParameterManager::getDouble("graph_bar_minimum_value"))
	,
	justification_(MagTranslator<string, Justification>().magics("graph_bar_justification")),
	style_(MagTranslator<string, LineStyle>().magics("graph_bar_line_style")),
	line_colour_(MagTranslator<string, Colour>().magics("graph_bar_line_colour")),
	colour_(MagTranslator<string, Colour>().magics("graph_bar_colour")),
	shade_(MagTranslator<string, GraphShade>().magics("graph_shade")),
	annotation_colour_(MagTranslator<string, Colour>().magics("graph_bar_annotation_font_colour"))
	 
{
} 


BarAttributes::~BarAttributes()
{
	
}

    
void BarAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "graph_bar_orientation", orientation_, params);
	setAttribute(prefix, "graph_bar_width", width_, params);
	setAttribute(prefix, "graph_bar_style", bar_style_, params);
	setAttribute(prefix, "graph_bar_line_thickness", thickness_, params);
	setAttribute(prefix, "graph_bar_clipping", clipping_, params);
	setAttribute(prefix, "graph_bar_annotation", annotation_, params);
	setAttribute(prefix, "graph_bar_annotation_font_size", annotation_size_, params);
	setAttribute(prefix, "graph_bar_minimum_value", min_value_, params);
	
	setAttribute(prefix, "graph_bar_justification", justification_, params);
	setAttribute(prefix, "graph_bar_line_style", style_, params);
	setMember(prefix, "graph_bar_line_colour", line_colour_, params);
	setMember(prefix, "graph_bar_colour", colour_, params);
	setMember(prefix, "graph_shade", shade_, params);
	setMember(prefix, "graph_bar_annotation_font_colour", annotation_colour_, params);
	
}

void BarAttributes::copy(const BarAttributes& other)
{
	orientation_ = other.orientation_;
	width_ = other.width_;
	bar_style_ = other.bar_style_;
	thickness_ = other.thickness_;
	clipping_ = other.clipping_;
	annotation_ = other.annotation_;
	annotation_size_ = other.annotation_size_;
	min_value_ = other.min_value_;
	justification_ = other.justification_;
	style_ = other.style_;
	line_colour_ = unique_ptr<Colour>(other.line_colour_->clone());
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	shade_ = unique_ptr<GraphShade>(other.shade_->clone());
	annotation_colour_ = unique_ptr<Colour>(other.annotation_colour_->clone());
	
} 


bool BarAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "bar")  )
		return true;
	if ( acceptNode(node, shade_) )
		return true;
	
	return false;
}

void BarAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "bar")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), shade_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), shade_, *elt); 
		
	}
}

void BarAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " orientation = " <<  orientation_;
	out << " width = " <<  width_;
	out << " bar_style = " <<  bar_style_;
	out << " thickness = " <<  thickness_;
	out << " clipping = " <<  clipping_;
	out << " annotation = " <<  annotation_;
	out << " annotation_size = " <<  annotation_size_;
	out << " min_value = " <<  min_value_;
	out << " justification = " <<  justification_;
	out << " style = " <<  style_;
	out << " line_colour = " <<  *line_colour_;
	out << " colour = " <<  *colour_;
	out << " shade = " <<  *shade_;
	out << " annotation_colour = " <<  *annotation_colour_;
	
	out << "]" << "\n";
}

void BarAttributes::toxml(ostream& out)  const
{
	out <<  "\"bar\""; 
	out << ", \"graph_bar_orientation\":";
	niceprint(out,orientation_);
	out << ", \"graph_bar_width\":";
	niceprint(out,width_);
	out << ", \"graph_bar_style\":";
	niceprint(out,bar_style_);
	out << ", \"graph_bar_line_thickness\":";
	niceprint(out,thickness_);
	out << ", \"graph_bar_clipping\":";
	niceprint(out,clipping_);
	out << ", \"graph_bar_annotation\":";
	niceprint(out,annotation_);
	out << ", \"graph_bar_annotation_font_size\":";
	niceprint(out,annotation_size_);
	out << ", \"graph_bar_minimum_value\":";
	niceprint(out,min_value_);
	out << ", \"graph_bar_justification\":";
	niceprint(out, justification_);
	out << ", \"graph_bar_line_style\":";
	niceprint(out, style_);
	out << ", \"graph_bar_line_colour\":";
	niceprint(out, *line_colour_);
	out << ", \"graph_bar_colour\":";
	niceprint(out, *colour_);
	out << ", \"graph_shade\":";
	shade_->toxml(out);
	out << ", \"graph_bar_annotation_font_colour\":";
	niceprint(out, *annotation_colour_);
	
}

static MagicsParameter<string> graph_bar_orientation("graph_bar_orientation", "vertical", "");
static MagicsParameter<double> graph_bar_width("graph_bar_width", -1, "");
static MagicsParameter<string> graph_bar_style("graph_bar_style", "bar", "");
static MagicsParameter<int> graph_bar_line_thickness("graph_bar_line_thickness", 1, "");
static MagicsParameter<string> graph_bar_clipping("graph_bar_clipping", "on", "");
static MagicsParameter<stringarray> graph_bar_annotation("graph_bar_annotation", stringarray(), "");
static MagicsParameter<double> graph_bar_annotation_font_size("graph_bar_annotation_font_size", 0.25, "");
static MagicsParameter<double> graph_bar_minimum_value("graph_bar_minimum_value", INT_MAX, "");
static MagicsParameter<string> graph_bar_justification("graph_bar_justification", "centre", ""); 
static MagicsParameter<string> graph_bar_line_style("graph_bar_line_style", "solid", ""); 
static MagicsParameter<string> graph_bar_line_colour("graph_bar_line_colour", "black", ""); 
static MagicsParameter<string> graph_bar_colour("graph_bar_colour", "blue", ""); 
static MagicsParameter<string> graph_shade("graph_shade", "on", ""); 
static MagicsParameter<string> graph_bar_annotation_font_colour("graph_bar_annotation_font_colour", "red", ""); 
#include "GraphShade.h"
static SimpleObjectMaker<GraphShade , GraphShade> shading_GraphShade("shading");
static SimpleObjectMaker<GraphShade , GraphShade> on_GraphShade("on");
static SimpleObjectMaker<NoGraphShade , GraphShade> noshading_NoGraphShade("noshading");
static SimpleObjectMaker<NoGraphShade , GraphShade> off_NoGraphShade("off");
