
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ArrowPlottingAttributes.h
    \\brief Definition of ArrowPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "ArrowPlottingWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


ArrowPlottingWrapper::ArrowPlottingWrapper(): arrowplotting_(new ArrowPlotting())

{

	
	
	WindPlottingWrapper::object(arrowplotting_);
	
	
} 
ArrowPlottingWrapper::ArrowPlottingWrapper(ArrowPlotting* arrowplotting): arrowplotting_(arrowplotting)
{
	
	
	WindPlottingWrapper::object(arrowplotting_);
	
} 

ArrowPlottingWrapper::~ArrowPlottingWrapper()
{
	
}

void ArrowPlottingWrapper::set(const MagRequest& request)
{
	
	
	
	WindPlottingWrapper::set(request);
	

	if  (request.countValues("WIND_ARROW_CALM_INDICATOR_SIZE") ) {
		double calm_indicator_size_value = request("WIND_ARROW_CALM_INDICATOR_SIZE");
		arrowplotting_->calm_indicator_size_ = calm_indicator_size_value;
		}
	if  (request.countValues("WIND_ARROW_CALM_BELOW") ) {
		double calm_below_value = request("WIND_ARROW_CALM_BELOW");
		arrowplotting_->calm_below_ = calm_below_value;
		}
	if  (request.countValues("WIND_ARROW_HEAD_SHAPE") ) {
		int head_value = request("WIND_ARROW_HEAD_SHAPE");
		arrowplotting_->head_ = head_value;
		}
	if  (request.countValues("WIND_ARROW_HEAD_RATIO") ) {
		double ratio_value = request("WIND_ARROW_HEAD_RATIO");
		arrowplotting_->ratio_ = ratio_value;
		}
	if  (request.countValues("WIND_ARROW_MAX_SPEED") ) {
		double max_speed_value = request("WIND_ARROW_MAX_SPEED");
		arrowplotting_->max_speed_ = max_speed_value;
		}
	if  (request.countValues("WIND_ARROW_MIN_SPEED") ) {
		double min_speed_value = request("WIND_ARROW_MIN_SPEED");
		arrowplotting_->min_speed_ = min_speed_value;
		}
	if  (request.countValues("WIND_ARROW_THICKNESS") ) {
		int thickness_value = request("WIND_ARROW_THICKNESS");
		arrowplotting_->thickness_ = thickness_value;
		}
	if  (request.countValues("WIND_ARROW_UNIT_SYSTEM") ) {
		string unit_system_value = request("WIND_ARROW_UNIT_SYSTEM");
		arrowplotting_->unit_system_ = unit_system_value;
		}
	if  (request.countValues("WIND_ARROW_UNIT_VELOCITY") ) {
		double unit_velocity_value = request("WIND_ARROW_UNIT_VELOCITY");
		arrowplotting_->unit_velocity_ = unit_velocity_value;
		}
	if  (request.countValues("WIND_ARROW_LEGEND_TEXT") ) {
		string legend_unit_value = request("WIND_ARROW_LEGEND_TEXT");
		arrowplotting_->legend_unit_ = legend_unit_value;
		}
	if  (request.countValues("WIND_ARROW_FIXED_VELOCITY") ) {
		double fixed_velocity_value = request("WIND_ARROW_FIXED_VELOCITY");
		arrowplotting_->fixed_velocity_ = fixed_velocity_value;
		}
	
	
		string calm_value = request.countValues("WIND_ARROW_CALM_INDICATOR") ?  (string) request("WIND_ARROW_CALM_INDICATOR") : "off";
	MagLog::debug() << " WIND_ARROW_CALM_INDICATOR set to " << calm_value << endl;
	CalmIndicatorWrapper* calm_wrapper = 0;
#ifdef MAGICS_EXCEPTION
	try
#endif
	{
		calm_wrapper = SimpleFactory<CalmIndicatorWrapper>::create(calm_value);
	}
#ifdef MAGICS_EXCEPTION
	 catch (NoFactoryException) {
#else
	 if (!calm_wrapper) {
#endif
		MagLog::warning() << "[" << calm_value << "] is not a valid value for calm: reset to default -> [off]" << endl;
		calm_wrapper = SimpleFactory<CalmIndicatorWrapper>::create("off");
	}
	calm_wrapper->set(request);
	arrowplotting_->calm_ =  unique_ptr<CalmIndicator>(calm_wrapper->object());
	delete calm_wrapper;
	if  (request.countValues("WIND_ARROW_COLOUR") ) {
		string colour_value = request("WIND_ARROW_COLOUR");
		arrowplotting_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
	if  (request.countValues("WIND_ARROW_ORIGIN_POSITION") ) {
		string origin_position_value = request("WIND_ARROW_ORIGIN_POSITION");
		arrowplotting_->origin_position_ = MagTranslator<string, ArrowPosition>()(origin_position_value);
	}
		
	
	if  (request.countValues("WIND_ARROW_STYLE") ) {
		string style_value = request("WIND_ARROW_STYLE");
		arrowplotting_->style_ = MagTranslator<string, LineStyle>()(style_value);
	}
		
	
}

void ArrowPlottingWrapper::print(ostream& out)  const
{
	out << "ArrowPlottingWrapper[]";
}


    



#include "CalmIndicatorWrapper.h"

static SimpleObjectMaker<CalmIndicatorWrapper> ArrowPlotting_wind_arrow_calm_indicator_calm_Wrapper("calm");


#include "CalmIndicatorWrapper.h"

static SimpleObjectMaker<CalmIndicatorWrapper> ArrowPlotting_wind_arrow_calm_indicator_on_Wrapper("on");


#include "NoCalmIndicatorWrapper.h"
static SimpleObjectMaker<NoCalmIndicator, CalmIndicator> ArrowPlotting_wind_arrow_calm_indicator_nocalm ("nocalm");
static SimpleObjectMaker<NoCalmIndicatorWrapper, CalmIndicatorWrapper> ArrowPlotting_wind_arrow_calm_indicator_nocalm_wrapper ("nocalm");


#include "NoCalmIndicatorWrapper.h"
static SimpleObjectMaker<NoCalmIndicator, CalmIndicator> ArrowPlotting_wind_arrow_calm_indicator_off ("off");
static SimpleObjectMaker<NoCalmIndicatorWrapper, CalmIndicatorWrapper> ArrowPlotting_wind_arrow_calm_indicator_off_wrapper ("off");






