
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ObsPlottingAttributes.h
    \\brief Definition of ObsPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "ObsPlottingWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



ObsPlottingWrapper::ObsPlottingWrapper(): obsplotting_(new ObsPlotting())


{


	

}
ObsPlottingWrapper::ObsPlottingWrapper(ObsPlotting* obsplotting): obsplotting_(obsplotting)
{

	
}

ObsPlottingWrapper::~ObsPlottingWrapper()
{

}

void ObsPlottingWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("OBS_DISTANCE_APART") ) {
		double apart_value = request("OBS_DISTANCE_APART");
		obsplotting_->apart_ = apart_value;
		}
	if  (request.countValues("OBS_SIZE") ) {
		double size_value = request("OBS_SIZE");
		obsplotting_->size_ = size_value;
		}
	if  (request.countValues("OBS_RING_SIZE") ) {
		double ring_size_value = request("OBS_RING_SIZE");
		obsplotting_->ring_size_ = ring_size_value;
		}
	if  (request.countValues("OBS_PRESENT_WEATHER") ) {
		string present_ww_visible_value = request("OBS_PRESENT_WEATHER");
		
		obsplotting_->present_ww_visible_ = MagTranslator<string, bool>()(present_ww_visible_value);
		
		}
	if  (request.countValues("OBS_PRESSURE") ) {
		string pressure_visible_value = request("OBS_PRESSURE");
		
		obsplotting_->pressure_visible_ = MagTranslator<string, bool>()(pressure_visible_value);
		
		}
	if  (request.countValues("OBS_UPPER_AIR_PRESSURE") ) {
		string upper_air_visible_value = request("OBS_UPPER_AIR_PRESSURE");
		
		obsplotting_->upper_air_visible_ = MagTranslator<string, bool>()(upper_air_visible_value);
		
		}
	if  (request.countValues("OBS_PRESSURE_TENDENCY") ) {
		string pressure_tendency_visible_value = request("OBS_PRESSURE_TENDENCY");
		
		obsplotting_->pressure_tendency_visible_ = MagTranslator<string, bool>()(pressure_tendency_visible_value);
		
		}
	if  (request.countValues("OBS_STATION_RING") ) {
		string station_ring_visible_value = request("OBS_STATION_RING");
		
		obsplotting_->station_ring_visible_ = MagTranslator<string, bool>()(station_ring_visible_value);
		
		}
	if  (request.countValues("OBS_TEMPERATURE") ) {
		string temperature_visible_value = request("OBS_TEMPERATURE");
		
		obsplotting_->temperature_visible_ = MagTranslator<string, bool>()(temperature_visible_value);
		
		}
	if  (request.countValues("OBS_THICKNESS") ) {
		string thickness_visible_value = request("OBS_THICKNESS");
		
		obsplotting_->thickness_visible_ = MagTranslator<string, bool>()(thickness_visible_value);
		
		}
	if  (request.countValues("OBS_HEIGHT") ) {
		string height_visible_value = request("OBS_HEIGHT");
		
		obsplotting_->height_visible_ = MagTranslator<string, bool>()(height_visible_value);
		
		}
	if  (request.countValues("OBS_IDENTIFICATION") ) {
		string identifier_visible_value = request("OBS_IDENTIFICATION");
		
		obsplotting_->identifier_visible_ = MagTranslator<string, bool>()(identifier_visible_value);
		
		}
	if  (request.countValues("OBS_CLOUD") ) {
		string cloud_visible_value = request("OBS_CLOUD");
		
		obsplotting_->cloud_visible_ = MagTranslator<string, bool>()(cloud_visible_value);
		
		}
	if  (request.countValues("OBS_LOW_CLOUD") ) {
		string low_value = request("OBS_LOW_CLOUD");
		
		obsplotting_->low_ = MagTranslator<string, bool>()(low_value);
		
		}
	if  (request.countValues("OBS_MEDIUM_CLOUD") ) {
		string medium_value = request("OBS_MEDIUM_CLOUD");
		
		obsplotting_->medium_ = MagTranslator<string, bool>()(medium_value);
		
		}
	if  (request.countValues("OBS_HIGH_CLOUD") ) {
		string high_value = request("OBS_HIGH_CLOUD");
		
		obsplotting_->high_ = MagTranslator<string, bool>()(high_value);
		
		}
	if  (request.countValues("OBS_DEWPOINT") ) {
		string dewpoint_visible_value = request("OBS_DEWPOINT");
		
		obsplotting_->dewpoint_visible_ = MagTranslator<string, bool>()(dewpoint_visible_value);
		
		}
	if  (request.countValues("OBS_SEA_TEMPERATURE") ) {
		string sea_temperature_visible_value = request("OBS_SEA_TEMPERATURE");
		
		obsplotting_->sea_temperature_visible_ = MagTranslator<string, bool>()(sea_temperature_visible_value);
		
		}
	if  (request.countValues("OBS_WAVES") ) {
		string waves_visible_value = request("OBS_WAVES");
		
		obsplotting_->waves_visible_ = MagTranslator<string, bool>()(waves_visible_value);
		
		}
	if  (request.countValues("OBS_PAST_WEATHER") ) {
		string past_ww_visible_value = request("OBS_PAST_WEATHER");
		
		obsplotting_->past_ww_visible_ = MagTranslator<string, bool>()(past_ww_visible_value);
		
		}
	if  (request.countValues("OBS_TIME") ) {
		string time_plot_visible_value = request("OBS_TIME");
		
		obsplotting_->time_plot_visible_ = MagTranslator<string, bool>()(time_plot_visible_value);
		
		}
	if  (request.countValues("OBS_VISIBILITY") ) {
		string visibility_visible_value = request("OBS_VISIBILITY");
		
		obsplotting_->visibility_visible_ = MagTranslator<string, bool>()(visibility_visible_value);
		
		}
	if  (request.countValues("OBS_WIND") ) {
		string wind_visible_value = request("OBS_WIND");
		
		obsplotting_->wind_visible_ = MagTranslator<string, bool>()(wind_visible_value);
		
		}
	if  (request.countValues("OBS_WIND_COLOUR") ) {
		string wind_colour_value = request("OBS_WIND_COLOUR");
		obsplotting_->wind_colour_ = wind_colour_value;
		}
	if  (request.countValues("OBS_WIND_PROJECTED") ) {
		string wind_projected_value = request("OBS_WIND_PROJECTED");
		
		obsplotting_->wind_projected_ = MagTranslator<string, bool>()(wind_projected_value);
		
		}
	
	if  (request.countValues("OBS_COLOUR") ) {
		string colour_value = request("OBS_COLOUR");
		obsplotting_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	if  (request.countValues("OBS_PRESENT_WEATHER_COLOUR") ) {
		string present_ww_colour_value = request("OBS_PRESENT_WEATHER_COLOUR");
		obsplotting_->present_ww_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(present_ww_colour_value));
	}
		
	if  (request.countValues("OBS_PRESSURE_COLOUR") ) {
		string pressure_colour_value = request("OBS_PRESSURE_COLOUR");
		obsplotting_->pressure_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(pressure_colour_value));
	}
		
	if  (request.countValues("OBS_UPPER_AIR_PRESSURE_COLOUR") ) {
		string upper_air_colour_value = request("OBS_UPPER_AIR_PRESSURE_COLOUR");
		obsplotting_->upper_air_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(upper_air_colour_value));
	}
		
	if  (request.countValues("OBS_PRESSURE_TENDENCY_COLOUR") ) {
		string pressure_tendency_colour_value = request("OBS_PRESSURE_TENDENCY_COLOUR");
		obsplotting_->pressure_tendency_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(pressure_tendency_colour_value));
	}
		
	if  (request.countValues("OBS_STATION_RING_COLOUR") ) {
		string station_ring_colour_value = request("OBS_STATION_RING_COLOUR");
		obsplotting_->station_ring_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(station_ring_colour_value));
	}
		
	if  (request.countValues("OBS_TEMPERATURE_COLOUR") ) {
		string temperature_colour_value = request("OBS_TEMPERATURE_COLOUR");
		obsplotting_->temperature_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(temperature_colour_value));
	}
		
	if  (request.countValues("OBS_THICKNESS_COLOUR") ) {
		string thickness_colour_value = request("OBS_THICKNESS_COLOUR");
		obsplotting_->thickness_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(thickness_colour_value));
	}
		
	if  (request.countValues("OBS_HEIGHT_COLOUR") ) {
		string height_colour_value = request("OBS_HEIGHT_COLOUR");
		obsplotting_->height_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(height_colour_value));
	}
		
	if  (request.countValues("OBS_IDENTIFICATION_COLOUR") ) {
		string identifier_colour_value = request("OBS_IDENTIFICATION_COLOUR");
		obsplotting_->identifier_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(identifier_colour_value));
	}
		
	if  (request.countValues("OBS_LOW_CLOUD_COLOUR") ) {
		string low_colour_value = request("OBS_LOW_CLOUD_COLOUR");
		obsplotting_->low_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(low_colour_value));
	}
		
	if  (request.countValues("OBS_MEDIUM_CLOUD_COLOUR") ) {
		string medium_colour_value = request("OBS_MEDIUM_CLOUD_COLOUR");
		obsplotting_->medium_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(medium_colour_value));
	}
		
	if  (request.countValues("OBS_HIGH_CLOUD_COLOUR") ) {
		string high_colour_value = request("OBS_HIGH_CLOUD_COLOUR");
		obsplotting_->high_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(high_colour_value));
	}
		
	if  (request.countValues("OBS_DEWPOINT_COLOUR") ) {
		string dewpoint_colour_value = request("OBS_DEWPOINT_COLOUR");
		obsplotting_->dewpoint_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(dewpoint_colour_value));
	}
		
	if  (request.countValues("OBS_SEA_TEMPERATURE_COLOUR") ) {
		string sea_temperature_colour_value = request("OBS_SEA_TEMPERATURE_COLOUR");
		obsplotting_->sea_temperature_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(sea_temperature_colour_value));
	}
		
	if  (request.countValues("OBS_WAVES_COLOUR") ) {
		string waves_colour_value = request("OBS_WAVES_COLOUR");
		obsplotting_->waves_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(waves_colour_value));
	}
		
	if  (request.countValues("OBS_PAST_WEATHER_COLOUR") ) {
		string past_ww_colour_value = request("OBS_PAST_WEATHER_COLOUR");
		obsplotting_->past_ww_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(past_ww_colour_value));
	}
		
	if  (request.countValues("OBS_TIME_COLOUR") ) {
		string time_plot_colour_value = request("OBS_TIME_COLOUR");
		obsplotting_->time_plot_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(time_plot_colour_value));
	}
		
	if  (request.countValues("OBS_VISIBILITY_COLOUR") ) {
		string visibility_colour_value = request("OBS_VISIBILITY_COLOUR");
		obsplotting_->visibility_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(visibility_colour_value));
	}
		
	
}

void ObsPlottingWrapper::print(ostream& out)  const
{
	out << "ObsPlottingWrapper[]";
}





















