/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file WindPlotting.h
    \brief Definition of the Template class WindPlotting.
    
    Magics Team - ECMWF 2005
    
    Started: Thu 17-Mar-2005
    
    Changes:
    
*/

#ifndef WindPlotting_H
#define WindPlotting_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"


namespace magics {

template <class P>
class WindPlotting   {

public:
	WindPlotting() {}
	virtual ~WindPlotting() {}
	virtual void set(const map<string, string>&) {} ;
	virtual void set(const XmlNode&) { };
	virtual bool accept(const string&) { return false; }
	virtual void toxml(ostream&, int) {}
	virtual WindPlotting<P>* clone() { return 0; };
	virtual void operator()(const PaperPoint&, double, double) {}
	virtual void prepare(BasicGraphicsObjectContainer&) {}
	virtual void visit(LegendVisitor&) {}

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const
	 {  out << "WindPlotting<P>"; }

private:
    //! Copy constructor - No copy allowed
	WindPlotting(const WindPlotting&);
    //! Overloaded << operator to copy - No copy allowed
	WindPlotting& operator=(const WindPlotting&);
    
// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const WindPlotting<P>& p)
		{ p.print(s); return s; }

};

template <class P>
class Translator<string, WindPlotting<P> > { 
public:
	WindPlotting<P>* operator()(const string& val ) {
		 return SimpleObjectMaker<WindPlotting<P> >::create(val);
	}     
	WindPlotting<P>* magics(const string& param)
	{
		WindPlotting<P>* object;
		ParameterManager::update(param, object);
		return object;
	}
};
} // namespace magics

#endif
