/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GridPlotting.cc
    \brief Implementation of the Template class GridPlotting.
    
    Magics Team - ECMWF 2004
    
    Started: Mon 2-Feb-2004
    
    Changes:
    
*/

#include "GridPlotting.h"
#include "../basic/BasicSceneObject.h"
#include "Transformation.h"


using namespace magics;

GridPlotting::GridPlotting() : layer_(0) 
{
}
 
GridPlotting::~GridPlotting() 
{
}


const vector<double>& GridPlotting::longitudes(const Transformation& transformation) const
{
	if(longitudes_.empty())
	{
     	     for(double lon = getLonReference(); lon > transformation.getMinX(); lon -= getLonIncrement())
     	     {
		     longitudes_.push_back(lon);
     	     }
	     for(double lon = getLonReference() +  getLonIncrement() ; lon <= transformation.getMaxX(); lon += getLonIncrement())
     	     {
		     longitudes_.push_back(lon);
     	     }
	} 
	::sort(longitudes_.begin(), longitudes_.end(), greater<double>());
	return longitudes_;
}

const vector<double>& GridPlotting::latitudes(const Transformation& transformation) const
{
	if(latitudes_.empty())
	{
	       for(double lat = getLatReference(); lat > transformation.getMinY(); lat -= getLatIncrement())
     	       {
		       latitudes_.push_back(lat);
     	       }
	       for(double lat = getLatReference() + getLatIncrement(); lat <= transformation.getMaxY(); lat += getLatIncrement())
     	       {
		       latitudes_.push_back(lat);
     	       }
	}
	::sort(latitudes_.begin(), latitudes_.end(), greater<double>());
	return latitudes_;
}    


void GridPlotting::operator()(DrawingVisitor& out)
{
	if ( !layer_ ) layer_ = &out;
	
	const Transformation& transformation = out.transformation();

	this->latitudes(transformation);
	this->longitudes(transformation);

	transformation.gridLongitudes(*this);
	transformation.gridLatitudes(*this);
}

void GridPlotting::operator()(magics::PreviewVisitor&)
{
}

void GridPlotting::add(Polyline& poly) const
{
    poly.setColour(*colour_);
    poly.setThickness(thickness_);
    poly.setLineStyle(style_);

    poly.reproject(*layer_);
    
}



/*!
 Class information are given to the output-stream.
*/		
void GridPlotting::print(ostream& out)  const
{
	out << "GridPlotting[";
	GridPlottingAttributes::print(out);
	out << "]";
}
