/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file DayDateAxisAttributes.cc
    \brief Implemtation of DayDateAxis Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Oct 26 20:27:36 2009
*/    

#include "DayDateAxisAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


DayDateAxisAttributes::DayDateAxisAttributes():
	colour_(ParameterManager::getString("axis_days_label_colour")),
	quality_(ParameterManager::getString("axis_days_label_quality")),
	height_(ParameterManager::getDouble("axis_days_label_height")),
	composition_(Translator<string, DayMethodComposition>().magics("axis_days_label_composition"))
{
} 



DayDateAxisAttributes::~DayDateAxisAttributes()
{
}

    
void DayDateAxisAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_days";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_days_label_colour", colour_, params);
	setAttribute(prefix, "axis_days_label_quality", quality_, params);
	setAttribute(prefix, "axis_days_label_height", height_, params);
	setMember(prefix, "axis_days_label_composition", composition_, params);
}

void DayDateAxisAttributes::copy(const DayDateAxisAttributes& other)
{
	colour_ = other.colour_;
	quality_ = other.quality_;
	height_ = other.height_;
	setComposition(other.composition_->clone());
} 


bool DayDateAxisAttributes::accept(const string& node)
{	
	if ( magCompare(node, "day")  )
		return true;

	if ( acceptNode(node, composition_) )
		return true;
	return false;
}

void DayDateAxisAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "day") )
		set(node.attributes());
	else {
		setMember(node.name(), composition_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), composition_, *(*elt)); 
	}
}

void DayDateAxisAttributes::print(ostream& out)  const
{
	out << "DayDateAxisAttributes[";
	out << "colour = " << colour_;
	out << ", quality = " << quality_;
	out << ", height = " << height_;
	out << ", composition = " << *composition_;
	out << "]" << "\n";
}


void DayDateAxisAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_days_label_colour = \'" << colour_ << "\'\n";
	out << tab << "\taxis_days_label_quality = \'" << quality_ << "\'\n";
	out << tab << "\taxis_days_label_height = \'" << height_ << "\'\n";
	out << tab << ">";

 	composition_->toxml(out, tabs+1);

	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_days_label_colour("axis_days_label_colour", "undef", " New Magics: Parameter axis_days_label_ colour sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_days_label_quality("axis_days_label_quality", "medium", " New Magics: Parameter axis_days_label_ quality  sent to new Magics[XYSystem].  ");
static MagicsParameter<double> axis_days_label_height("axis_days_label_height", 0.2, " New Magics: Parameter axis_days_label_height sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_days_label_composition("axis_days_label_composition", "three", " New Magics: Parameter axis_days_label_ composition  sent to new Magics[XYSystem].  ");
#include "DayMethodComposition.h"
static SimpleObjectMaker<DayMethodComposition, DayMethodComposition> three_DayMethodComposition("three");
static SimpleObjectMaker<DayMethodComposition, DayMethodComposition> shortday_DayMethodComposition("shortday");
static SimpleObjectMaker<OneDayMethodComposition, DayMethodComposition> one_OneDayMethodComposition("one");
static SimpleObjectMaker<OneDayMethodComposition, DayMethodComposition> veryshortday_OneDayMethodComposition("veryshortday");
static SimpleObjectMaker<FullDayMethodComposition, DayMethodComposition> full_FullDayMethodComposition("full");
static SimpleObjectMaker<FullDayMethodComposition, DayMethodComposition> longday_FullDayMethodComposition("longday");
