/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLZoomStackGui.h
    \brief Definition of the OpenGLZoomStackGui.
    \author Graphics Section, ECMWF
    
    Started: May 2008    
*/

#ifndef OpenGLZoomStackGui_H
#define OpenGLZoomStackGui_H

#define GL_GLEXT_PROTOTYPES

#include <GL/gl.h>

#include <magics.h>
#include <Log.h>
#include <OpenGLDriverObserver.h>
#include <OpenGLGui.h>

namespace magics {

class OpenGLPushButtonWidget;
class OpenGLCellBarWidget;
class OpenGLTextureItem;
class OpenGLLayoutNode;

class OpenGLZoomStackGui :  public OpenGLGui
{
public:	
	OpenGLZoomStackGui(OpenGLDriver *,string);
	~OpenGLZoomStackGui();		
	void driver(OpenGLDriver* drv) {driver_=drv;};			
	void show();	
	
protected:
	void readSettings();
	
	void build();	
	void update();
	void updateGeometry();
	
	void setActLevel(int);
	void updateButtonState();	
	void event(MtInputEvent *);

	//Callbacks
	static void stepUp_cb(void *,void *);	
	static void stepDown_cb(void *,void *);
	static void stepTo_cb(void *,void *);
	static void focusedLevelChanged_cb(void *,void *);
	
	void stepUp();	
	void stepDown();
	void stepTo(int*);
	void focusedLevelChanged(int*);
	
	void renderLevelPreview(int);
	void clearPreviewTex();	
	void generateLevelPreviewTex(OpenGLTextureItem *);	

	void notifyObserverOfVisibilityChange(bool);

	int pbWidth_;
	int pbHeight_;
	int pbGapBar_;
	int pbGapBorder_;
	
	float cellWidth_;
	float cellHeight_;
	
	int levelNum_;
	int actLevel_;
	int focusedLevel_;

	OpenGLPushButtonWidget* pbUp_;
	OpenGLPushButtonWidget* pbDown_;
	OpenGLCellBarWidget* bar_;

	vector<OpenGLTextureItem*> levelTex_;
	OpenGLTextureItem*         bgTex_;

	int levelPreviewWidth_;
	int levelPreviewBorder_;
	Colour levelPreviewBorderColour_;

	Colour cellColour_;	
	Colour actCellColour_;	

	OpenGLLayoutNode*  currentLayout_;

};

}	

#endif	
