#include "OpenGLPainter.h"

#include <Text.h>
#include <PaperPoint.h>
#include <OpenGLDriverText.h>
#include <OpenGLFontHandler.h>
#include <FontMap.h>

using namespace magics;


OpenGLPainter* OpenGLPainter::instance_ = 0;
//list<LogItem*> LogHandler::item_;
float OpenGLPainter::cmScale_=75./2.54;
OpenGLFontHandler* OpenGLPainter::fontHandler_=0;

OpenGLPainter::OpenGLPainter()
{
	fontHandler_=new OpenGLFontHandler();
}

OpenGLPainter* OpenGLPainter::instance()
{
	if(instance_ == 0)	
	{
		instance_= new OpenGLPainter;
		return instance_;
	}
	else
	{
		return instance_;
	}
}

void OpenGLPainter::buildRoundedRectPolygon(int x0, int y0, int x1, int y1, int cornerRad,
	        vector<float> &x, vector<float> &y)
{
	float dfi, fi0;
	int cpNum;
	float xp,yp;

	//Corner arc point num
	cpNum=cornerRad*PI/2.;

	//Angle step along the corner arc
	dfi=PI/(2.*cpNum);

	//Top-left corner
	xp=x0+cornerRad;
	yp=y1-cornerRad;	
	fi0=PI/2.;

	for (int i=0; i<= cpNum; i++)
	{
		x.push_back(xp+cornerRad*cos(fi0+i*dfi));
		y.push_back(yp+cornerRad*sin(fi0+i*dfi));	
	}
		
	x.push_back(x0);
	y.push_back(y0+cornerRad);

	//Bottom left corner
	xp=x0+cornerRad;
	yp=y0+cornerRad;	
	fi0=PI;

	for (int i=0; i<= cpNum; i++)
	{
		x.push_back(xp+cornerRad*cos(fi0+i*dfi));
		y.push_back(yp+cornerRad*sin(fi0+i*dfi));	
	}
	
	x.push_back(x1-cornerRad);
	y.push_back(y0);
		
	//Bottom right corner
	xp=x1-cornerRad;
	yp=y0+cornerRad;	
	fi0=1.5*PI;

	for (int i=0; i<= cpNum; i++)
	{
		x.push_back(xp+cornerRad*cos(fi0+i*dfi));
		y.push_back(yp+cornerRad*sin(fi0+i*dfi));	
	}

	x.push_back(x1);
	y.push_back(y1-cornerRad);

		
	//Top right corner
	xp=x1-cornerRad;
	yp=y1-cornerRad;	
	fi0=0;

	for (int i=0; i<= cpNum; i++)
	{
		x.push_back(xp+cornerRad*cos(fi0+i*dfi));
		y.push_back(yp+cornerRad*sin(fi0+i*dfi));	
	}	

	//Close the polygon
	//x.push_back(x0+cornerRad);
	//y.push_back(y1);

}

void OpenGLPainter::renderRoundedRect(int x0, int y0, int x1, int y1, int cornerRad, 
                       Colour col, float lwidth, bool antialias)
{	
	vector<float> x,y;

	buildRoundedRectPolygon(x0,y0,x1,y1,cornerRad,x,y);

	renderPolygon(x,y,col,lwidth,antialias);      
}

void OpenGLPainter::renderFilledRoundedRect(int x0, int y0, int x1, int y1, int cornerRad, 
                       Colour col)
{
	vector<float> x,y;

	buildRoundedRectPolygon(x0,y0,x1,y1,cornerRad,x,y);

	renderFilledPolygon(x,y,col);
}

void OpenGLPainter::renderPolygon(vector<float> &x, vector<float> &y,Colour &col,float lwidth,bool antialias)
{
	glPushAttrib(GL_POLYGON_BIT);
	glFrontFace(GL_CCW);
	glEnable(GL_CULL_FACE);	
	glCullFace(GL_BACK);	
			
	if(antialias)
	{
		/*glPushAttrib(GL_ENABLE_BIT | GL_LINE_BIT);
		glEnable(GL_BLEND);
		//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glBlendFunc(GL_CONSTANT_ALPHA,GL_ONE_MINUS_CONSTANT_ALPHA);
		glBlendColor(0.5,0.5,0.5,1.);
		glEnable(GL_LINE_SMOOTH);
		glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);		

		glLineWidth(lwidth);*/
	}
	
	glPolygonMode(GL_FRONT,GL_LINE);		
	
	
	//glColor4f(col.red(),col.green(),col.blue(),0.4);
	glColor3f(col.red(),col.green(),col.blue());
	
	glBegin(GL_POLYGON);
	for(int i=0; i< x.size(); i++)
	{
		glVertex2f(x[i],y[i]);
	}
	glEnd();

	if(antialias)
	{
		//glPopAttrib();
	}

	glPopAttrib();
}		


void OpenGLPainter::renderFilledPolygon(vector<float> &x, vector<float> &y,Colour &col)
{
	glPushAttrib(GL_POLYGON_BIT);
	glFrontFace(GL_CCW);
	glEnable(GL_CULL_FACE);	
	glCullFace(GL_BACK);	
			
	glPolygonMode(GL_FRONT,GL_FILL);

	glColor4f(col.red(),col.green(),col.blue(),col.alpha());
		
	glBegin(GL_POLYGON);
	for(int i=0; i< x.size(); i++)
	{
		glVertex2f(x[i],y[i]);
	}
	glEnd();

	glPopAttrib();
}		


void OpenGLPainter::renderFilledPolygon(vector<float> &x, vector<float> &y,vector<Colour> &col)
{
	glPushAttrib(GL_POLYGON_BIT);
	glFrontFace(GL_CCW);
	glEnable(GL_CULL_FACE);	
	glCullFace(GL_BACK);	
			
	glPolygonMode(GL_FRONT,GL_FILL);
	
	glShadeModel(GL_SMOOTH);
	
	glBegin(GL_POLYGON);
	for(int i=0; i< x.size(); i++)
	{
		glColor4f(col[i].red(),col[i].green(),col[i].blue(),col[i].alpha());
		glVertex2f(x[i],y[i]);
	}
	glEnd();

	glPopAttrib();
}	

void OpenGLPainter::renderRect(float x1, float y1, float x2, float y2,Colour &col)
{
	glColor3f(col.red(),col.green(),col.blue());
	glRectf(x1,y1,x2,y2);
}	

void OpenGLPainter::renderFilledRect(float x1, float y1, float x2, float y2,Colour &col)
{
	glPushAttrib(GL_POLYGON_BIT);
	glFrontFace(GL_CCW);
	glEnable(GL_CULL_FACE);	
	glCullFace(GL_BACK);
	glPolygonMode(GL_FRONT,GL_FILL);

	glColor3f(col.red(),col.green(),col.blue());
	glRectf(x1,y1,x2,y2);

	glPopAttrib();
}


Colour OpenGLPainter::interpolateColour(const Colour &c1, const Colour &c2, float weight)
{
	if(weight < 0 || weight > 1) weight=0;

	float r=weight*c2.red()+(1-weight)*c1.red();
	float g=weight*c2.green()+(1-weight)*c1.green();
	float b=weight*c2.blue()+(1-weight)*c1.blue();
	
	return Colour(r,g,b);
}	

void OpenGLPainter::renderText(float x,float y, Colour &col, float fontSize, string text_str, float angle)
{
	Text text;
	PaperPoint pp(x,y);		
	text.push_back(pp);

	text.addText(text_str,col,fontSize*2.54/75.); //75 dpi
	text.setJustification(MLEFT);
	text.setVerticalAlign(MBASE);
	text.setAngle(angle);	

	renderText(&text);
}


void OpenGLPainter::renderText(const Text* text,float coordRatioY,float mFactor) const					       
{	
	if(text->empty()) return;

	//if(!hasFonts_ || text->empty()) return;

	//Check if nicetext available
	const vector<NiceText>& niceT = text->getNiceText();
	if(niceT.empty()) return;
	
	const enum Justification horizontal = text->getJustification();
	const enum VerticalAlign vertical   = MBASE; //text->getVerticalAlign();

	/*if(lastHorizontalAlign_ != horizontal || lastVerticalAlign_ != vertical )
	{
	  	lastHorizontalAlign_	= horizontal;
		lastVerticalAlign_	= vertical;		
	}*/

	string textString;
		
	bool magnify = (mFactor > 1.)?true:false;	
	
	//Now, text rendering					
	int count = 0;
			
	float pwidth=0;
	float offset_x=0;		
	float theight=0;
	float offset_y=0;		
	float gheight,pheight;
		
	vector<OGLFT::TranslucentTexture*> fontGLVec;
	OGLFT::TranslucentTexture* fontGL;
		
	//---------------------------------------------------------
	// Determine the bounding box size for the whole text and
	// create the required font objects
	//---------------------------------------------------------
		
	for(vector<NiceText>::const_iterator niceText=text->textBegin(); 
                               niceText != text->textEnd(); niceText++)                               
	{			
		const MagFont magfont = (*niceText).font();
		
		//Get ttf filename
		string ttf;
		FontMap::instance()->ttfFileName(magfont,ttf);		

		//Set font size					
		pheight = 72.*convertCM(magfont.size()*mFactor)/75.; //height in points	
					
		if((*niceText).elevation()==NORMAL)           { pheight = pheight;}
		else if((*niceText).elevation()==SUPERSCRIPT) { pheight*=0.5;}
		else if((*niceText).elevation()==SUBSCRIPT)   { pheight*=0.5;}        		       			
			
		//Check if font is already available otherwise create it
		fontGL=fontHandler_->addFont(ttf,pheight,magfont.colour());
		
		//If font cannot be created ...
		if(fontGL == 0)
		{			
			Log::warning() << "OpenGLPainter::renderText() ---> Could not construct ttf font face from TTF font file" << ttf.c_str() << endl;    										
			return;
			
  		}
		
		fontGLVec.push_back(fontGL);			
										
		//Convert the UTF-8 coded text into Unicode. The resulting vector will
		//contain the corresponding Unicode codepoints!  
		OGLFT::UniString ustr;
		fontGL->textUtfToUnicode((*niceText).text(),ustr);
			
		//Get the bounding box
		OGLFT::BBox bbox = fontGL->measure(ustr);
  	  		
		pwidth+=bbox.advance_.dx_;   //x_max_-bbox.x_min_; //bbox total width
		
		count++;				

	  } // endfor all nicetexts
		
		
	//----------------------------
	// Text rendering
	//----------------------------
			
	//const bool single = (text.size() == 1);		
	const bool single = (count==1);
		
	//Single text item....
	if(single)
	{		
		vector<NiceText>::const_iterator niceText = text->textBegin();
			
		//Get the font
		fontGL = fontGLVec[0];
			
		const MagFont magfont = (*niceText).font();
	
		float coordRatioY=1;
	
		//Set font size

		gheight = (100./75.)*convertCM(magfont.size())/coordRatioY; // height in the actual (scaled) GL units
		offset_y = 0;	   //vertical offset in the actual GL units
			
		if((*niceText).elevation()==NORMAL){}
		else if((*niceText).elevation()==SUPERSCRIPT)           
		{
			offset_y = (gheight*0.6);             					
			gheight*=0.5;					
		}
		else if((*niceText).elevation()==SUBSCRIPT)           
		{
			offset_y = (gheight*0.6);             					
			gheight*=0.5;					
		}				   		        						
			         	
			
		//Set font  justification
		if (horizontal==MLEFT)   fontGL->setHorizontalJustification(OGLFT::Face::LEFT);
		else if (horizontal==MCENTRE)  fontGL->setHorizontalJustification(OGLFT::Face::CENTER);   
		else if (horizontal==MRIGHT) fontGL->setHorizontalJustification(OGLFT::Face::RIGHT);
		
		if (vertical==MBASE) fontGL->setVerticalJustification(OGLFT::Face::BASELINE);
		else if (vertical==MTOP)    fontGL->setVerticalJustification(OGLFT::Face::TOP);
		else if (vertical==MHALF)   fontGL->setVerticalJustification(OGLFT::Face::MIDDLE);
		else if (vertical==MBOTTOM) fontGL->setVerticalJustification(OGLFT::Face::BOTTOM);
		
		//!!!!!!!!!!!!!!!!!!!!!!!!
		if (vertical==MBASE)   fontGL->setVerticalJustification(OGLFT::Face::MIDDLE);

		//Convert the UTF-8 coded text into Unicode. The resulting vector will
		//contain the corresponding Unicode codepoints!  
		OGLFT::UniString ustr;
		fontGL->textUtfToUnicode((*niceText).text(),ustr);
		
		if(text->size() > 1) 
		{
			Log::dev() << "Text vector size: " << text->size() << endl;
		}

		for(vector<PaperPoint>::const_iterator it=text->begin(); it != text->end(); it++)
		{
			//Text position and angle		
					          
			const float x0 = (*it).x();
			const float y0 = (*it).y();
			const float an = 360.-(text->getAngle()*57.29577951);
			 			        
			glPushMatrix();
			glTranslatef(x0,y0,0.);		
				
			//Save colour and polygon settings
			glPushAttrib(GL_COLOR_BUFFER_BIT| GL_ENABLE_BIT| GL_CURRENT_BIT | GL_POLYGON_BIT); 
		
			//OpenGL settings      
	        	glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );                
			glEnable( GL_BLEND );
                	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );					
			glEnable(GL_TEXTURE_2D);		
		
			//This must be set to FILL!!! Otherwise only texture borders are mapped!
			glFrontFace(GL_CCW);
			glEnable(GL_CULL_FACE);	
			glCullFace(GL_BACK);	
			glPolygonMode(GL_FRONT,GL_FILL);
						
			//Render the text!		
			if(an ==0 || an == 360)			
			{		 				 		   		   
		   		fontGL->draw(0., 0., ustr, text->getBlanking());				
			}
			else
			{				  		   
		   		fontGL->setStringRotation(an);				 
		   		fontGL->draw(0., 0., ustr, text->getBlanking());
				fontGL->setStringRotation(0.);
			} 
		  								
			//Resotre colour and polygon settings
			glPopAttrib();		
			glPopMatrix();

		}
	}
		
	//Multiple text items!!
	else
	{
		
		float offset_x=0.;
			
		//Text Justification
		if (horizontal==MLEFT)   offset_x=0;
		else if (horizontal==MCENTRE)  offset_x=-pwidth/2.;
		else if (horizontal==MRIGHT)   offset_x=-pwidth;
					
		//Text position and angle
		const float x0 = (*text)[0].x(); //+offset_x;
		const float y0 = (*text)[0].y();  //- (height * 0.35) + offset_y;
		const float an = 0. ; // 360.-(text->getAngle()*57.29577951);
			 			
		glPushMatrix();		
			
		glTranslatef(x0+offset_x,y0,0.);							

		count=0;
		for(vector<NiceText>::const_iterator niceText=text->textBegin(); niceText != text->textEnd(); niceText++)                               
		{					
			const MagFont magfont = (*niceText).font();
			
			//Get the font
			fontGL = fontGLVec[count];
				
			//Horizontal justification is always LEFT for the first item
			if(count==0) fontGL->setHorizontalJustification(OGLFT::Face::LEFT);
			else fontGL->setHorizontalJustification(OGLFT::Face::ORIGIN);
				
				
			if (vertical==MBASE) fontGL->setVerticalJustification(OGLFT::Face::BASELINE);
			else if (vertical==MTOP)    fontGL->setVerticalJustification(OGLFT::Face::TOP);
			else if (vertical==MHALF)   fontGL->setVerticalJustification(OGLFT::Face::MIDDLE);
			else if (vertical==MBOTTOM) fontGL->setVerticalJustification(OGLFT::Face::BOTTOM);


			//Set font size
			//convertCM: cm->pixel
			float gheight = (100./75.)*convertCM(magfont.size()*mFactor);  // height in the actual GL units (now it is pixels!)
			offset_y = 0;  //vertical offset in GL units (pixels)
						
			if((*niceText).elevation()==NORMAL){}
			else if((*niceText).elevation()==SUPERSCRIPT)           
			{
				offset_y = (gheight*0.6);             					
				//pheight*=0.5;
				gheight*=0.5;					
			}
			else if((*niceText).elevation()==SUBSCRIPT)           
			{
				offset_y = (gheight*0.6);             					
				//pheight*=0.5;
				gheight*=0.5;								
			}				   		        						
			fontGL->setPointSize(pheight);
				
			//Save colour settings
			glPushAttrib(GL_ENABLE_BIT| GL_COLOR_BUFFER_BIT| GL_CURRENT_BIT | GL_POLYGON_BIT);
				
			
			//Convert the UTF-8 encoded text into Unicode. The resulting vector will
			//contain the corresponding Unicode codepoints!  
			OGLFT::UniString ustr;
			fontGL->textUtfToUnicode((*niceText).text(),ustr);
			
			//Save colour settings
			//glPushAttrib(GL_CURRENT_BIT);
		 		
			//OpenGL settings      	        		
			glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );                
			glEnable( GL_BLEND );
                	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );					
			glEnable(GL_TEXTURE_2D);
								
			//This must be set to FILL!!! Otherwise only texture borders are mapped!				
			glFrontFace(GL_CCW);
			glEnable(GL_CULL_FACE);	
			glCullFace(GL_BACK);	
			glPolygonMode(GL_FRONT,GL_FILL);
				
			//Render the text! 							
			fontGL->draw(0.,-(gheight * 0.35) + offset_y, ustr,text->getBlanking());								
								
			//Translate the text position
			OGLFT::BBox bbox = fontGL->measure(ustr);
			glTranslatef(bbox.advance_.dx_,0,0.);
						
			//Resotre colour settings
			glPopAttrib(); 
					
			count++;
		}
		
		glPopMatrix();
	}
}
