/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLGui.h
    \brief Definition of the OpenGLGui
    \author Graphics Section, ECMWF
    
    Started: July 2008    
*/

#ifndef OpenGLGui_H
#define OpenGLGui_H

#include <magics.h>
#include <OpenGLManagerWidget.h>

class MtInputEvent;

namespace magics 
{
class OpenGLTextureItem;
class OpenGLFboItem;

class OpenGLGui : public OpenGLManagerWidget
{

public:
	OpenGLGui(OpenGLDriver *driver, string name, int x=0, int y=0, int width=0, int height=0); 
	~OpenGLGui();
   
	void render();
        void event(MtInputEvent *);	

	virtual bool active();
        virtual bool enabled() {return enabled_;}
	virtual bool visible() {return visible_;};
	virtual bool changed() {return changed_;}
	virtual bool focused() {return focused_;}
	
	void setVisible(bool);

	virtual void update() {};
        virtual void currentFrameChanged() {};

	void map();
	void map(bool,bool);
	void renderChild(OpenGLBaseWidget*);
	void renderChildren(list<OpenGLBaseWidget*>&);
	bool rendered() {return rendered_;};
	void mapBg();

	virtual void show();
	virtual void hide() {};
	virtual void clear() {};
	
	OpenGLWidget::DragType  dragType()  {return dragType_;};
        
protected:	
	virtual void build() {};

	void clearTexture();

	void renderBorder();	
	void createDropShadowTexture();
	void renderDropShadow();	
	
	bool checkRectInWindow(int&,int&,const int,const int);
	bool checkFocus(MtInputEvent *);

	virtual void drag_start(int,int);
	virtual void resize(int,int);
	virtual void resize_end();

	virtual void replace(int,int);
	virtual void replace_end();

	void changeVisibility();
	virtual void notifyObserverOfVisibilityChange(bool) {};

	static void close_cb(void *,void *);
	void close();

	vector<string> title_;
	int titleBarHeight_;
	
	OpenGLTextureItem* tex_;
	OpenGLTextureItem* texBg_;
	OpenGLTextureItem* texDropShadow_;

	OpenGLFboItem*	fbo_;

	float alphaFocus_;
	float alphaUnfocus_;
	float alphaCurrent_;
	
	bool  built_;
	bool  enabled_;	
	bool  visible_;
	bool  active_;
	bool  changed_;

	int prevX_;
	int prevY_;

	int minX_;
	int maxX_;
	int minY_;
	int maxY_;

	int closeButtonSize_;

	int cornerSize_;
	int dropShadowInSize_;
	int dropShadowOutSize_;
	vector<float> outlineX_;
	vector<float> outlineY_;	

	OpenGLWidget::DragType  dragType_;
	OpenGLWidget::DragArea  dragArea_;
	

};	

}

#endif
