
/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLAnimationContol.cc
    \brief Definition of OpenGLAnimationContol
    \author Graphics Section, ECMWF

    Started: December 2008
*/
#include <AnimationRules.h>
#include <OpenGLStepNode.h>
#include <OpenGLAnimationControl.h>

OpenGLAnimationControl::OpenGLAnimationControl()
{


}

int OpenGLAnimationControl::stepNum()
{
	return stepDef_.size();
}	

void OpenGLAnimationControl::addStep(OpenGLStepNode *fr) 
{
	step_.push_back(fr);
}

void OpenGLAnimationControl::addStepDef(OpenGLStepNode *fr) 
{
	stepDef_.push_back(fr);
}

OpenGLStepNode* OpenGLAnimationControl::selectStepDef(int stepNo)
{	
	for(list<OpenGLStepNode*>::iterator it=stepDef_.begin(); it != stepDef_.end(); it++)
	{
		if((*it)->id() == stepNo)				
		{
			return *it;
		}
	}

	return 0;
}

void OpenGLAnimationControl::selectStep(int stepNo,list<OpenGLStepNode*> &sn)
{	
	for(list<OpenGLStepNode*>::iterator it=step_.begin(); it != step_.end(); it++)
	{
		if((*it)->id() == stepNo)				
		{
			sn.push_back(*it);
		}
	}
}

void OpenGLAnimationControl::stepLabel(int stepNo,vector<string>& sv)
{
	OpenGLStepNode* s=selectStepDef(stepNo);

	if(s)
	{
		sv=s->step()->label();
	}
}	 


void OpenGLAnimationControl::stepLabel(OpenGLStepNode* sn,vector<string>& sv)
{
	if(sn)
	{
		sv=sn->step()->label();
	}
}
	 
void OpenGLAnimationControl::stepGridResolution(int stepNo,float &dx,float &dy)
{
	OpenGLStepNode* s=selectStepDef(stepNo);
	dx=-1.;
	dy=-1.;

	if(s)
	{
		dx=s->step()->xResolution();
		dy=s->step()->yResolution();
	}
}
	
bool OpenGLAnimationControl::stepCached(int stepNo)
{
	list<OpenGLStepNode*> sn;
	selectStep(stepNo,sn);

	for(list<OpenGLStepNode*>::iterator it=sn.begin(); it != sn.end(); it++)
	{
		if((*it)->cached())
		{
			return true;
		}
	}

	return false;			
}

bool OpenGLAnimationControl::stepCached(OpenGLStepNode* sn)
{		
	return stepCached(sn->id());	
}


void OpenGLAnimationControl::steps(vector<MagicsAnimationStepData>& steps)
{
	for(list<OpenGLStepNode*>::iterator it=stepDef_.begin(); it != stepDef_.end(); it++)
	{
		vector<string> sv;
		stepLabel(*it,sv);
		steps.push_back(MagicsAnimationStepData(sv,stepCached(*it)));
	}
}	
