/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfDecoder.h
    \brief Definition of the Template class NetcdfDecoder.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/

#ifndef NetcdfDecoder_H
#define NetcdfDecoder_H

#include "magics.h"
#include "AnimationRules.h"

#include "Decoder.h"
#include "NetcdfDecoderAttributes.h"
#include "GeoPoint.h"
#include "Data.h"
#include "PointsHandler.h"
#include "Factory.h"
#include "Translator.h"



namespace magics {

template <class P>
class NetcdfDecoder: public Decoder,
                     public Data<P>,           
                     public NetcdfDecoderAttributes
{

public:
	NetcdfDecoder();
	virtual ~NetcdfDecoder();
    
    void decode() {}
    // implements BaseSceneObject interface
    virtual void set(const map<string, string>& params) { NetcdfDecoderAttributes::set(params); }
    virtual void set(const XmlNode& node) { NetcdfDecoderAttributes::set(node); }
    virtual void visit(MagnifierVisitor&); 
    
  

    PointsHandler<P>& points() 
    { 
    	(*interpretor_).interpretAsPoints(points_); 
    	this->pointsHandlers_.push_back(new PointsHandler<P>(points_));
    	return *(this->pointsHandlers_.back()); 
    }


    MatrixHandler<P>& matrix() {
        Log::dev() << "NetcdfDecoder::matrix! " << "\n";
        (*interpretor_).interpretAsMatrix(data_); 
        this->matrixHandlers_.push_back(new MatrixHandler<P>(data_)); 
        return *(this->matrixHandlers_.back());
    } 
    
    void customisedPoints(const std::set<string>& request, CustomisedPointsList& out) {
    	(*interpretor_).customisedPoints(request, out); 
    }
    
    void visit(AnimationStep& step) {
    	   try {
    		   MatrixHandler<P>& data = matrix() ; 
    		   // Information about contains...
    		   	Log::dev() << "Netcdf::visit(AnimationRules&) --> " << endl;
    		   	
    		
    		   	step.xResolution(abs(data.XResolution()));
    		   	step.yResolution(abs(data.YResolution()));
    	         }
    	   catch (...)
    	   {
    		   
    	   }
    	   
    	        
    	         
    	
    }
    
    
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
	 
	 PointsList<P> points_;
	 Matrix     data_;

private:
	//! Copy constructor - No copy allowed
	NetcdfDecoder(const NetcdfDecoder&);
	//! Overloaded << operator to copy - No copy allowed
	NetcdfDecoder& operator=(const NetcdfDecoder&);

// -- Friends
	//! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const NetcdfDecoder& p)
		{ p.print(s); return s; }
};

template < class P>
class NetcdfLoop : public DataLoop<P>
{
public:
	NetcdfLoop(NetcdfDecoder<P>* netcdf): netcdf_(netcdf) {}
	virtual ~NetcdfLoop() {}
	void set(const map<string, string>& map) { } // NetcdfLoopAttributes::set(map); }
	void set(const XmlNode& node) { } // NetcdfLoopAttributes::set(node); }
	
    void set(NetcdfDecoder<P>* netcdf) { netcdf_ = netcdf; }
	
	Data<P>* current() {
		NetcdfDecoder<P>* current = netcdf_;
		netcdf_ = 0;
		return current;
	}
	bool         hasMore() {
		return (netcdf_ != 0);
	}
	void         next() { netcdf_ = 0; }
	

	
	

protected:
	virtual void print(ostream&) const {}
	NetcdfDecoder<P>* netcdf_;
	
	
	
	
private:
	//! Copy constructor - No copy allowed
	NetcdfLoop(const NetcdfLoop&);
	//! Overloaded << operator to copy - No copy allowed
	NetcdfLoop<P>& operator=(const NetcdfLoop<P>&);

// -- Friends
	//! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const NetcdfLoop<P>& p)
		{ p.print(s); return s; }
	
};


#include "NetcdfDecoder.cc"

} // namespace magics
#endif
