/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GeoPointsDecoder.cc
    \brief Implementation of the Template class GeoPointsDecoder.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 12-Dec-2005
    
    Changes:
    
*/



#include "GeoPointsDecoder.h"

using namespace magics;

GeoPointsDecoder::GeoPointsDecoder() 
{
}


GeoPointsDecoder::~GeoPointsDecoder() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void GeoPointsDecoder::print(ostream& out)  const
{
	out << "GeoPointsDecoder[";
	out << "]";
}

void GeoPointsDecoder::yxdtlv(const string& line)
{
	std::istringstream in(line);
	double lat, lon, date, time, level, value;
	in >> lat >> lon >> level >> date >> time >>  value;
	push_back(GeoPoint(lon, lat, value));
}

void GeoPointsDecoder::xyv(const string& line)
{
	std::istringstream in(line);
	double lat, lon, value;
	in >> lon >> lat >> value;
	push_back(GeoPoint(lon, lat, value));
	
}

void GeoPointsDecoder::decode() 
{
	if ( formats_.empty() ) {
		formats_["XYV"] = &GeoPointsDecoder::xyv;
		formats_["LLV"] = &GeoPointsDecoder::xyv;
	}
	
	GeoPointsDecoder::Decode method = &GeoPointsDecoder::yxdtlv;
	
	if ( !empty() ) return;
	char line[1024];
	try {
		
		ifstream in(path_.c_str());
		while( in.getline( line, sizeof(line) ) ) {
		      if( strncmp( line, "#DATA", 5 ) == 0 ) 
		    	  break;
		      if( strncmp( line, "#FORMAT ", 8 ) == 0 ) {
		    	  const char* fp = line+7;
		    	  while( fp && *fp == ' ' )
		    		  	++fp;
		    	  string format(fp);
		    	  map<string, GeoPointsDecoder::Decode>::iterator m = formats_.find(format);
		    	  method = ( m != formats_.end() ) ? m->second : &GeoPointsDecoder::yxdtlv;			
		      }
		    }

		  while( in.getline( line, sizeof(line) ) ) {
		      if( (*line != '#') && (strlen( line ) > 4) ) {
		    	  (this->*method)(line);
		      }
		    }

		in.close();
	}
	catch (...)
	{
		Log::error() << "Geopoints file : can not open " << path_ << endl;
	}
	 
	 
}
