/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file OutputHandlerAttributes.h
    \brief Definition of OutputHandler Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Oct 26 20:27:33 2009
*/
   

#ifndef OutputHandlerAttributes_H
#define OutputHandlerAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class OutputHandlerAttributes 
{
public:
//  --  constructor
    OutputHandlerAttributes();
    
//  --  destructor
    virtual ~OutputHandlerAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const OutputHandlerAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Defines the device to be used (ps/gif/svg).
    \param format Setting output_format - default=ps
*/
	void setFormat(string format) 
		{ format_ =  format; } 
	string getFormat() const 
		{ return format_; } 
        
/*!
    Magics Information:
    \brief Defines the list of devices to be used (ps/gif/svg).
    \param formats Setting output_formats - default=stringarray()
*/
	void setFormats(stringarray formats) 
		{ formats_ =  formats; } 
	stringarray getFormats() const 
		{ return formats_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string format_;
	stringarray formats_;

private:
  
	friend ostream& operator<<(ostream& s,const OutputHandlerAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
