/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IsoPlotAttributes.h
    \brief Definition of IsoPlot Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Wed Dec  5 12:07:14 2012
*/
   

#ifndef IsoPlotAttributes_H
#define IsoPlotAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "IsoLabel.h"
#include "LevelSelection.h"
#include "Colour.h"
#include "IsoHighlight.h"
#include "IsoShading.h"

namespace magics {

class XmlNode;



class IsoPlotAttributes 
{
public:
//  --  constructor
    IsoPlotAttributes();
    
//  --  destructor
    virtual ~IsoPlotAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const IsoPlotAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	string legend_special_;
	double resolution_;
	string technique_;
	string legend_text_;
	LineStyle style_;
	int thickness_;
	auto_ptr<Colour> colour_;
	auto_ptr<NoIsoHighlight> highlight_;
	auto_ptr<LevelSelection> levelSelection_;
	auto_ptr<NoIsoLabel> label_;
	auto_ptr<NoIsoShading> shading_;
	bool legend_only_;

private:
  
	friend ostream& operator<<(ostream& s,const IsoPlotAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
