/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ContourAttributes.cc
    \brief Implementation of Contour Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed Dec  5 12:07:14 2012
*/    

#include "ContourAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


ContourAttributes::ContourAttributes():
	legend_(ParameterManager::getBool("legend")),
	contour_(MagTranslator<string, IsoPlot>().magics("contour")),
	method_(MagTranslator<string, ContourMethod>().magics("contour_method")),
	floor_(ParameterManager::getDouble("contour_interpolation_floor")),
	ceiling_(ParameterManager::getDouble("contour_interpolation_ceiling")),
	setting_(ParameterManager::getBool("contour_automatic_setting")),
	library_path_(ParameterManager::getString("contour_automatic_library_path")),
	hilo_(MagTranslator<string, HiLoBase>().magics("contour_hilo")),
	grid_(MagTranslator<string, ValuePlotBase>().magics("contour_grid_value_plot"))
{
} 



ContourAttributes::~ContourAttributes()
{
}

    
void ContourAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "contour";

	setAttribute(prefix, "legend", legend_, params);
	setMember(prefix, "contour", contour_, params);
	setMember(prefix, "contour_method", method_, params);
	setAttribute(prefix, "contour_interpolation_floor", floor_, params);
	setAttribute(prefix, "contour_interpolation_ceiling", ceiling_, params);
	setAttribute(prefix, "contour_automatic_setting", setting_, params);
	setAttribute(prefix, "contour_automatic_library_path", library_path_, params);
	setMember(prefix, "contour_hilo", hilo_, params);
	setMember(prefix, "contour_grid_value_plot", grid_, params);
}

void ContourAttributes::copy(const ContourAttributes& other)
{
	legend_ = other.legend_;
	contour_ = auto_ptr<IsoPlot>(other.contour_->clone());
	method_ = auto_ptr<ContourMethod>(other.method_->clone());
	floor_ = other.floor_;
	ceiling_ = other.ceiling_;
	setting_ = other.setting_;
	library_path_ = other.library_path_;
	hilo_ = auto_ptr<HiLoBase>(other.hilo_->clone());
	grid_ = auto_ptr<ValuePlotBase>(other.grid_->clone());
} 


bool ContourAttributes::accept(const string& node)
{	
	if ( magCompare(node, "contour")  )
		return true;

	if ( acceptNode(node, contour_) )
		return true;

	if ( acceptNode(node, method_) )
		return true;

	if ( acceptNode(node, hilo_) )
		return true;

	if ( acceptNode(node, grid_) )
		return true;
	return false;
}

void ContourAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "contour") )
		set(node.attributes());
	else {
		setMember(node.name(), contour_, node);
		setMember(node.name(), method_, node);
		setMember(node.name(), hilo_, node);
		setMember(node.name(), grid_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), contour_, *(*elt)); 
		setMember((*elt)->name(), method_, *(*elt)); 
		setMember((*elt)->name(), hilo_, *(*elt)); 
		setMember((*elt)->name(), grid_, *(*elt)); 
	}
}

void ContourAttributes::print(ostream& out)  const
{
	out << "ContourAttributes[";
	out << "legend = " << legend_;
	out << ", contour = " << *contour_;
	out << ", method = " << *method_;
	out << ", floor = " << floor_;
	out << ", ceiling = " << ceiling_;
	out << ", setting = " << setting_;
	out << ", library_path = " << library_path_;
	out << ", hilo = " << *hilo_;
	out << ", grid = " << *grid_;
	out << "]" << "\n";
}


void ContourAttributes::toxml(ostream& out)  const
{
     out <<  "\"contour\"";
	 out << ", \"legend\":";
	 niceprint(out,legend_);
	 out << ", \"contour\":";
	 contour_->toxml(out);
	 out << ", \"contour_method\":";
	 method_->toxml(out);
	 out << ", \"contour_interpolation_floor\":";
	 niceprint(out,floor_);
	 out << ", \"contour_interpolation_ceiling\":";
	 niceprint(out,ceiling_);
	 out << ", \"contour_automatic_setting\":";
	 niceprint(out,setting_);
	 out << ", \"contour_automatic_library_path\":";
	 niceprint(out,library_path_);
	 out << ", \"contour_hilo\":";
	 hilo_->toxml(out);
	 out << ", \"contour_grid_value_plot\":";
	 grid_->toxml(out);
}
static MagicsParameter<string> legend("legend", "off", "");
static MagicsParameter<string> contour("contour", "on", "");
static MagicsParameter<string> contour_method("contour_method", "automatic", "");
static MagicsParameter<double> contour_interpolation_floor("contour_interpolation_floor", -INT_MAX, "");
static MagicsParameter<double> contour_interpolation_ceiling("contour_interpolation_ceiling", INT_MAX, "");
static MagicsParameter<string> contour_automatic_setting("contour_automatic_setting", "off", "");
static MagicsParameter<string> contour_automatic_library_path("contour_automatic_library_path", "", "");
static MagicsParameter<string> contour_hilo("contour_hilo", "off", "");
static MagicsParameter<string> contour_grid_value_plot("contour_grid_value_plot", "off", "");
#include "IsoPlot.h"
static SimpleObjectMaker<IsoPlot, IsoPlot> on_IsoPlot("on");
static SimpleObjectMaker<IsoPlot, IsoPlot> isoline_IsoPlot("isoline");
static SimpleObjectMaker<NoIsoPlot, IsoPlot> off_NoIsoPlot("off");
static SimpleObjectMaker<NoIsoPlot, IsoPlot> noisoline_NoIsoPlot("noisoline");
#include "Akima474Method.h"
#include "ContourMethod.h"
#include "AutomaticContourMethod.h"
#include "Akima760Method.h"
static SimpleObjectMaker<AutomaticContourMethod, ContourMethod> automatic_AutomaticContourMethod("automatic");
static SimpleObjectMaker<SampleContourMethod, ContourMethod> sample_SampleContourMethod("sample");
static SimpleObjectMaker<ContourMethod, ContourMethod> linear_ContourMethod("linear");
static SimpleObjectMaker<Akima760Method, ContourMethod> akima760_Akima760Method("akima760");
static SimpleObjectMaker<Akima474Method, ContourMethod> akima474_Akima474Method("akima474");
#include "HiLo.h"
static SimpleObjectMaker<HiLo, HiLoBase> on_HiLo("on");
static SimpleObjectMaker<HiLo, HiLoBase> hilo_HiLo("hilo");
static SimpleObjectMaker<NoHiLo, HiLoBase> off_NoHiLo("off");
static SimpleObjectMaker<NoHiLo, HiLoBase> nohilo_NoHiLo("nohilo");
static SimpleObjectMaker<HighHiLo, HiLoBase> hi_HighHiLo("hi");
static SimpleObjectMaker<HighHiLo, HiLoBase> high_HighHiLo("high");
static SimpleObjectMaker<LowHiLo, HiLoBase> lo_LowHiLo("lo");
static SimpleObjectMaker<LowHiLo, HiLoBase> low_LowHiLo("low");
#include "ValuePlot.h"
static SimpleObjectMaker<ValuePlot, ValuePlotBase> on_ValuePlot("on");
static SimpleObjectMaker<ValuePlot, ValuePlotBase> gridvalues_ValuePlot("gridvalues");
static SimpleObjectMaker<NoValuePlot, ValuePlotBase> off_NoValuePlot("off");
static SimpleObjectMaker<NoValuePlot, ValuePlotBase> nogridvalues_NoValuePlot("nogridvalues");
