/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file PageIDAttributes.h
    \brief Definition of PageID Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Wed Dec  5 12:07:15 2012
*/
   

#ifndef PageIDAttributes_H
#define PageIDAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "LogoPlotting.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class PageIDAttributes 
{
public:
//  --  constructor
    PageIDAttributes();
    
//  --  destructor
    virtual ~PageIDAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const PageIDAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	double height_;
	auto_ptr<Colour> colour_;
	bool magics_;
	string user_text_;
	bool system_;
	bool date_;
	bool errors_;
	bool text_;
	auto_ptr<NoLogoPlotting> logo_;
	string font_;
	string font_style_;

private:
  
	friend ostream& operator<<(ostream& s,const PageIDAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
