/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IsoPlotAttributes.h
    \brief Definition of IsoPlot Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:37 2011
*/
   

#ifndef IsoPlotAttributes_H
#define IsoPlotAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "IsoLabel.h"
#include "LevelSelection.h"
#include "Colour.h"
#include "IsoHighlight.h"
#include "IsoShading.h"

namespace magics {

class XmlNode;


template <class P>
class IsoPlotAttributes 
{
public:
//  --  constructor
    IsoPlotAttributes();
    
//  --  destructor
    virtual ~IsoPlotAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const IsoPlotAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Inform the contour object do generate only the legend and not the plot!
    \param legend_only Setting contour_legend_only - default=off
*/
	void setLegend_only(bool legend_only) 
		{ legend_only_ =  legend_only; } 
	bool getLegend_only() const 
		{ return legend_only_; } 
        
/*!
    Magics Information:
    \brief  internal factor for contouring   
    \param resolution Setting contour_internal_reduction_factor - default=4
*/
	void setResolution(double resolution) 
		{ resolution_ =  resolution; } 
	double getResolution() const 
		{ return resolution_; } 
        
/*!
    Magics Information:
    \brief  internal technique for contouring : interpolate/nearest   
    \param technique Setting contour_internal_technique - default=interpolate
*/
	void setTechnique(const string& technique) 
		{ technique_ =  technique; } 
	const string& getTechnique() const 
		{ return technique_; } 
        
/*!
    Magics Information:
    \brief Text to be used in legend
    \param legend_text Setting contour_legend_text - default= 
*/
	void setLegend_text(const string& legend_text) 
		{ legend_text_ =  legend_text; } 
	const string& getLegend_text() const 
		{ return legend_text_; } 
        
/*!
    Magics Information:
    \brief  Style of contour line (SOLID/ DASH/ DOT/ CHAIN_DASH/ CHAIN_DOT) 
    \param style Setting contour_line_style - default=solid
*/
	void setStyle(LineStyle style) 
		{ style_ =  style; } 
	LineStyle getStyle() const 
		{ return style_; } 
        
/*!
    Magics Information:
    \brief  Thickness of contour line 
    \param thickness Setting contour_line_thickness - default=1
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
/*!
    Magics Information:
    \brief  Colour of contour line 
    \param colour Setting contour_line_colour - default=blue
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Plot contour highlights (ON/OFF) 
    \param highlight Setting contour_highlight - default=on
*/
	void setHighlight(NoIsoHighlight* highlight) 
		{ auto_ptr<NoIsoHighlight> tmp(highlight); highlight_ = tmp; } 
	const NoIsoHighlight&  getHighlight() const 
		{ return *highlight_; }
/*!
    Magics Information:
    \brief  See main text for function (COUNT/ INTERVAL/ LEVEL_LIST) 
    \param levelselection Setting contour_level_selection_type - default=count
*/
	void setLevelSelection(LevelSelection* levelselection) 
		{ auto_ptr<LevelSelection> tmp(levelselection); levelSelection_ = tmp; } 
	const LevelSelection&  getLevelSelection() const 
		{ return *levelSelection_; }
/*!
    Magics Information:
    \brief  Plot labels on contour lines (ON/OFF) 
    \param label Setting contour_label - default=on
*/
	void setLabel(NoIsoLabel* label) 
		{ auto_ptr<NoIsoLabel> tmp(label); label_ = tmp; } 
	const NoIsoLabel&  getLabel() const 
		{ return *label_; }
/*!
    Magics Information:
    \brief  Turn shading on (ON/OFF) 
    \param shading Setting contour_shade - default=off
*/
	void setShading(NoIsoShading<P> * shading) 
		{ auto_ptr<NoIsoShading<P> > tmp(shading); shading_ = tmp; } 
	const NoIsoShading<P> &  getShading() const 
		{ return *shading_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	bool legend_only_;
	double resolution_;
	string technique_;
	string legend_text_;
	LineStyle style_;
	int thickness_;
	auto_ptr<Colour> colour_;
	auto_ptr<NoIsoHighlight> highlight_;
	auto_ptr<LevelSelection> levelSelection_;
	auto_ptr<NoIsoLabel> label_;
	auto_ptr<NoIsoShading<P> > shading_;

private:
  
	friend ostream& operator<<(ostream& s,const IsoPlotAttributes<P>& p)
	{ p.print(s); return s; }
};

} // namespace magics
#include "IsoPlotAttributes.cc" 

#endif
