/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ImagePlottingAttributes.h
    \brief Definition of ImagePlotting Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef ImagePlottingAttributes_H
#define ImagePlottingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "LookupTableMode.h"
#include "ColourTableDefinition.h"

namespace magics {

class XmlNode;



class ImagePlottingAttributes 
{
public:
//  --  constructor
    ImagePlottingAttributes();
    
//  --  destructor
    virtual ~ImagePlottingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ImagePlottingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Method for computing the output image according to the Colour table. 
    \param mode Setting image_colour_table_creation_mode - default=equidistant
*/
	void setMode(LookupTableMode* mode) 
		{ auto_ptr<LookupTableMode> tmp(mode); mode_ = tmp; } 
	const LookupTableMode&  getMode() const 
		{ return *mode_; }
/*!
    Magics Information:
    \brief  Method for setting Colour table for imaging. 
    \param colourmethod Setting image_colour_table_type - default=computed
*/
	void setColourMethod(ColourTableDefinition* colourmethod) 
		{ auto_ptr<ColourTableDefinition> tmp(colourmethod); colourMethod_ = tmp; } 
	const ColourTableDefinition&  getColourMethod() const 
		{ return *colourMethod_; }
/*!
    Magics Information:
    \brief  Number of levels 
    \param count Setting image_level_count - default=127
*/
	void setCount(int count) 
		{ count_ =  count; } 
	int getCount() const 
		{ return count_; } 
        
/*!
    Magics Information:
    \brief  Number of pixels/centimetre to be plotted 
 
    \param pixelfrequency Setting image_pixel_selection_frequency - default=10
*/
	void setPixelFrequency(int pixelfrequency) 
		{ pixelFrequency_ =  pixelfrequency; } 
	int getPixelFrequency() const 
		{ return pixelFrequency_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<LookupTableMode> mode_;
	auto_ptr<ColourTableDefinition> colourMethod_;
	int count_;
	int pixelFrequency_;

private:
  
	friend ostream& operator<<(ostream& s,const ImagePlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
